/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class ImageLevelsMapper {
    private static final Logger LOGGER = Logging.getLogger(ImageLevelsMapper.class);
    private int numOverviews;
    private double[][] overViewResolutions;
    private double[] highestResolution;
    private int[] imageChoiceToReaderLookup;
    private boolean innerOverviews = false;
    private String[] levelsDirs;
    ConcurrentHashMap<Integer, ImageMosaicReader> readers = new ConcurrentHashMap();

    public ImageLevelsMapper(Properties properties) {
        int i;
        this.levelsDirs = properties.getProperty("LevelsDirs").split(" ");
        String levels = properties.getProperty("Levels");
        String[] resolutionLevels = levels.split(" ");
        int resolutionGroupsNumber = resolutionLevels.length;
        double[][][] resolutionsSet = new double[resolutionGroupsNumber][][];
        int numResolutions = 0;
        for (i = 0; i < resolutionGroupsNumber; ++i) {
            String[] subLevels = resolutionLevels[i].split(";");
            int subLevelsLenght = subLevels.length;
            if (subLevelsLenght > 1) {
                this.innerOverviews = true;
            }
            resolutionsSet[i] = new double[subLevelsLenght][];
            for (int k = 0; k < subLevelsLenght; ++k) {
                String[] pair = subLevels[k].split(",");
                resolutionsSet[i][k] = new double[2];
                resolutionsSet[i][k][0] = Double.parseDouble(pair[0].trim());
                resolutionsSet[i][k][1] = Double.parseDouble(pair[1].trim());
                ++numResolutions;
            }
        }
        this.numOverviews = numResolutions - 1;
        this.imageChoiceToReaderLookup = new int[numResolutions];
        this.highestResolution = new double[2];
        this.highestResolution[0] = resolutionsSet[0][0][0];
        this.highestResolution[1] = resolutionsSet[0][0][1];
        this.imageChoiceToReaderLookup[0] = 0;
        this.overViewResolutions = this.numOverviews > 0 ? new double[this.numOverviews][2] : null;
        numResolutions = 0;
        for (i = 0; i < resolutionGroupsNumber; ++i) {
            int k;
            int n = k = i != 0 ? 0 : 1;
            while (k < resolutionsSet[i].length) {
                this.overViewResolutions[numResolutions][0] = resolutionsSet[i][k][0];
                this.overViewResolutions[numResolutions][1] = resolutionsSet[i][k][1];
                this.imageChoiceToReaderLookup[++numResolutions] = i;
                ++k;
            }
        }
    }

    public void dispose() {
        for (Map.Entry<Integer, ImageMosaicReader> element : this.readers.entrySet()) {
            try {
                element.getValue().dispose();
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        this.readers.clear();
    }

    protected ImageMosaicReader getReader(Integer imageChoice, String coverageName, URL sourceURL, Hints hints) throws IOException {
        int imageIndex = this.getImageReaderIndex(imageChoice);
        if (this.readers == null) {
            throw new IllegalStateException("This ImagePyramidReader has already been disposed");
        }
        ImageMosaicReader reader = this.readers.get(imageIndex);
        if (reader == null) {
            String extension;
            String levelDirName = this.levelsDirs[imageIndex];
            URL parentUrl = URLs.getParentUrl((URL)sourceURL);
            URL shpFileUrl = URLs.extendUrl((URL)parentUrl, (String)(extension = levelDirName + "/" + coverageName + ".shp"));
            reader = shpFileUrl.getProtocol() != null && shpFileUrl.getProtocol().equalsIgnoreCase("file") && !URLs.urlToFile((URL)shpFileUrl).exists() ? new ImageMosaicReader((Object)URLs.extendUrl((URL)parentUrl, (String)levelDirName), hints) : new ImageMosaicReader((Object)shpFileUrl, hints);
            ImageMosaicReader putByOtherThreadJustNow = this.readers.putIfAbsent(imageIndex, reader);
            if (putByOtherThreadJustNow != null) {
                block5: {
                    try {
                        reader.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block5;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                reader = putByOtherThreadJustNow;
            }
        }
        return reader;
    }

    public int getImageReaderIndex(Integer imageChoice) {
        return this.imageChoiceToReaderLookup[imageChoice];
    }

    public int getNumOverviews() {
        return this.numOverviews;
    }

    public double[][] getOverViewResolutions() {
        return this.overViewResolutions;
    }

    public double[] getHighestResolution() {
        return this.highestResolution;
    }

    public String[] getLevelsDirs() {
        return this.levelsDirs;
    }

    public boolean hasInnerOverviews() {
        return this.innerOverviews;
    }

    public boolean hasReaders() {
        return this.readers != null;
    }
}

