/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class Utils {
    static final Logger LOGGER = Logging.getLogger(Utils.class);

    Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL checkSource(Object source, Hints hints) {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = URLs.fileToUrl((File)sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = URLs.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    sourceFile = URLs.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    sourceFile = null;
                }
            } else {
                sourceURL = URLs.fileToUrl((File)tempFile);
                sourceFile = tempFile;
            }
        } else {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("we really don't know how to convert the thing: " + String.valueOf(source) != null ? source.toString() : "null");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE) && sourceFile != null) {
            String message = Utils.fileStatus(sourceFile);
            LOGGER.fine(message);
        }
        if (sourceFile == null || !sourceFile.exists()) {
            return sourceURL;
        }
        if (!sourceFile.isDirectory()) {
            return sourceURL;
        }
        File directory = sourceFile;
        sourceFile = new File(directory, directory.getName() + ".properties");
        if (LOGGER.isLoggable(Level.FINE) && sourceFile != null) {
            String message = Utils.fileStatus(sourceFile);
            LOGGER.fine(message);
        }
        if (sourceFile.exists()) {
            return URLs.fileToUrl((File)sourceFile);
        }
        File zeroLevelDirectory = new File(directory, "0");
        IOFileFilter directoryFilter = FileFilterUtils.directoryFileFilter();
        File[] numericDirectories = directory.listFiles(new NumericDirectoryFilter());
        File[] directories = directory.listFiles((FileFilter)directoryFilter);
        if (numericDirectories == null || numericDirectories.length == 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("I was unable to determine a structure similar to the GDAL Retile one for the provided path: " + String.valueOf(directory));
            }
            return null;
        }
        if (!zeroLevelDirectory.exists() && directories != null && numericDirectories.length == directories.length) {
            LOGGER.log(Level.INFO, "Detected gdal_retile file structure, moving root files to the '0' subdirectory");
            if (zeroLevelDirectory.mkdir()) {
                IOFileFilter notDirFilter;
                File[] files;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Created '0' subidr, now moving files");
                }
                if ((files = directory.listFiles((FileFilter)(notDirFilter = FileFilterUtils.notFileFilter((IOFileFilter)directoryFilter)))) != null) {
                    for (File f : files) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Moving file" + f.getAbsolutePath());
                        }
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest(Utils.fileStatus(f));
                        }
                        if (f.renameTo(new File(zeroLevelDirectory, f.getName()))) continue;
                        LOGGER.log(Level.WARNING, "Could not move " + f.getAbsolutePath() + " to " + String.valueOf(zeroLevelDirectory) + " check the permission inside the source directory " + f.getParent() + " and target directory " + String.valueOf(zeroLevelDirectory));
                    }
                }
                directories = directory.listFiles((FileFilter)directoryFilter);
            } else {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("I was unable to create the 0 directory. check the file permission in the parent directory:" + sourceFile.getParent());
                }
                return null;
            }
        }
        ArrayList<MosaicInfo> mosaics = new ArrayList<MosaicInfo>();
        ImageMosaicFormat mosaicFactory = new ImageMosaicFormat();
        if (directories != null) {
            for (File subdir : directories) {
                if (mosaicFactory.accepts((Object)subdir, hints)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Trying to build mosaic for the directory:" + subdir.getAbsolutePath());
                    }
                    Object reader = null;
                    try {
                        reader = mosaicFactory.getReader((Object)subdir, hints);
                        String referenceName = Utils.checkConsistency((ImageMosaicReader)reader);
                        MosaicInfo mosaicInfo = new MosaicInfo(subdir, (ImageMosaicReader)reader, referenceName);
                        mosaics.add(mosaicInfo);
                        continue;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.dispose();
                            }
                            catch (Throwable referenceName) {}
                        }
                    }
                }
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to build mosaic for the directory:" + subdir.getAbsolutePath());
            }
        }
        if (mosaics.isEmpty()) {
            return null;
        }
        Collections.sort(mosaics);
        for (int i = 1; i < mosaics.size(); ++i) {
            double[] res;
            double[] resprev = ((MosaicInfo)mosaics.get(i - 1)).getResolutions()[0];
            if (!(resprev[1] > (res = ((MosaicInfo)mosaics.get(i)).getResolutions()[0])[1])) continue;
            LOGGER.log(Level.INFO, "Invalid mosaic, y resolution in " + ((MosaicInfo)mosaics.get(i - 1)).getPath() + " is greater than the one in " + ((MosaicInfo)mosaics.get(i)).getPath() + " whilst x resolutions have the opposite relationship");
            return null;
        }
        Properties properties = new Properties();
        String coverageNames = ((MosaicInfo)mosaics.get(0)).getCoverageNames();
        properties.put("Name", coverageNames != null ? coverageNames : directory.getName());
        properties.put("LevelsNum", String.valueOf(mosaics.size()));
        StringBuilder sbDirNames = new StringBuilder();
        StringBuilder sbLevels = new StringBuilder();
        for (MosaicInfo mi : mosaics) {
            sbDirNames.append(mi.getName()).append(" ");
            Utils.appendResolutionLevels(sbLevels, mi.getResolutions());
        }
        properties.put("LevelsDirs", sbDirNames.toString());
        properties.put("Levels", sbLevels.toString().trim());
        GeneralEnvelope envelope = ((MosaicInfo)mosaics.get(0)).getEnvelope();
        properties.put("Envelope2D", envelope.getMinimum(0) + "," + envelope.getMinimum(1) + " " + envelope.getMaximum(0) + "," + envelope.getMaximum(1));
        try (FileOutputStream os = new FileOutputStream(sourceFile);){
            properties.store(os, "Automatically generated");
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "We could not generate the pyramid property file " + sourceFile.getPath(), e);
            return null;
        }
        if (envelope.getCoordinateReferenceSystem() != null) {
            File prjFile = new File(directory, directory.getName() + ".prj");
            try (PrintWriter pw = new PrintWriter(new FileOutputStream(prjFile));){
                pw.print(envelope.getCoordinateReferenceSystem().toString());
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "We could not write out the projection file " + prjFile.getPath(), e);
                return null;
            }
        }
        return URLs.fileToUrl((File)sourceFile);
    }

    private static void appendResolutionLevels(StringBuilder sbLevels, double[][] resolutions) {
        int numResolutions = resolutions.length;
        for (int i = 0; i < numResolutions - 1; ++i) {
            Utils.appendXYResolutions(sbLevels, resolutions[i]);
            sbLevels.append(";");
        }
        Utils.appendXYResolutions(sbLevels, resolutions[numResolutions - 1]);
        sbLevels.append(" ");
    }

    private static void appendXYResolutions(StringBuilder sbLevels, double[] resolutions) {
        sbLevels.append(resolutions[0]).append(",").append(resolutions[1]);
    }

    private static String checkConsistency(ImageMosaicReader reader) {
        int count = reader.getGridCoverageCount();
        double[][] resolutionLevels = null;
        String referenceName = "_UN$PECIFIED_";
        try {
            if (count > 1) {
                for (String coverageName : reader.getGridCoverageNames()) {
                    if ("_UN$PECIFIED_".equalsIgnoreCase(referenceName)) {
                        referenceName = coverageName;
                        resolutionLevels = reader.getResolutionLevels(coverageName);
                        continue;
                    }
                    double[][] compareLevels = reader.getResolutionLevels(coverageName);
                    boolean homogeneous = org.geotools.gce.imagemosaic.Utils.homogeneousCheck((int)resolutionLevels.length, (double[][])resolutionLevels, (double[][])compareLevels);
                    if (homogeneous) continue;
                    throw new IllegalArgumentException("Coverages need to have same levels structure");
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return referenceName;
    }

    private static String fileStatus(File sourceFile) {
        if (sourceFile == null) {
            throw new NullPointerException("Provided null input to fileStatus method");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file: ").append(FilenameUtils.getFullPath((String)sourceFile.getAbsolutePath())).append("\n");
        builder.append("exists: ").append(sourceFile.exists()).append("\n");
        builder.append("isFile: ").append(sourceFile.isFile()).append("\n");
        builder.append("canRead: ").append(sourceFile.canRead()).append("\n");
        builder.append("canWrite: ").append(sourceFile.canWrite()).append("\n");
        builder.append("canExecute: ").append(sourceFile.canExecute()).append("\n");
        builder.append("isHidden: ").append(sourceFile.isHidden()).append("\n");
        builder.append("lastModified: ").append(sourceFile.lastModified()).append("\n");
        return builder.toString();
    }

    static class NumericDirectoryFilter
    implements FileFilter {
        NumericDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.isDirectory()) {
                return false;
            }
            try {
                Integer.parseInt(pathname.getName());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    static class MosaicInfo
    implements Comparable<MosaicInfo> {
        File directory;
        double[][] resolutions;
        String coverageName;
        GeneralEnvelope envelope;
        String coverageNames = null;

        public String toString() {
            return "MosaicInfo [directory=" + String.valueOf(this.directory) + ", resolutions=" + Arrays.toString((Object[])this.resolutions) + "]";
        }

        MosaicInfo(File directory, ImageMosaicReader reader, String coverageName) {
            this.directory = directory;
            this.coverageName = coverageName;
            try {
                this.envelope = reader.getOriginalEnvelope(coverageName);
                this.resolutions = reader.getResolutionLevels(coverageName);
                int coverageCount = reader.getGridCoverageCount();
                if (coverageCount > 1) {
                    String[] coverages = reader.getGridCoverageNames();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < coverageCount - 1; ++i) {
                        sb.append(coverages[i]).append(",");
                    }
                    sb.append(coverages[coverageCount - 1]);
                    this.coverageNames = sb.toString();
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }

        double[][] getResolutions() {
            return this.resolutions;
        }

        String getCoverageNames() {
            return this.coverageNames;
        }

        String getPath() {
            return this.directory.getPath();
        }

        String getName() {
            return this.directory.getName();
        }

        GeneralEnvelope getEnvelope() {
            return this.envelope;
        }

        @Override
        public int compareTo(MosaicInfo other) {
            return this.resolutions[0][0] > other.resolutions[0][0] ? 1 : -1;
        }
    }
}

