/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.PrjFileReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagepyramid.ImagePyramidReader;
import org.geotools.gce.imagepyramid.Utils;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImagePyramidFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(ImagePyramidFormat.class);

    public ImagePyramidFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImagePyramid");
        info.put("description", "Image pyramidal plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        ImageMosaicFormat formatForParameters = new ImageMosaicFormat();
        ParameterValueGroup readParams = formatForParameters.getReadParameters();
        DefaultParameterDescriptorGroup descriptor = (DefaultParameterDescriptorGroup)readParams.getDescriptor();
        List descriptors = descriptor.descriptors();
        GeneralParameterDescriptor[] descriptorArray = new GeneralParameterDescriptor[descriptors.size()];
        descriptorArray = descriptors.toArray(descriptorArray);
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, descriptorArray));
        this.writeParameters = null;
    }

    public ImagePyramidReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin is a read only plugin!");
    }

    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            throw new NullPointerException("Null parameter provided to the accepts method of this ImagePyramidFormat");
        }
        try {
            URL sourceURL;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Accepts method of ImagePyramid with source" + String.valueOf(source));
            }
            if ((sourceURL = Utils.checkSource(source, hints)) == null) {
                return false;
            }
            LOGGER.fine("accepts: " + String.valueOf(sourceURL));
            try {
                sourceURL.openStream().close();
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return false;
            }
            URL prjURL = URLs.changeUrlExt((URL)sourceURL, (String)"prj");
            CoordinateReferenceSystem tempcrs = null;
            try (PrjFileReader crsReader = new PrjFileReader(Channels.newChannel(prjURL.openStream()));){
                tempcrs = crsReader.getCoordinateReferenceSystem();
            }
            catch (FactoryException e) {
                return false;
            }
            if (tempcrs == null) {
                tempcrs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.FINE, "Unable to find a CRS for this coverage, using a default one: " + tempcrs.toWKT());
            }
            Properties properties = new Properties();
            if (!sourceURL.getPath().endsWith(".properties")) {
                return false;
            }
            LOGGER.fine("loading properties from: " + String.valueOf(sourceURL));
            try (BufferedInputStream propertyStream = new BufferedInputStream(sourceURL.openStream());){
                properties.load(propertyStream);
            }
            catch (Throwable e) {
                return false;
            }
            String envelope = properties.getProperty("Envelope2D");
            if (envelope == null) {
                return false;
            }
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                String[] pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            String levelsNumProp = properties.getProperty("LevelsNum");
            if (levelsNumProp == null) {
                return false;
            }
            String levels = properties.getProperty("Levels");
            if (levels == null) {
                return false;
            }
            return properties.getProperty("Name") != null;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
    }

    public ImagePyramidReader getReader(Object source, Hints hints) {
        try {
            return new ImagePyramidReader(source, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(new StringBuffer("impossible to get a reader for the provided source. The error is ").append(e.getLocalizedMessage()).toString());
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

