/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.SoftValueHashMap;

class DataAccessStoreWrapper
implements DataStore {
    DataAccess delegate;
    SoftValueHashMap<String, Name> NAME_CACHE = new SoftValueHashMap();

    public DataAccessStoreWrapper(DataAccess<FeatureType, Feature> delegate) {
        this.delegate = delegate;
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.delegate.createSchema((FeatureType)featureType);
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.delegate.updateSchema(typeName, (FeatureType)featureType);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.delegate.removeSchema(typeName);
    }

    public List getNames() throws IOException {
        return this.delegate.getNames();
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        FeatureType schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            return (SimpleFeatureType)schema;
        }
        return null;
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return DataUtilities.simple((FeatureSource)this.delegate.getFeatureSource(typeName));
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.updateSchema(name, (FeatureType)featureType);
    }

    public void removeSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.removeSchema(name);
    }

    public String[] getTypeNames() throws IOException {
        List names = this.delegate.getNames();
        String[] typeNames = (String[])names.stream().map(name -> name.getLocalPart()).distinct().sorted().toArray(String[]::new);
        return typeNames;
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        FeatureType schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            return (SimpleFeatureType)schema;
        }
        return null;
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.delegate instanceof DataStore) {
            return ((DataStore)this.delegate).getFeatureSource(typeName);
        }
        Name name = this.getNameFromLocal(typeName);
        return DataUtilities.simple((FeatureSource)this.delegate.getFeatureSource(name));
    }

    private Name getNameFromLocal(String typeName) throws IOException {
        Name result = (Name)this.NAME_CACHE.get((Object)typeName);
        if (result == null) {
            Stream stream = this.delegate.getNames().stream();
            Set names = stream.filter(name -> typeName.equals(name.getLocalPart())).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw new IOException("Could not find a type name '" + typeName + "'");
            }
            if (names.size() > 1) {
                throw new IOException("Found multiple matches for '" + typeName + "': " + names);
            }
            result = (Name)names.iterator().next();
            this.NAME_CACHE.put((Object)typeName, (Object)result);
        }
        return result;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSource(query.getTypeName());
        if (fs == null) {
            throw new IOException("Could not find feature type mentioned in query: '" + query.getTypeName() + "'");
        }
        if (fs instanceof SimpleFeatureStore) {
            ((SimpleFeatureStore)fs).setTransaction(transaction);
        }
        return new DelegateFeatureReader((FeatureType)((SimpleFeatureType)fs.getSchema()), (FeatureIterator)fs.getFeatures().features());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public boolean wraps(DataAccess access) {
        return this.delegate == access;
    }
}

