/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.numeric;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.numeric.DoubleFileNameExtractorSPI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericFileNameExtractorTest {
    private SimpleFeature feature;

    @Before
    public void setup() throws SchemaException {
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"id:int,value:Double");
        this.feature = DataUtilities.createFeature((SimpleFeatureType)ft, (String)"1|null");
    }

    @Test
    public void testNoGroupExtraction() {
        PropertiesCollectorSPI spi = this.getDoubleFileNameSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]+\\.[0-9]", Arrays.asList("value"));
        File file = new File("polyphemus_20.3_.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        Double value = (Double)this.feature.getAttribute("value");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((double)20.3, (double)value, (double)0.0);
    }

    @Test
    public void testFailedExtraction() {
        PropertiesCollectorSPI spi = this.getDoubleFileNameSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]+\\.[0-9]", Arrays.asList("value"));
        File file = new File("polyphemus_20130301_.nc");
        collector.collect(file);
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> collector.setProperties(this.feature));
        Assert.assertEquals((Object)"No matches found for: NumericFileNameExtractor{targetClass=class java.lang.Double, fullPath=false, pattern=[0-9]+\\.[0-9]}", (Object)ex.getMessage());
    }

    private PropertiesCollectorSPI getDoubleFileNameSpi() {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        for (PropertiesCollectorSPI spi : spis) {
            if (!spi.getName().equals(DoubleFileNameExtractorSPI.class.getSimpleName())) continue;
            return spi;
        }
        return null;
    }
}

