/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.ROI;
import org.geotools.gce.imagemosaic.egr.Binarizator;
import org.geotools.gce.imagemosaic.egr.Tile;
import org.geotools.util.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class BinarizatorTest {
    private static final Logger LOGGER = Logging.getLogger(BinarizatorTest.class);
    private static final int TILE_WIDTH = 64;
    private static final int TILE_HEIGHT = 64;
    GeometryFactory gf = new GeometryFactory();

    @Test
    public void testTileNum() {
        Polygon bbox = this.createBBox(0.0, 0.0, 6400.0, 6400.0);
        Binarizator bin = new Binarizator(bbox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        bin = new Binarizator(bbox, 257, 256, 64, 64);
        Assert.assertEquals((long)20L, (long)bin.getActiveTiles().size());
        bin = new Binarizator(bbox, 257, 257, 64, 64);
        Assert.assertEquals((long)25L, (long)bin.getActiveTiles().size());
    }

    @Test
    @Ignore
    public void testPixelNumber() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Polygon feature = this.createBBox(100.0, 100.0, 540.0, 540.0);
        boolean added = bin.add((Geometry)feature);
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        LOGGER.info("Checking tile : " + bin.getActiveTiles().get(3));
        Assert.assertEquals((long)0L, (long)((Tile)bin.getActiveTiles().get(1)).getCoverageCount());
        Assert.assertEquals((long)2025L, (long)((Tile)bin.getActiveTiles().get(3)).getCoverageCount());
    }

    @Test
    public void testTileRemoval() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        Polygon feature = this.createBBox(0.0, 0.0, 640.0, 640.0);
        boolean added = bin.add((Geometry)feature);
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((long)15L, (long)bin.getActiveTiles().size());
    }

    @Test
    public void testTileRemovalRaster() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        Polygon feature = this.createBBox(0.0, 0.0, 640.0, 640.0);
        boolean added = bin.add(BinarizatorTest.toRasterROI(feature));
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((long)15L, (long)bin.getActiveTiles().size());
    }

    @Test
    public void testTileRemovalRasterOffset() {
        Polygon reqBBox = this.createBBox(1000.0, 1000.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        Polygon feature = this.createBBox(1000.0, 1000.0, 1640.0, 1640.0);
        boolean added = bin.add(BinarizatorTest.toRasterROI(feature));
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((long)15L, (long)bin.getActiveTiles().size());
    }

    @NotNull
    private static ROI toRasterROI(Polygon feature) {
        return new ROI((RenderedImage)new ROIGeometry((Geometry)feature).getAsImage());
    }

    @Test
    public void testFeatRemovalInMissingTile() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Polygon feature = this.createBBox(0.0, 0.0, 640.0, 640.0);
        boolean added = bin.add((Geometry)feature);
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((String)"Tile not removed", (long)15L, (long)bin.getActiveTiles().size());
        Polygon hidden = this.createBBox(10.0, 10.0, 600.0, 600.0);
        boolean addedhidden = bin.add((Geometry)hidden);
        Assert.assertFalse((String)"Hidden feature has been added", (boolean)addedhidden);
    }

    @Test
    public void testFeatRemovalInMissingTileRaster() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Polygon feature = this.createBBox(0.0, 0.0, 640.0, 640.0);
        boolean added = bin.add(BinarizatorTest.toRasterROI(feature));
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((String)"Tile not removed", (long)15L, (long)bin.getActiveTiles().size());
        Polygon hidden = this.createBBox(10.0, 10.0, 600.0, 600.0);
        boolean addedhidden = bin.add(BinarizatorTest.toRasterROI(hidden));
        Assert.assertFalse((String)"Hidden feature has been added", (boolean)addedhidden);
    }

    @Test
    public void testHiddenFeature() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        Polygon feature = this.createBBox(9.0, 9.0, 639.0, 639.0);
        boolean added = bin.add((Geometry)feature);
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((String)"Tile should not be removed", (long)16L, (long)bin.getActiveTiles().size());
        Polygon hidden = this.createBBox(10.0, 10.0, 600.0, 600.0);
        boolean addedhidden = bin.add((Geometry)hidden);
        Assert.assertFalse((String)"Hidden feature has been added", (boolean)addedhidden);
    }

    @Test
    public void testHiddenFeatureRaster() {
        Polygon reqBBox = this.createBBox(0.0, 0.0, 2560.0, 2560.0);
        Binarizator bin = new Binarizator(reqBBox, 256, 256, 64, 64);
        Assert.assertEquals((long)16L, (long)bin.getActiveTiles().size());
        Polygon feature = this.createBBox(9.0, 9.0, 639.0, 639.0);
        boolean added = bin.add(BinarizatorTest.toRasterROI(feature));
        Assert.assertTrue((String)"Feature not added", (boolean)added);
        Assert.assertEquals((String)"Tile should not be removed", (long)16L, (long)bin.getActiveTiles().size());
        Polygon hidden = this.createBBox(10.0, 10.0, 600.0, 600.0);
        boolean addedhidden = bin.add(BinarizatorTest.toRasterROI(hidden));
        Assert.assertFalse((String)"Hidden feature has been added", (boolean)addedhidden);
    }

    protected Polygon createBBox(double x0, double y0, double x1, double y1) {
        CoordinateArraySequence points = new CoordinateArraySequence(5, 2);
        points.setOrdinate(0, 0, x0);
        points.setOrdinate(0, 1, y0);
        points.setOrdinate(1, 0, x1);
        points.setOrdinate(1, 1, y0);
        points.setOrdinate(2, 0, x1);
        points.setOrdinate(2, 1, y1);
        points.setOrdinate(3, 0, x0);
        points.setOrdinate(3, 1, y1);
        points.setOrdinate(4, 0, x0);
        points.setOrdinate(4, 1, y0);
        LinearRing lr = new LinearRing((CoordinateSequence)points, this.gf);
        return new Polygon(lr, null, this.gf);
    }
}

