/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.gce.imagemosaic.SpatialRequestHelper;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.junit.Assert;
import org.junit.Test;

public class SpatialRequestHelperTest
extends Assert {
    @Test
    public void testNoRequest() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)coverageProperties.rasterArea);
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedBBox, (Object)sourceBBox);
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double scale = 1.0;
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[1], (double)1.0E-6);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(coverageProperties.rasterArea), (Bounds)sourceBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
        SpatialRequestHelperTest.assertNotNull((Object)spatialRequestHelper.toString());
        spatialRequestHelper.setAccurateResolution(true);
        spatialRequestHelper.compute();
        double[] computedResolution2 = spatialRequestHelper.getComputedResolution();
        SpatialRequestHelperTest.assertEquals((double)computedResolution[0], (double)computedResolution2[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)computedResolution[1], (double)computedResolution2[1], (double)1.0E-6);
    }

    @Test
    public void testBasic2() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        ReferencedEnvelope requestedBBox = new ReferencedEnvelope(0.0, 180.0, 0.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 250, 250);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)new GeneralBounds((Bounds)requestedBBox)));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)requestedRasterArea);
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedBBox, (Object)requestedBBox);
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double scale = 2.0;
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[1], (double)1.0E-6);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)requestedBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
    }

    @Test
    public void testBasic3() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 100.0, -20.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        ReferencedEnvelope requestedBBox = new ReferencedEnvelope(0.0, 180.0, 0.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 250, 250);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)new GeneralBounds((Bounds)requestedBBox)));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isNeedsReprojection());
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        ReferencedEnvelope finalReferencedEnvelope = new ReferencedEnvelope(0.0, 100.0, 0.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        SpatialRequestHelperTest.assertEquals((Object)computedBBox, (Object)finalReferencedEnvelope);
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)requestedBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)CRS.transform((MathTransform)gridToEnvelopeMapper.createTransform().inverse(), (Bounds)computedBBox).toRectangle2D().getBounds());
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
    }

    @Test
    public void testReprojectQuick() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:27700");
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(414000.0, 420000.0, 237000.0, 301000.0, sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D(sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(new ReferencedEnvelope(-1.7973440460762267, -1.7061039437509753, 52.03105268214016, 52.60660481087451, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 256, 256), (Bounds)new GeneralBounds((Bounds)new ReferencedEnvelope(-1.9868610903408341, -1.1430930819885086, 51.938491047471814, 52.70566810107558, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84))));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle destinationRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)destinationRasterArea.isEmpty());
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
    }

    @Test
    public void testBasicReproject() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(8.0, 11.0, 42.0, 44.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 256, 256);
        CoordinateReferenceSystem requestCRS = CRS.decode((String)"EPSG:3857");
        GeneralBounds requestedBBox = CRS.transform((Bounds)sourceBBox, (CoordinateReferenceSystem)requestCRS);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)requestedBBox));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)requestedRasterArea);
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)new GeneralBounds((Bounds)computedBBox).equals((Bounds)sourceBBox, 1.0E-4, true));
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double scale = 3.90625;
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[1], (double)1.0E-6);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)sourceBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
    }

    @Test
    public void testBasic2Reproject() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 180.0, -70.0, 70.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 256, 256);
        CoordinateReferenceSystem requestCRS = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope requestedBBox_ = new ReferencedEnvelope(0.0, 180.0, 0.0, 70.0, (CoordinateReferenceSystem)sourceCRS);
        GeneralBounds requestedBBox = CRS.transform((Bounds)requestedBBox_, (CoordinateReferenceSystem)requestCRS);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)requestedBBox));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)requestedRasterArea);
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)new GeneralBounds((Bounds)computedBBox).equals((Bounds)requestedBBox_, 1.0E-4, true));
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double scaleX = 1.953125;
        double scaleY = 1.953125;
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)(scaleX * XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)(scaleY * XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[1], (double)1.0E-6);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)requestedBBox_);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
        spatialRequestHelper.setAccurateResolution(true);
        spatialRequestHelper.compute();
        double[] computedResolution2 = spatialRequestHelper.getComputedResolution();
        SpatialRequestHelperTest.assertNotEquals((double)computedResolution[0], (double)computedResolution2[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertNotEquals((double)computedResolution[1], (double)computedResolution2[1], (double)1.0E-6);
    }

    @Test
    public void testBasic3Reproject() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 100.0, -20.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 256, 256);
        CoordinateReferenceSystem requestCRS = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope requestedBBox_ = new ReferencedEnvelope(0.0, 180.0, 0.0, 70.0, (CoordinateReferenceSystem)sourceCRS);
        GeneralBounds requestedBBox = CRS.transform((Bounds)requestedBBox_, (CoordinateReferenceSystem)requestCRS);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)requestedBBox));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertTrue((boolean)spatialRequestHelper.isNeedsReprojection());
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        ReferencedEnvelope finalReferencedEnvelope = new ReferencedEnvelope(0.0, 100.0, 0.0, 70.0, (CoordinateReferenceSystem)sourceCRS);
        SpatialRequestHelperTest.assertTrue((boolean)new GeneralBounds((Bounds)computedBBox).equals((Bounds)finalReferencedEnvelope, 1.0E-4, true));
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)requestedBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)new Rectangle(0, 0, 142, 256));
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(computedRasterArea), (Bounds)finalReferencedEnvelope);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
    }

    @Test
    public void testBasic() throws Exception {
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope sourceBBox = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)sourceCRS);
        coverageProperties.setBBox(sourceBBox);
        coverageProperties.setCrs2D((CoordinateReferenceSystem)sourceCRS);
        Rectangle sourceRasterArea = new Rectangle(0, 0, 1000, 1000);
        coverageProperties.setRasterArea(sourceRasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(sourceRasterArea), (Bounds)sourceBBox);
        AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
        coverageProperties.setGridToWorld2D((MathTransform2D)sourceGridToWorldTransform);
        coverageProperties.setFullResolution(new double[]{XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform), XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)});
        coverageProperties.setGeographicBBox(sourceBBox);
        coverageProperties.setGeographicCRS2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SpatialRequestHelper spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        spatialRequestHelper.setAccurateResolution(false);
        GridEnvelope2D requestedRasterArea = new GridEnvelope2D(0, 0, 256, 256);
        spatialRequestHelper.setRequestedGridGeometry(new GridGeometry2D((GridEnvelope)requestedRasterArea, (Bounds)new GeneralBounds((Bounds)sourceBBox)));
        spatialRequestHelper.compute();
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isEmpty());
        SpatialRequestHelperTest.assertFalse((boolean)spatialRequestHelper.isNeedsReprojection());
        Rectangle computedRasterArea = spatialRequestHelper.getComputedRasterArea();
        SpatialRequestHelperTest.assertFalse((boolean)computedRasterArea.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedRasterArea, (Object)requestedRasterArea);
        BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
        SpatialRequestHelperTest.assertFalse((boolean)computedBBox.isEmpty());
        SpatialRequestHelperTest.assertEquals((Object)computedBBox, (Object)sourceBBox);
        AffineTransform computedG2W = spatialRequestHelper.getComputedGridToWorld();
        SpatialRequestHelperTest.assertNotNull((Object)computedG2W);
        double[] computedResolution = spatialRequestHelper.getComputedResolution();
        double scale = 3.90625;
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleX0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)(scale * XAffineTransform.getScaleY0((AffineTransform)sourceGridToWorldTransform)), (double)computedResolution[1], (double)1.0E-6);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D((Rectangle)requestedRasterArea), (Bounds)sourceBBox);
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        double[] expectedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToEnvelopeMapper.createAffineTransform()), XAffineTransform.getScaleY0((AffineTransform)gridToEnvelopeMapper.createAffineTransform())};
        SpatialRequestHelperTest.assertNotNull((Object)computedResolution);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[0], (double)computedResolution[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)expectedResolution[1], (double)computedResolution[1], (double)1.0E-6);
        SpatialRequestHelperTest.assertNotNull((Object)spatialRequestHelper.toString());
        spatialRequestHelper.setAccurateResolution(true);
        spatialRequestHelper.compute();
        double[] computedResolution2 = spatialRequestHelper.getComputedResolution();
        SpatialRequestHelperTest.assertEquals((double)computedResolution[0], (double)computedResolution2[0], (double)1.0E-6);
        SpatialRequestHelperTest.assertEquals((double)computedResolution[1], (double)computedResolution2[1], (double)1.0E-6);
    }
}

