/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DefaultRepository;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.TypeBuilder;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ImageMosaicRepositoryTest {
    static final GeneralParameterValue[] NO_DEFERRED_LOAD;
    static final ImageMosaicFormat FORMAT;
    @Rule
    public TemporaryFolder crsMosaicFolder = new TemporaryFolder();

    @Test
    public void createFromExistingStore() throws Exception {
        URL storeUrl = TestData.url((Object)this, (String)"rgba");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("rgbaShapefile");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        for (File file : testDirectory.listFiles(f -> f.getName().startsWith("rgba"))) {
            file.delete();
        }
        ImageMosaicReader reader = FORMAT.getReader((Object)testDirectory);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        this.removeSupportFiles(testDirectory);
        for (File f2 : testDirectory.listFiles(f -> f.getName().startsWith(testDirectory.getName()))) {
            String extension = FilenameUtils.getExtension((String)f2.getName());
            f2.renameTo(new File(testDirectory, "test." + extension));
        }
        Properties properties = new Properties();
        properties.put("StoreName", "test");
        try (FileOutputStream fos = new FileOutputStream(new File(testDirectory, "datastore.properties"));){
            properties.store(fos, null);
        }
        properties = new Properties();
        properties.put("UseExistingSchema", "true");
        properties.put("TypeName", "test");
        fos = new FileOutputStream(new File(testDirectory, "indexer.properties"));
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
        DefaultRepository repository = new DefaultRepository();
        ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)new File(testDirectory, "test.shp")));
        repository.register("test", (DataAccess)ds);
        Hints hints = new Hints((RenderingHints.Key)Hints.REPOSITORY, (Object)repository);
        reader = FORMAT.getReader((Object)testDirectory, hints);
        Assert.assertNotNull((Object)reader);
        GridCoverage2D coverage = reader.read(NO_DEFERRED_LOAD);
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void createFromExistingDataAccess() throws Exception {
        this.createFromExistingDataAccess((ds, name) -> new TestDataAccess((Name)name, (DataStore)ds));
    }

    @Test
    public void createFromExistingDataAccessWithComplex() throws Exception {
        this.createFromExistingDataAccess((ds, name) -> {
            try {
                SimpleFeatureType schema = (SimpleFeatureType)ds.getSchema(name);
                FeatureType featureType = this.buildComplexTypeFromSimple(schema);
                return new TestDataAccessWithComplex((Name)name, featureType, (DataStore)ds);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void createFromExistingDataAccess(BiFunction<DataStore, Name, DataAccess> dataAccessProvider) throws Exception {
        URL storeUrl = TestData.url((Object)this, (String)"rgba");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("rgbaShapefile");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        for (File file : testDirectory.listFiles(f -> f.getName().startsWith("rgba"))) {
            file.delete();
        }
        ImageMosaicReader reader = FORMAT.getReader((Object)testDirectory);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        this.removeSupportFiles(testDirectory);
        for (File f2 : testDirectory.listFiles(f -> f.getName().startsWith(testDirectory.getName()))) {
            String extension = FilenameUtils.getExtension((String)f2.getName());
            f2.renameTo(new File(testDirectory, "test." + extension));
        }
        Properties properties = new Properties();
        properties.put("StoreName", "foo:test");
        try (FileOutputStream fos = new FileOutputStream(new File(testDirectory, "datastore.properties"));){
            properties.store(fos, null);
        }
        properties = new Properties();
        properties.put("UseExistingSchema", "true");
        properties.put("TypeName", "test");
        fos = new FileOutputStream(new File(testDirectory, "indexer.properties"));
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
        DefaultRepository repository = new DefaultRepository();
        ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)new File(testDirectory, "test.shp")));
        NameImpl name = new NameImpl("foo", "test");
        DataAccess dataAccess = dataAccessProvider.apply((DataStore)ds, (Name)name);
        repository.register((Name)name, dataAccess);
        Hints hints = new Hints((RenderingHints.Key)Hints.REPOSITORY, (Object)repository);
        reader = FORMAT.getReader((Object)testDirectory, hints);
        Assert.assertNotNull((Object)reader);
        GridCoverage2D coverage = reader.read(NO_DEFERRED_LOAD);
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
        ds.dispose();
    }

    @Test
    public void createFromEmptyStore() throws Exception {
        URL storeUrl = TestData.url((Object)this, (String)"rgba");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("rgbaShapefile");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        for (File file : testDirectory.listFiles(f -> f.getName().startsWith("rgba"))) {
            file.delete();
        }
        Properties properties = new Properties();
        properties.put("StoreName", "test");
        try (FileOutputStream fos = new FileOutputStream(new File(testDirectory, "datastore.properties"));){
            properties.store(fos, null);
        }
        properties = new Properties();
        properties.put("TypeName", "abcd");
        fos = new FileOutputStream(new File(testDirectory, "indexer.properties"));
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
        DefaultRepository repository = new DefaultRepository();
        Map<String, URL> params = Collections.singletonMap(ShapefileDataStoreFactory.URLP.key, URLs.fileToUrl((File)testDirectory));
        DataStore ds = new ShapefileDataStoreFactory().createDataStore(params);
        Assert.assertNotNull((Object)ds);
        repository.register("test", (DataAccess)ds);
        Hints hints = new Hints((RenderingHints.Key)Hints.REPOSITORY, (Object)repository);
        ImageMosaicReader reader = FORMAT.getReader((Object)testDirectory, hints);
        File expectedIndexFile = new File(testDirectory, "abcd.shp");
        Assert.assertTrue((String)(expectedIndexFile.getAbsolutePath() + " does not exist"), (boolean)expectedIndexFile.exists());
        Assert.assertNotNull((Object)reader);
        GridCoverage2D coverage = reader.read(NO_DEFERRED_LOAD);
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
        ds.dispose();
    }

    @Test
    public void createFromEmptyStoreWithNoProjection() throws Exception {
        URL storeUrl = TestData.url((Object)this, (String)"rgba");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("rgba_no_proj");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        for (File file : testDirectory.listFiles(f -> f.getName().startsWith("rgba"))) {
            file.delete();
        }
        for (File file : testDirectory.listFiles(f -> f.getName().endsWith("prj"))) {
            file.delete();
        }
        ImageMosaicReader reader = FORMAT.getReader((Object)testDirectory);
        Assert.assertNotNull((Object)reader);
        GridCoverage2D coverage = reader.read(NO_DEFERRED_LOAD);
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void createFromEmptyStoreWithNoProjectionGeoTif() throws Exception {
        URL storeUrl = TestData.url((Object)this, (String)"nocrs");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("no_crs");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        for (File file : testDirectory.listFiles(f -> f.getName().endsWith("prj"))) {
            file.delete();
        }
        ImageMosaicReader reader = FORMAT.getReader((Object)testDirectory);
        Assert.assertNotNull((Object)reader);
        GridCoverage2D coverage = reader.read(NO_DEFERRED_LOAD);
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
    }

    private void removeSupportFiles(File directory) {
        new File(directory, "sample_image.dat").delete();
        new File(directory, directory.getName() + ".properties").delete();
    }

    FeatureType buildComplexTypeFromSimple(SimpleFeatureType base) {
        TypeBuilder typeBuilder = new TypeBuilder(CommonFactoryFinder.getFeatureTypeFactory(null));
        String nsURI = "http://www.geotools.org/test";
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        for (AttributeDescriptor ad : base.getAttributeDescriptors()) {
            AttributeDescriptor mappedDescriptor;
            GeometryType at;
            String name = ad.getLocalName();
            String namespaceURI = nsURI;
            ab.init(ad);
            ab.setMinOccurs(0);
            if (ad instanceof GeometryDescriptor) {
                at = ab.buildGeometryType();
                ab.setCRS(((GeometryDescriptor)ad).getCoordinateReferenceSystem());
                mappedDescriptor = ab.buildDescriptor((Name)new NameImpl(namespaceURI, name), at);
            } else {
                at = ab.buildType();
                mappedDescriptor = ab.buildDescriptor((Name)new NameImpl(namespaceURI, name), (AttributeType)at);
            }
            typeBuilder.add((PropertyDescriptor)mappedDescriptor);
        }
        AttributeDescriptor metadataDescriptor = this.buildSimpleDescriptor((Name)new NameImpl("metadata"), String.class);
        typeBuilder.add((PropertyDescriptor)metadataDescriptor);
        AttributeDescriptor quicklookDescriptor = this.buildSimpleDescriptor((Name)new NameImpl("quicklook"), byte[].class);
        typeBuilder.add((PropertyDescriptor)quicklookDescriptor);
        AttributeDescriptor linksDescriptor = this.buildFeatureListDescriptor((Name)new NameImpl("ogcLinks"), base);
        typeBuilder.add((PropertyDescriptor)linksDescriptor);
        typeBuilder.setName("product");
        typeBuilder.setNamespaceURI(nsURI);
        return typeBuilder.feature();
    }

    private AttributeDescriptor buildSimpleDescriptor(Name name, Class binding) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.name(name.getLocalPart()).namespaceURI(name.getNamespaceURI());
        ab.setBinding(binding);
        AttributeDescriptor descriptor = ab.buildDescriptor(name, ab.buildType());
        return descriptor;
    }

    private AttributeDescriptor buildFeatureListDescriptor(Name name, SimpleFeatureType schema) {
        return this.buildFeatureDescriptor(name, schema, 0, Integer.MAX_VALUE);
    }

    private AttributeDescriptor buildFeatureDescriptor(Name name, SimpleFeatureType schema, int minOccurs, int maxOccurs) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.name(name.getLocalPart()).namespaceURI(name.getNamespaceURI());
        ab.setMinOccurs(minOccurs);
        ab.setMaxOccurs(maxOccurs);
        AttributeDescriptor descriptor = ab.buildDescriptor(name, (AttributeType)schema);
        return descriptor;
    }

    static {
        FORMAT = new ImageMosaicFormat();
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        NO_DEFERRED_LOAD = new GeneralParameterValue[]{useJai};
    }

    private static class TestDataAccessWithComplex
    extends TestDataAccess {
        private final FeatureType complexType;

        public TestDataAccessWithComplex(Name baseName, FeatureType complexType, DataStore delegate) {
            super(baseName, delegate);
            this.complexType = complexType;
        }

        @Override
        public List<Name> getNames() throws IOException {
            return Arrays.asList(this.name, this.complexType.getName());
        }

        @Override
        public FeatureType getSchema(Name name) throws IOException {
            if (name.equals((Object)this.complexType.getName())) {
                return this.complexType;
            }
            return super.getSchema(name);
        }
    }

    private static class TestDataAccess
    implements DataAccess {
        private DataStore delegate;
        protected Name name;

        public TestDataAccess(Name name, DataStore delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public void createSchema(FeatureType featureType) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void removeSchema(Name typeName) throws IOException {
            throw new UnsupportedOperationException();
        }

        public List<Name> getNames() throws IOException {
            return Arrays.asList(this.name);
        }

        public FeatureType getSchema(Name name) throws IOException {
            if (this.name.equals((Object)name)) {
                return this.delegate.getSchema(name.getLocalPart());
            }
            return null;
        }

        public FeatureSource getFeatureSource(Name typeName) throws IOException {
            if (this.name.equals((Object)typeName)) {
                return this.delegate.getFeatureSource(this.name.getLocalPart());
            }
            return null;
        }

        public void dispose() {
            this.delegate.dispose();
        }
    }
}

