/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.logging.Logging;

class ResolutionExtractor
extends PropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(ResolutionExtractor.class);
    Axis axis = Axis.BOTH;

    public ResolutionExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, Axis axis) {
        super(spi, propertyNames);
        this.axis = axis;
    }

    @Override
    public PropertiesCollector collect(GridCoverage2DReader gridCoverageReader) {
        try {
            double[][] resolutionLevels = gridCoverageReader.getResolutionLevels();
            if (this.axis == Axis.X) {
                this.addMatch("" + resolutionLevels[0][0]);
            } else if (this.axis == Axis.Y) {
                this.addMatch("" + resolutionLevels[0][1]);
            } else {
                this.addMatch("" + Math.max(resolutionLevels[0][0], resolutionLevels[0][1]));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return this;
    }

    Double getResolution() {
        block3: {
            String resolutionStr;
            String string = resolutionStr = !this.getMatches().isEmpty() ? this.getMatches().get(0) : null;
            if (resolutionStr != null) {
                try {
                    return Double.parseDouble(resolutionStr);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        Double res = this.getResolution();
        if (res == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No matches found for this property extractor:");
            }
            throw new IllegalArgumentException("No matches found for this property extractor");
        }
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, (Object)res);
        }
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        Double res = this.getResolution();
        if (res == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No matches found for this property extractor:");
        }
        for (String propertyName : this.getPropertyNames()) {
            map.put(propertyName, res);
        }
    }

    static enum Axis {
        X,
        Y,
        BOTH;

    }
}

