/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.logging.Logging;

class DateExtractor
extends PropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(DateExtractor.class);

    public DateExtractor(PropertiesCollectorSPI spi, List<String> propertyNames) {
        super(spi, propertyNames);
    }

    @Override
    public PropertiesCollector collect(GridCoverage2DReader gridCoverageReader) {
        String value = ((GeoTiffReader)gridCoverageReader).getMetadata().getAsciiTIFFTag("306");
        if (value != null) {
            this.addMatch(value);
        } else {
            this.addMatch("");
        }
        return this;
    }

    private Date getDate() {
        String dateStr;
        String string = dateStr = !this.getMatches().isEmpty() ? this.getMatches().get(0) : null;
        if (dateStr != null && !dateStr.isEmpty()) {
            try {
                return new SimpleDateFormat("yyyy:mm:dd hh:mm:ss").parse(this.getMatches().get(0));
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, "Failed to parse date: " + dateStr, e);
            }
        }
        return null;
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        Date date = this.getDate();
        if (date != null) {
            for (String propertyName : this.getPropertyNames()) {
                feature.setAttribute(propertyName, (Object)date);
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        Date date = this.getDate();
        if (date != null) {
            for (String propertyName : this.getPropertyNames()) {
                map.put(propertyName, date);
            }
        }
    }
}

