/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import java.util.logging.Level;
import org.geotools.api.filter.Filter;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.granulecollector.BaseSubmosaicProducer;
import org.geotools.util.Utilities;

public class DefaultSubmosaicProducer
extends BaseSubmosaicProducer {
    private final Filter granuleFilter;

    public DefaultSubmosaicProducer(RasterLayerResponse rasterLayerResponse, Filter granuleFilter, boolean dryRun) {
        super(rasterLayerResponse, dryRun);
        this.granuleFilter = granuleFilter;
    }

    @Override
    public boolean accept(GranuleDescriptor granuleDescriptor) {
        Utilities.ensureNonNull((String)"granuleDescriptor", (Object)granuleDescriptor);
        if (this.granuleFilter.evaluate((Object)granuleDescriptor.getOriginator())) {
            return this.acceptGranule(granuleDescriptor);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("We filtered out the granule " + granuleDescriptor.toString());
        }
        return false;
    }
}

