/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.geotools.api.data.Query;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.util.factory.Hints;

public class CatalogConfigurationBeans {
    public static final Hints.Key COVERAGE_NAME = new Hints.Key(String.class);
    private Map<String, CatalogConfigurationBean> configurations;
    private CatalogConfigurationBean loneConfiguration;

    public CatalogConfigurationBeans(Map<String, CatalogConfigurationBean> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            throw new IllegalArgumentException("The configuration map is null or empty");
        }
        this.configurations = configurations;
        if (this.configurations.isEmpty()) {
            throw new IllegalArgumentException("The configuration map is null or empty");
        }
        if (this.configurations.size() == 1) {
            this.loneConfiguration = this.configurations.values().iterator().next();
        }
    }

    public CatalogConfigurationBeans(CatalogConfigurationBean loneConfiguration) {
        if (loneConfiguration == null) {
            throw new IllegalArgumentException("The configuration is null");
        }
        this.loneConfiguration = loneConfiguration;
    }

    public CatalogConfigurationBeans() {
        this.loneConfiguration = new CatalogConfigurationBean();
    }

    public CatalogConfigurationBeans(List<MosaicConfigurationBean> beans) {
        this(beans.stream().collect(Collectors.toMap(c -> c.getName(), c -> c.getCatalogConfigurationBean(), (c1, c2) -> c1)));
    }

    public CatalogConfigurationBean getByTypeName(String typeName) {
        if (this.loneConfiguration != null) {
            return this.loneConfiguration;
        }
        return this.configurations.values().stream().filter(c -> Objects.equals(typeName, c.getTypeName())).findFirst().orElse(null);
    }

    public CatalogConfigurationBean getByTypeQuery(Query q) {
        if (this.loneConfiguration != null) {
            return this.loneConfiguration;
        }
        String coverageName = (String)q.getHints().get((Object)COVERAGE_NAME);
        if (coverageName != null) {
            return this.configurations.get(coverageName);
        }
        return null;
    }

    public CatalogConfigurationBean first() {
        if (this.loneConfiguration != null) {
            return this.loneConfiguration;
        }
        return this.configurations.values().iterator().next();
    }

    public int size() {
        if (this.loneConfiguration != null) {
            return 1;
        }
        return this.configurations.size();
    }

    public Set<String> getTypeNames() {
        if (this.loneConfiguration != null && this.loneConfiguration.getTypeName() != null) {
            return Collections.singleton(this.loneConfiguration.getTypeName());
        }
        if (this.configurations != null) {
            return this.configurations.values().stream().filter(c -> c.getTypeName() != null).map(c -> c.getTypeName()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

