/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class RATCollector {
    private final int band;
    Map<String, List<String>> allRows = new TreeMap<String, List<String>>();
    Function<PAMDataset.PAMRasterBand.Row, String> keyBuilder;
    Integer countField;

    public RATCollector(int band, PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat) {
        this.band = band;
        List fields = rat.getFieldDefn();
        int maxField = -1;
        int minField = -1;
        for (int i = 0; i < fields.size(); ++i) {
            PAMDataset.PAMRasterBand.FieldDefn field = (PAMDataset.PAMRasterBand.FieldDefn)fields.get(i);
            if (PAMDataset.PAMRasterBand.FieldUsage.PixelCount.equals((Object)field.getUsage())) {
                this.countField = i;
                continue;
            }
            if (PAMDataset.PAMRasterBand.FieldUsage.MinMax.equals((Object)field.getUsage())) {
                int valueField = i;
                this.keyBuilder = row -> (String)row.getF().get(valueField);
                continue;
            }
            if (PAMDataset.PAMRasterBand.FieldUsage.Min.equals((Object)field.getUsage())) {
                minField = i;
                continue;
            }
            if (!PAMDataset.PAMRasterBand.FieldUsage.Max.equals((Object)field.getUsage())) continue;
            maxField = i;
        }
        if (this.keyBuilder == null) {
            if (minField >= 0 && maxField >= 0) {
                int min = minField;
                int max = maxField;
                this.keyBuilder = row -> (String)row.getF().get(min) + "-" + (String)row.getF().get(max);
            } else {
                throw new IllegalArgumentException("Could not find value fields in the raster attribute table");
            }
        }
        rat.getRow().forEach(row -> this.allRows.computeIfAbsent(this.keyBuilder.apply((PAMDataset.PAMRasterBand.Row)row), k -> row.getF()));
    }

    public void collect(PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat) {
        for (PAMDataset.PAMRasterBand.Row row : rat.getRow()) {
            String key = this.keyBuilder.apply(row);
            List prev = this.allRows.get(key);
            List curr = row.getF();
            if (prev == null) {
                prev = row.getF();
                this.allRows.put(key, prev);
                continue;
            }
            for (int i = 0; i < prev.size(); ++i) {
                String prevValue = (String)prev.get(i);
                String currValue = (String)curr.get(i);
                if (this.countField != null && i == this.countField || prevValue.equals(currValue)) continue;
                throw new IllegalArgumentException(String.format("Different values for band %d in row %s: %s != %s", this.band, key, prevValue, currValue));
            }
            if (this.countField == null) continue;
            long countPrev = Long.parseLong((String)prev.get(this.countField));
            long countCurr = Long.parseLong((String)curr.get(this.countField));
            prev.set(this.countField, String.valueOf(countPrev + countCurr));
        }
    }

    public void replaceRows(PAMDataset dataset, int band) {
        List bands = dataset.getPAMRasterBand();
        PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = ((PAMDataset.PAMRasterBand)bands.get(band)).getGdalRasterAttributeTable();
        rat.getRow().clear();
        int idx = 0;
        for (List<String> value : this.allRows.values()) {
            PAMDataset.PAMRasterBand.Row row = new PAMDataset.PAMRasterBand.Row();
            row.getF().addAll(value);
            row.setIndex(idx++);
            rat.getRow().add(row);
        }
    }
}

