/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.media.jai.PlanarImage;
import org.geotools.gce.imagemosaic.egr.Tile;
import org.geotools.geometry.jts.JTS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class TileTest {
    @Test
    public void testTileOffset() {
        Tile tile = new Tile(256, 256, 1, 1, new AffineTransform());
        PlanarImage imageOutside = TileTest.toImage(new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0));
        Assert.assertFalse((boolean)tile.draw(imageOutside));
        PlanarImage imageInside = TileTest.toImage(new Rectangle2D.Double(260.0, 260.0, 20.0, 20.0));
        Assert.assertTrue((boolean)tile.draw(imageInside));
        Assert.assertFalse((boolean)tile.isFullyCovered());
        PlanarImage imageCovers = TileTest.toImage(new Rectangle2D.Double(200.0, 200.0, 400.0, 400.0));
        Assert.assertTrue((boolean)tile.draw(imageCovers));
        Assert.assertTrue((boolean)tile.isFullyCovered());
        PlanarImage imageInside2 = TileTest.toImage(new Rectangle2D.Double(450.0, 450.0, 20.0, 20.0));
        Assert.assertFalse((boolean)tile.draw(imageInside2));
    }

    private static PlanarImage toImage(Rectangle2D rectangle) {
        Polygon polygon = JTS.toGeometry((Envelope)JTS.toEnvelope((Rectangle2D)rectangle));
        PlanarImage image = new ROIGeometry((Geometry)polygon).getAsImage();
        return image;
    }
}

