/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;

public class RasterLayerRequestTest {
    @Test
    public void testResolutions() throws Exception {
        File testMosaic = TestData.file((Object)this, (String)"/overview/0");
        Assert.assertTrue((boolean)testMosaic.exists());
        ImageMosaicReader reader = new ImageMosaicFormat().getReader((Object)testMosaic, null);
        RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
        GeneralBounds oe = reader.getOriginalEnvelope();
        double offset = oe.getSpan(0) * 0.9;
        GeneralBounds reNative = new GeneralBounds((Bounds)oe);
        reNative.setRange(0, oe.getMinimum(0) - offset, oe.getMaximum(0) - offset);
        GeneralBounds reTransformed = CRS.transform((Bounds)reNative, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857", (boolean)true));
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 35, 47), (Bounds)reTransformed);
        ParameterValue ggParam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggParam.setValue((Object)gg);
        RasterLayerRequest request = new RasterLayerRequest(new GeneralParameterValue[]{ggParam}, manager);
        double[] rr = request.spatialRequestHelper.getComputedResolution();
        double resolution = Math.min(rr[0], rr[1]);
        Assert.assertTrue((resolution > 60.0 ? 1 : 0) != 0);
        reader.dispose();
    }
}

