/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.image.ImageWorker;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ImageMosaicRATTest {
    @Test
    public void testRATFromGeotiff() throws IOException, FactoryException {
        File mosaicSource = TestData.file((Object)this, (String)"bluetopo");
        String mosaicName = "bluetopo";
        File mosaicDirectory = new File("target", mosaicName);
        FileUtils.deleteQuietly((File)mosaicDirectory);
        FileUtils.copyDirectory((File)mosaicSource, (File)mosaicDirectory);
        PAMParser parser = new PAMParser();
        PAMDataset pam1 = parser.parsePAM(new File(mosaicDirectory, "BlueTopo_BH4JS577_20230918.tiff.aux.xml"));
        PAMDataset pam2 = parser.parsePAM(new File(mosaicDirectory, "BlueTopo_BH4JS578_20230918.tiff.aux.xml"));
        PAMDataset.PAMRasterBand band_1_2 = (PAMDataset.PAMRasterBand)pam1.getPAMRasterBand().get(2);
        PAMDataset.PAMRasterBand band_2_2 = (PAMDataset.PAMRasterBand)pam2.getPAMRasterBand().get(2);
        ImageMosaicReader reader = TestUtils.getReader(URLs.fileToUrl((File)mosaicDirectory));
        ResourceInfo info = reader.getInfo(mosaicName);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.instanceOf(PAMResourceInfo.class));
        PAMResourceInfo pamInfo = (PAMResourceInfo)info;
        PAMDataset pam = pamInfo.getPAMDataset();
        Assert.assertNotNull((Object)pam);
        List bands = pam.getPAMRasterBand();
        Assert.assertEquals((long)3L, (long)bands.size());
        Assert.assertNull((Object)((PAMDataset.PAMRasterBand)bands.get(0)).getGdalRasterAttributeTable());
        Assert.assertNull((Object)((PAMDataset.PAMRasterBand)bands.get(1)).getGdalRasterAttributeTable());
        PAMDataset.PAMRasterBand b2 = (PAMDataset.PAMRasterBand)bands.get(2);
        Assert.assertNotNull((Object)b2);
        PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = b2.getGdalRasterAttributeTable();
        List fields = rat.getFieldDefn();
        List originalFields = band_1_2.getGdalRasterAttributeTable().getFieldDefn();
        Assert.assertEquals((Object)originalFields, (Object)fields);
        List rows = rat.getRow();
        List rows1 = band_1_2.getGdalRasterAttributeTable().getRow();
        List rows2 = band_2_2.getGdalRasterAttributeTable().getRow();
        Assert.assertTrue((rows.size() < rows1.size() + rows2.size() ? 1 : 0) != 0);
        List row0 = ((PAMDataset.PAMRasterBand.Row)rows.get(0)).getF();
        List row1_0 = ((PAMDataset.PAMRasterBand.Row)rows1.get(0)).getF();
        List row2_0 = ((PAMDataset.PAMRasterBand.Row)rows2.get(0)).getF();
        Assert.assertEquals((long)row0.size(), (long)row1_0.size());
        for (int i = 0; i < row0.size(); ++i) {
            if (i == 1) continue;
            Assert.assertEquals(row0.get(i), row1_0.get(i));
            Assert.assertEquals(row0.get(i), row2_0.get(i));
        }
        Assert.assertEquals((Object)String.valueOf(3893423), row0.get(1));
        String rowValueOnlyFirst = "1014908";
        List<String> rowOnlyFirst = this.lookupRow(rows, rowValueOnlyFirst);
        List<String> rowOnlyFirstOriginal = this.lookupRow(rows1, rowValueOnlyFirst);
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.lookupRow(rows2, rowValueOnlyFirst));
        Assert.assertEquals(rowOnlyFirstOriginal, rowOnlyFirst);
        String rowValueOnlySecond = "35367";
        List<String> rowOnlySecond = this.lookupRow(rows, rowValueOnlySecond);
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.lookupRow(rows1, rowValueOnlySecond));
        List<String> rowOnlySecondOriginal = this.lookupRow(rows2, rowValueOnlySecond);
        Assert.assertEquals(rowOnlySecondOriginal, rowOnlySecond);
        GridCoverage2D coverage = reader.read(null);
        NoDataContainer cvNoData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        Assert.assertEquals((double)Double.NaN, (double)cvNoData.getAsSingleValue(), (double)0.0);
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertEquals((double)Double.NaN, (double)new ImageWorker(ri).getNoData().getMin().doubleValue(), (double)0.0);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void testReloadRAT() throws IOException, FactoryException {
        File mosaicSource = TestData.file((Object)this, (String)"bluetopo");
        String mosaicName = "bluetopoReload";
        File mosaicDirectory = new File("target", mosaicName);
        FileUtils.deleteQuietly((File)mosaicDirectory);
        FileUtils.copyDirectory((File)mosaicSource, (File)mosaicDirectory);
        String pamFileName = "BlueTopo_BH4JS577_20230918.tiff.aux.xml";
        File small = new File(mosaicDirectory, "BlueTopo_BH4JS577_20230918.tiff.small.aux.xml");
        File full = new File(mosaicDirectory, pamFileName);
        File hideMe = new File(full.getParent(), "hideme.xml");
        Assert.assertTrue((boolean)full.renameTo(hideMe));
        Assert.assertTrue((boolean)small.renameTo(full));
        ImageMosaicReader reader = TestUtils.getReader(URLs.fileToUrl((File)mosaicDirectory));
        ResourceInfo info = reader.getInfo(mosaicName);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.instanceOf(PAMResourceInfo.class));
        PAMResourceInfo pamInfo = (PAMResourceInfo)info;
        PAMDataset pam = pamInfo.getPAMDataset();
        Assert.assertNotNull((Object)pam);
        List bands = pam.getPAMRasterBand();
        PAMDataset.PAMRasterBand b2 = (PAMDataset.PAMRasterBand)bands.get(2);
        PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = b2.getGdalRasterAttributeTable();
        List originalRows = rat.getRow();
        Assert.assertTrue((boolean)full.delete());
        Assert.assertTrue((boolean)hideMe.renameTo(full));
        Assert.assertTrue((boolean)pamInfo.reloadPAMDataset());
        rat = ((PAMDataset.PAMRasterBand)pamInfo.getPAMDataset().getPAMRasterBand().get(2)).getGdalRasterAttributeTable();
        List reloadedRows = rat.getRow();
        MatcherAssert.assertThat((Object)reloadedRows.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(originalRows.size())));
        for (PAMDataset.PAMRasterBand.Row row : originalRows) {
            String originalValue = (String)row.getF().get(0);
            Assert.assertTrue((String)("Could not find " + originalValue), (boolean)reloadedRows.stream().filter(r -> ((String)r.getF().get(0)).equals(originalValue)).findFirst().isPresent());
        }
        reader.dispose();
    }

    private List<String> lookupRow(List<PAMDataset.PAMRasterBand.Row> rows, String reference) {
        return rows.stream().filter(row -> ((String)row.getF().get(0)).equals(reference)).map(row -> row.getF()).findFirst().orElseThrow(() -> new IndexOutOfBoundsException("Row not found"));
    }
}

