/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.media.jai.ROI;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.test.TestData;
import org.geotools.test.wiremock.FileRangeResponseTransformer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageMosaicCogMaskTest {
    private static WireMockServer wireMockServer;

    @BeforeClass
    public static void setUpServer() {
        WireMockConfiguration configuration = WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Extension[]{new FileRangeResponseTransformer()});
        wireMockServer = new WireMockServer((Options)configuration);
        wireMockServer.start();
        File file = new File("./src/test/resources/org/geotools/gce/imagemosaic/test-data/masked2cog.tif");
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/masked2cog.tif")).willReturn(WireMock.aResponse().withTransformer("file-range-response-transformer", "filePath", (Object)file).withStatus(200)));
    }

    @AfterClass
    public static void tearDownServer() {
        if (wireMockServer != null) {
            wireMockServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaskedCog() throws Exception {
        URL url = TestData.url((Object)this, (String)"masked2cog");
        ImageMosaicReader reader = TestUtils.getReader(url);
        GridCoverage2D coverage = null;
        try {
            Assert.assertNotNull((Object)reader);
            URL cogSource = new URL("http://localhost:" + wireMockServer.port() + "/masked2cog.tif");
            List harvest = reader.harvest(null, (Object)cogSource, null);
            Assert.assertEquals((long)1L, (long)harvest.size());
            HarvestedSource source = (HarvestedSource)harvest.get(0);
            Assert.assertEquals((Object)cogSource, (Object)source.getSource());
            GeneralParameterValue[] params = new GeneralParameterValue[3];
            ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
            footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
            params[0] = footprintManagement;
            ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
            jaiImageRead.setValue(false);
            params[1] = jaiImageRead;
            coverage = reader.read(params);
            Assert.assertNotNull((Object)coverage);
            RenderedImage image = coverage.getRenderedImage();
            Assert.assertEquals((long)1L, (long)image.getNumXTiles());
            Assert.assertEquals((long)1L, (long)image.getNumYTiles());
            Raster raster = image.getTile(0, 0);
            Assert.assertEquals((long)200L, (long)raster.getWidth());
            Assert.assertEquals((long)200L, (long)raster.getHeight());
            Assert.assertEquals((long)4L, (long)raster.getNumBands());
            Object property = image.getProperty("ROI");
            MatcherAssert.assertThat((Object)property, (Matcher)Matchers.instanceOf(ROI.class));
            ROI roi = (ROI)property;
            int[] pixel = new int[4];
            raster.getPixel(10, 10, pixel);
            Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 0}, (int[])pixel);
            Assert.assertFalse((boolean)roi.contains(10, 10));
            raster.getPixel(190, 190, pixel);
            Assert.assertArrayEquals((int[])new int[]{255, 255, 68, 255}, (int[])pixel);
            Assert.assertTrue((boolean)roi.contains(190, 190));
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }
}

