/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.acceptors.ColorCheckAcceptor;
import org.geotools.gce.imagemosaic.acceptors.DefaultGranuleAcceptorFactory;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptorFactorySPI;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptorFactorySPIFinder;
import org.geotools.gce.imagemosaic.acceptors.HeterogeneousCRSAcceptorFactory;
import org.geotools.gce.imagemosaic.acceptors.HomogeneousCRSAcceptor;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.test.TestData;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultSubmosaicProducerSPITest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    @Rule
    public TemporaryFolder crsMosaicFolder = new TemporaryFolder();

    @Test
    public void testCustomizedGranuleAcceptor() throws IOException, URISyntaxException, CQLException {
        URL testDataURL = TestData.url((Object)this, (String)"diffprojections");
        File testDataFolder = new File(testDataURL.toURI());
        File testDirectory = this.testFolder.newFolder("diffprojectionstest");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        Hints creationHints = new Hints();
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, creationHints);
        Assert.assertNotNull((Object)imReader);
        Assert.assertEquals((long)imReader.getGranules(imReader.getGridCoverageNames()[0], true).getCount(null), (long)2L);
        GranuleCatalog gc = imReader.getRasterManager("diffprojectionstest").getGranuleCatalog();
        Assert.assertNotNull((Object)gc);
        Query q = new Query(gc.getTypeNames()[0], (Filter)Filter.INCLUDE);
        Assert.assertEquals((long)2L, (long)gc.getGranules(q).size());
        imReader.dispose();
    }

    @Test
    public void basicTest() {
        Map spiMap = GranuleAcceptorFactorySPIFinder.getGranuleAcceptorFactorySPI();
        Assert.assertNotNull((Object)spiMap);
        Assert.assertFalse((boolean)spiMap.isEmpty());
        Assert.assertTrue((boolean)spiMap.containsKey(HeterogeneousCRSAcceptorFactory.class.getName()));
        Assert.assertTrue((boolean)spiMap.containsKey(DefaultGranuleAcceptorFactory.class.getName()));
        Assert.assertNotNull(spiMap.get(HeterogeneousCRSAcceptorFactory.class.getName()));
        GranuleAcceptorFactorySPI spi = (GranuleAcceptorFactorySPI)spiMap.get(HeterogeneousCRSAcceptorFactory.class.getName());
        List acceptors = spi.create();
        Assert.assertNotNull((Object)acceptors);
        Assert.assertEquals((long)1L, (long)acceptors.size());
        GranuleAcceptor granuleAcceptor = (GranuleAcceptor)acceptors.get(0);
        Assert.assertEquals(granuleAcceptor.getClass(), ColorCheckAcceptor.class);
        Assert.assertNotNull(spiMap.get(DefaultGranuleAcceptorFactory.class.getName()));
        spi = (GranuleAcceptorFactorySPI)spiMap.get(DefaultGranuleAcceptorFactory.class.getName());
        acceptors = spi.create();
        Assert.assertNotNull((Object)acceptors);
        Assert.assertEquals((long)2L, (long)acceptors.size());
        granuleAcceptor = (GranuleAcceptor)acceptors.get(0);
        Assert.assertTrue((granuleAcceptor.getClass().equals(ColorCheckAcceptor.class) || granuleAcceptor.getClass().equals(HomogeneousCRSAcceptor.class) ? 1 : 0) != 0);
        granuleAcceptor = (GranuleAcceptor)acceptors.get(1);
        Assert.assertTrue((granuleAcceptor.getClass().equals(ColorCheckAcceptor.class) || granuleAcceptor.getClass().equals(HomogeneousCRSAcceptor.class) ? 1 : 0) != 0);
    }
}

