/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.postgis;

import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.data.transform.Definition;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gce.imagemosaic.catalog.oracle.AbstractFeatureTypeMapper;

public class PostgisFeatureTypeMapper
extends AbstractFeatureTypeMapper {
    private static final int MAX_LENGTH = 63;
    private int srID = 0;

    public PostgisFeatureTypeMapper(SimpleFeatureType featureType) throws CQLException {
        super(featureType, 63);
        this.remapFeatureType();
    }

    @Override
    protected void remapGeometryAttribute(SimpleFeatureTypeBuilder tb, Definition definition, AttributeDescriptor descriptor, AttributeType type) {
        Map userData = descriptor.getUserData();
        if (userData != null && !userData.isEmpty()) {
            Set keys = userData.keySet();
            for (Object key : keys) {
                String id;
                Object value = userData.get(key);
                tb.userData(key, value);
                if (!(key instanceof String) || !(id = (String)key).equalsIgnoreCase("nativeSRID") || value == null) continue;
                this.srID = (Integer)value;
            }
        }
        super.remapGeometryAttribute(tb, definition, descriptor, type);
    }

    int getSrID() {
        return this.srID;
    }

    void setSrID(int srID) {
        this.srID = srID;
    }
}

