/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageioimpl.plugins.cog.GSRangeReader;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.properties.FSDateExtractorSPI;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.geometry.GeneralBounds;
import org.geotools.test.TestData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ImageMosaicCogOnlineTest {
    private static final ImageMosaicFormat IMAGE_MOSAIC_FORMAT = new ImageMosaicFormat();

    @BeforeClass
    public static void init() {
        System.setProperty("user.timezone", "GMT");
    }

    @AfterClass
    public static void close() {
        System.clearProperty("user.timezone");
    }

    @Test
    public void testCogMosaic() throws Exception {
        File workDir = this.prepareWorkingDir("s3cogtest.zip", "s3cogtest", "");
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        int numTileX = image.getNumXTiles();
        int numTileY = image.getNumYTiles();
        Raster raster = image.getTile(numTileX / 2, numTileY / 2);
        Assert.assertEquals((long)512L, (long)raster.getWidth());
        Assert.assertEquals((long)512L, (long)raster.getHeight());
        Assert.assertEquals((long)1L, (long)raster.getNumBands());
        reader.dispose();
    }

    @Test
    @Ignore
    public void testCogMosaicOverview() throws Exception {
        File workDir = this.prepareWorkingDir("s3cogtest.zip", "overview", "s3cogtest");
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GeneralParameterValue[] params = new GeneralParameterValue[1];
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralBounds envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize(reader.getOriginalGridRange().getSpan(0) / 24, reader.getOriginalGridRange().getSpan(1) / 24);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Bounds)envelope));
        params[0] = gg;
        GridCoverage2D coverage = reader.read(params);
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertNotNull((Object)coverage);
        int numTileX = image.getNumXTiles();
        int numTileY = image.getNumYTiles();
        Raster raster = image.getTile(numTileX / 2, numTileY / 2);
        Assert.assertEquals((long)512L, (long)raster.getWidth());
        Assert.assertEquals((long)512L, (long)raster.getHeight());
        Assert.assertEquals((long)1L, (long)raster.getNumBands());
        Object fileLocation = coverage.getProperty("OriginalFileSource");
        Assert.assertNotNull((Object)fileLocation);
        Assert.assertTrue((boolean)(fileLocation instanceof String));
        String path = (String)fileLocation;
        Assert.assertFalse((boolean)path.isEmpty());
        Assert.assertTrue((boolean)path.endsWith(".ovr"));
        reader.dispose();
    }

    @Test
    public void testCogMosaicDefaultConfig() throws Exception {
        File workDir = this.prepareWorkingDir("s3cogtest.zip", "default", "s3cogtest");
        File file = new File(workDir, "cogtest.properties");
        Properties properties = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            properties.load(fin);
        }
        try (FileWriter fw = new FileWriter(file);){
            Assert.assertNotNull((Object)properties.remove("CogRangeReader"));
            Assert.assertNotNull((Object)properties.remove("SuggestedSPI"));
            properties.store(fw, "");
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        int numTileX = image.getNumXTiles();
        int numTileY = image.getNumYTiles();
        Raster raster = image.getTile(numTileX / 2, numTileY / 2);
        Assert.assertEquals((long)512L, (long)raster.getWidth());
        Assert.assertEquals((long)512L, (long)raster.getHeight());
        Assert.assertEquals((long)1L, (long)raster.getNumBands());
        reader.dispose();
    }

    @Test
    public void testCogMosaicBandSelect() throws Exception {
        File workDir = this.prepareWorkingDir("s3cogtest.zip", "default", "s3cogtest");
        File file = new File(workDir, "cogtest.properties");
        Properties properties = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            properties.load(fin);
        }
        try (FileWriter fw = new FileWriter(file);){
            Assert.assertNotNull((Object)properties.remove("CogRangeReader"));
            Assert.assertNotNull((Object)properties.remove("SuggestedSPI"));
            properties.store(fw, "");
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        ParameterValue bands = AbstractGridFormat.BANDS.createValue();
        bands.setValue((Object)new int[]{0, 0});
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{bands});
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertEquals((long)2L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((long)2L, (long)image.getColorModel().getNumComponents());
        Assert.assertEquals((long)2L, (long)image.getTile(0, 0).getNumBands());
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestSingleURL() throws Exception {
        File workDir = this.prepareWorkingDir("s3cogtest.zip", "harvest", "s3cogtest");
        File file = new File(workDir, "indexer.properties");
        Properties properties = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            properties.load(fin);
        }
        try (FileWriter fw = new FileWriter(file);){
            Assert.assertNotNull((Object)properties.remove("UseExistingSchema"));
            properties.store(fw, "");
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        String coverageName = reader.getGridCoverageNames()[0];
        GranuleSource granules = reader.getGranules(coverageName, true);
        Assert.assertEquals((long)1L, (long)granules.getCount(Query.ALL));
        try {
            URL source = new URL("https://s3-us-west-2.amazonaws.com/sentinel-cogs/sentinel-s2-l2a-cogs/5/C/MK/2018/10/S2B_5CMK_20181020_0_L2A/B01.tif");
            reader.harvest(null, (Object)source, null);
            granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)2L, (long)granules.getCount(Query.ALL));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyMosaic() throws Exception {
        File workDir = this.prepareWorkingDir("emptycog.zip", "emptyCogMosaic", "");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/emptyCogMosaic/datastore.properties"));){
            out.write("database=cogmosaic\n");
            out.write("SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nLoose\\ bbox=true #important for performances\nEstimated\\ extends=false #important for performances\nuser=gs\npasswd=gs\nvalidate \\connections=true #important for avoiding errors\nConnection\\ timeout=3600\nmax \\connections=10 #important for performances, internal pooling\nmin \\connections=5  #important for performances, internal pooling\n");
            out.flush();
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String granuleUrl = "https://s3-us-west-2.amazonaws.com/sentinel-cogs/sentinel-s2-l2a-cogs/5/C/MK/2018/10/S2B_5CMK_20181019_0_L2A/B01.tif";
            URL source = new URL(granuleUrl);
            List summary = reader.harvest(null, (Object)source, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)1L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)granuleUrl, (Object)f.getAttribute("location"));
            }
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeDimensionMosaic() throws Exception {
        File workDir = this.prepareWorkingDir("emptycog.zip", "timeMosaic", "");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/timeMosaic/datastore.properties"));){
            out.write("database=cogtimemosaic\n");
            out.write("SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nLoose\\ bbox=true #important for performances\nEstimated\\ extends=false #important for performances\nuser=gs\npasswd=gs\nvalidate \\connections=true #important for avoiding errors\nConnection\\ timeout=3600\nmax \\connections=10 #important for performances, internal pooling\nmin \\connections=5  #important for performances, internal pooling\n");
            out.flush();
        }
        out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/timeMosaic/timeregex.properties"));
        try {
            out.write("regex=[0-9]{8},fullPath=true");
            out.flush();
        }
        finally {
            out.close();
        }
        out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/timeMosaic/indexer.properties"), true);
        try {
            out.write("\nPropertyCollectors=TimestampFileNameExtractorSPI[timeregex](time)");
            out.write("\nTimeAttribute=time");
            out.write("\nSchema=location:String,time:java.util.Date,*the_geom:Polygon\n");
            out.flush();
        }
        finally {
            out.close();
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            String prefix = "https://s3-us-west-2.amazonaws.com/sentinel-cogs/sentinel-s2-l2a-cogs/";
            urls.add(new URL(prefix + "5/C/MK/2018/10/S2B_5CMK_20181019_0_L2A/B01.tif"));
            urls.add(new URL(prefix + "5/C/MK/2018/10/S2B_5CMK_20181020_0_L2A/B01.tif"));
            List summary = reader.harvest(null, urls, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)2L, (long)summary.size());
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2018-10-19T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
            Assert.assertEquals((Object)"2018-10-20T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testFSDateCollect() throws Exception {
        URL url = new URL("https://s3-us-west-2.amazonaws.com/sentinel-cogs/sentinel-s2-l2a-cogs/5/C/MK/2018/10/S2B_5CMK_20181019_0_L2A/B01.tif");
        FSDateExtractorSPI spi = new FSDateExtractorSPI();
        PropertiesCollector collector = spi.create((Object)spi, Arrays.asList("createdate"));
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.setName("runtimeT");
        featureTypeBuilder.add("createdate", Date.class);
        SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        SimpleFeature feature = featureBuilder.buildFeature("0");
        collector.collect(url);
        collector.setProperties(feature);
        GregorianCalendar calendar = (GregorianCalendar)GregorianCalendar.getInstance();
        Date date = (Date)feature.getAttribute("createdate");
        calendar.setTime(date);
        Assert.assertEquals((long)2020L, (long)calendar.get(1));
        Assert.assertEquals((long)26L, (long)calendar.get(5));
        Assert.assertEquals((long)9L, (long)(calendar.get(2) + 1));
    }

    private File prepareWorkingDir(String zipName, String folder, String subFolder) throws IOException {
        File workDir = new File(TestData.file((Object)this, (String)"."), folder);
        String destinationPath = folder + "/";
        if (StringUtils.isNotBlank((CharSequence)subFolder)) {
            workDir = new File(workDir, subFolder);
            destinationPath = destinationPath + subFolder + "/";
        }
        destinationPath = destinationPath + zipName;
        if (!workDir.mkdirs()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + workDir), (boolean)workDir.mkdirs());
        }
        File zipFile = new File(workDir, zipName);
        FileUtils.copyFile((File)TestData.file((Object)this, (String)zipName), (File)zipFile);
        TestData.unzipFile((Object)this, (String)destinationPath);
        FileUtils.deleteQuietly((File)zipFile);
        return workDir;
    }

    @Test
    public void testGSCogMosaic() throws Exception {
        File workDir = this.prepareWorkingDir("gscogtest.zip", "gscogtest", "");
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        int numTileX = image.getNumXTiles();
        int numTileY = image.getNumYTiles();
        Raster raster = image.getTile(numTileX / 2, numTileY / 2);
        Assert.assertEquals((long)512L, (long)raster.getWidth());
        Assert.assertEquals((long)512L, (long)raster.getHeight());
        Assert.assertEquals((long)1L, (long)raster.getNumBands());
        reader.dispose();
    }

    @Test
    public void testGSURICogMosaic() throws Exception {
        File workDir = this.prepareWorkingDir("gsuricogtest.zip", "gsuricogtest", "");
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        int numTileX = image.getNumXTiles();
        int numTileY = image.getNumYTiles();
        Raster raster = image.getTile(numTileX / 2, numTileY / 2);
        Assert.assertEquals((long)512L, (long)raster.getWidth());
        Assert.assertEquals((long)512L, (long)raster.getHeight());
        Assert.assertEquals((long)1L, (long)raster.getNumBands());
        reader.dispose();
    }

    @Test
    public void testHarvestGSPublicURL() throws Exception {
        String folder = "emptyGSCogMosaic";
        String granuleUrl = "https://storage.googleapis.com/gcp-public-data-landsat/LC08/01/044/034/LC08_L1GT_044034_20130330_20170310_01_T2/LC08_L1GT_044034_20130330_20170310_01_T2_B11.TIF";
        URL source = new URL(granuleUrl);
        this.harvestSingleGoogleCOG(folder, granuleUrl, source);
    }

    @Test
    public void testHarvestGSURI() throws Exception {
        String folder = "emptyGSURICogMosaic";
        String uri = "gs://gcp-public-data-landsat/LC08/01/044/034/LC08_L1GT_044034_20130330_20170310_01_T2/LC08_L1GT_044034_20130330_20170310_01_T2_B11.TIF";
        URI granuleUri = new URI(uri);
        this.harvestSingleGoogleCOG(folder, uri, granuleUri);
    }

    @Test
    public void testHarvestGSString() throws Exception {
        String folder = "emptyGSStringCogMosaic";
        String uri = "gs://gcp-public-data-landsat/LC08/01/044/034/LC08_L1GT_044034_20130330_20170310_01_T2/LC08_L1GT_044034_20130330_20170310_01_T2_B11.TIF";
        this.harvestSingleGoogleCOG(folder, uri, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void harvestSingleGoogleCOG(String folder, String expected, Object source) throws IOException {
        File workDir = this.prepareWorkingDir("emptygscog.zip", folder, "");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), folder + "/datastore.properties"));){
            out.write("database=cogmosaic\n");
            out.write("SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nLoose\\ bbox=true #important for performances\nEstimated\\ extends=false #important for performances\nuser=gs\npasswd=gs\nvalidate \\connections=true #important for avoiding errors\nConnection\\ timeout=3600\nmax \\connections=10 #important for performances, internal pooling\nmin \\connections=5  #important for performances, internal pooling\n");
            out.flush();
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            this.harvestGranule(expected, source, reader, originalCatalog);
        }
        finally {
            reader.dispose();
        }
    }

    private void harvestGranule(String expected, Object source, ImageMosaicReader reader, GranuleCatalog originalCatalog) throws IOException {
        List summary = reader.harvest(null, source, null);
        Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
        Assert.assertEquals((long)1L, (long)summary.size());
        String coverageName = reader.getGridCoverageNames()[0];
        GranuleSource granules = reader.getGranules(coverageName, true);
        Assert.assertEquals((long)1L, (long)granules.getCount(Query.ALL));
        Query q = new Query(Query.ALL);
        try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
            Assert.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipExternalOverviews() throws Exception {
        String folder = "cogNoOverviews";
        File workDir = new File("./target/" + folder);
        FileUtils.deleteDirectory((File)workDir);
        Assert.assertTrue((boolean)workDir.mkdir());
        try (FileWriter out = new FileWriter(new File(workDir, "datastore.properties"));){
            out.write("database=cogmosaic\n");
            out.write("SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nLoose\\ bbox=true #important for performances\nEstimated\\ extends=false #important for performances\nuser=gs\npasswd=gs\nvalidate \\connections=true #important for avoiding errors\nConnection\\ timeout=3600\nmax \\connections=10 #important for performances, internal pooling\nmin \\connections=5  #important for performances, internal pooling\n");
            out.flush();
        }
        String name = "emptycog";
        try (FileWriter out = new FileWriter(new File(workDir, "indexer.properties"));){
            Properties p = new Properties();
            p.put("Cog", "true");
            p.put("Name", name);
            p.put("TypeName", name);
            p.put("CanBeEmpty", "true");
            p.put("CogRangeReader", GSRangeReader.class.getName());
            p.put("SkipExternalOverviews", "true");
            p.store(out, null);
        }
        ImageMosaicReader reader = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        try {
            GranuleCatalog originalCatalog = reader.granuleCatalog;
            String location = "gs://gcp-public-data-landsat/LC08/01/044/034/LC08_L1GT_044034_20130330_20170310_01_T2/LC08_L1GT_044034_20130330_20170310_01_T2_B11.TIF";
            this.harvestGranule(location, location, reader, originalCatalog);
            RasterManager manager = (RasterManager)reader.rasterManagers.get(name);
            manager.granuleCatalog.getGranuleDescriptors(new Query(name), (granule, feature) -> {
                Assert.assertTrue((boolean)granule.getMaskOverviewProvider().isSkipExternalLookup());
                Assert.assertTrue((boolean)((GeoTiffReader)granule.getReader()).getMaskOverviewProvider().isSkipExternalLookup());
            });
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        ImageMosaicReader reader2 = IMAGE_MOSAIC_FORMAT.getReader((Object)workDir);
        try {
            RasterManager manager = (RasterManager)reader2.rasterManagers.get(name);
            manager.granuleCatalog.getGranuleDescriptors(new Query(name), (granule, feature) -> Assert.assertTrue((boolean)granule.getMaskOverviewProvider().isSkipExternalLookup()));
        }
        finally {
            if (reader2 != null) {
                reader.dispose();
            }
        }
    }
}

