/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.apache.commons.io.FileUtils;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicReaderTest;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.Assert;

final class TestUtils
extends Assert {
    private TestUtils() {
    }

    static GridCoverage2D testCoverage(ImageMosaicReader reader, GeneralParameterValue[] values, String title, GridCoverage2D coverage, Rectangle rect) throws FactoryException {
        RenderedImage image = coverage.getRenderedImage();
        if (ImageMosaicReaderTest.INTERACTIVE) {
            TestUtils.show(image, title);
        } else {
            PlanarImage.wrapRenderedImage((RenderedImage)image).getTiles();
        }
        if (values != null) {
            for (GeneralParameterValue pv : values) {
                CoordinateReferenceSystem coverageCRS;
                if (!pv.getDescriptor().getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                Parameter param = (Parameter)pv;
                CoordinateReferenceSystem envCRS = ((GridGeometry2D)param.getValue()).getEnvelope().getCoordinateReferenceSystem();
                boolean equalsIgnoreMetadata = CRS.equalsIgnoreMetadata((Object)envCRS, (Object)(coverageCRS = coverage.getCoordinateReferenceSystem()));
                if (!equalsIgnoreMetadata) {
                    MathTransform destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)envCRS, (CoordinateReferenceSystem)coverageCRS, (boolean)true);
                    equalsIgnoreMetadata = destinationToSourceTransform != null && destinationToSourceTransform.isIdentity();
                }
                TestUtils.assertTrue((boolean)equalsIgnoreMetadata);
            }
        }
        if (rect != null) {
            TestUtils.assertEquals((long)image.getWidth(), (long)rect.width);
            TestUtils.assertEquals((long)image.getHeight(), (long)rect.height);
        }
        if (!ImageMosaicReaderTest.INTERACTIVE) {
            coverage.dispose(true);
            reader.dispose();
        }
        return coverage;
    }

    static GridCoverage2D checkCoverage(ImageMosaicReader reader, GeneralParameterValue[] values, String title) throws IOException {
        return TestUtils.checkCoverage(reader, values, title, null);
    }

    static GridCoverage2D checkCoverage(ImageMosaicReader reader, GeneralParameterValue[] values, String title, Rectangle rect) throws IOException {
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, true);
        try {
            return TestUtils.testCoverage(reader, values, title, coverage, rect);
        }
        catch (FactoryException e) {
            throw new IOException(e);
        }
    }

    static GridCoverage2D getCoverage(ImageMosaicReader reader, GeneralParameterValue[] values, boolean checkForNull) throws IOException {
        GridCoverage2D coverage = reader.read(values);
        if (checkForNull) {
            Assert.assertNotNull((Object)coverage);
        }
        return coverage;
    }

    static AbstractGridFormat getFormat(URL testURL) throws NoSuchAuthorityCodeException, FactoryException {
        Hints hints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)CRS.decode((String)"EPSG:4326", (boolean)true));
        return TestUtils.getFormat(testURL, hints);
    }

    static AbstractGridFormat getFormat(URL testURL, Hints hints) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)testURL, (Hints)hints);
        Assert.assertNotNull((Object)format);
        Assert.assertFalse((String)"UknownFormat", (boolean)(format instanceof UnknownFormat));
        return format;
    }

    static ImageMosaicReader getReader(URL testURL, AbstractGridFormat format) throws NoSuchAuthorityCodeException, FactoryException {
        return TestUtils.getReader(testURL, format, null, true);
    }

    static ImageMosaicReader getReader(URL testURL, AbstractGridFormat format, Hints hints) {
        return TestUtils.getReader(testURL, format, hints, true);
    }

    static ImageMosaicReader getReader(URL testURL, AbstractGridFormat format, Hints hints, boolean checkForNull) {
        ImageMosaicReader reader = (ImageMosaicReader)format.getReader((Object)testURL, hints);
        if (checkForNull) {
            Assert.assertNotNull((Object)reader);
        }
        return reader;
    }

    static void show(RenderedImage image, String title) {
        ImageIOUtilities.visualize((RenderedImage)image, (String)title);
    }

    public static ImageMosaicReader getReader(File directory) throws FactoryException {
        URL directoryURL = URLs.fileToUrl((File)directory);
        return TestUtils.getReader(directoryURL);
    }

    public static ImageMosaicReader getReader(URL directoryURL) throws FactoryException {
        AbstractGridFormat format = TestUtils.getFormat(directoryURL);
        ImageMosaicReader reader = TestUtils.getReader(directoryURL, format);
        TestUtils.assertNotNull((Object)reader);
        return reader;
    }

    public static File setupTestDirectory(Object caller, URL url, String testDirectoryName) throws IOException {
        File source = URLs.urlToFile((URL)url);
        File directory = new File(TestData.file((Object)caller, (String)"."), testDirectoryName);
        if (directory.exists()) {
            FileUtils.deleteDirectory((File)directory);
        }
        FileUtils.copyDirectory((File)source, (File)directory);
        return directory;
    }

    public static void logAll() {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.ALL);
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        rootLogger.addHandler(consoleHandler);
    }
}

