/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.geotools.TestData;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class RemoteTest {
    @Test
    public void testRemoteMosaic() throws IOException, TransformException {
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)TestData.file((Object)this, (String)"remote_test"));
        GridEnvelope originalRange = reader.getOriginalGridRange();
        GeneralBounds envelope = reader.getOriginalEnvelope();
        CoordinateReferenceSystem nativeCRS = envelope.getCoordinateReferenceSystem();
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 50 ? width : 50);
        int maxY = minY + (height <= 50 ? height : 50);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralBounds testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (Bounds)new GeneralBounds((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(nativeCRS);
        ParameterValue pam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        pam.setValue((Object)new GridGeometry2D((GridEnvelope)testRange, (Bounds)testEnvelope));
        GridCoverage2D gc = reader.read((GeneralParameterValue[])new ParameterValue[]{pam});
        Assert.assertNotNull((Object)gc);
        this.assertNotBlank("remote image mosaic", ((PlanarImage)gc.getRenderedImage()).getAsBufferedImage(), Color.BLACK);
        reader.dispose();
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == bgColor.getRGB()) continue;
                ++pixelsDiffer;
            }
        }
        Assert.assertTrue((String)(testName + " image is completely blank"), (0 < pixelsDiffer ? 1 : 0) != 0);
    }
}

