/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;

public class PathTypeTest
extends Assert {
    private static final Logger LOGGER = Logger.getLogger(PathTypeTest.class.toString());

    @Test
    public void relative() throws FileNotFoundException, IOException {
        File testFile = TestData.file((Object)((Object)this), (String)"/rgb/global_mosaic_0.png");
        PathTypeTest.assertTrue((boolean)testFile.exists());
        URL temp = PathType.RELATIVE.resolvePath(TestData.url((Object)((Object)this), (String)".").toExternalForm(), "rgb/global_mosaic_0.pgw");
        PathTypeTest.assertNotNull((Object)temp);
        temp.openStream().close();
        LOGGER.info("Testing invalid path");
        URL temp1 = PathType.RELATIVE.resolvePath(TestData.url((Object)((Object)this), (String)".").toExternalForm(), "rgb/global_mosaic_0.pg");
        PathTypeTest.assertNull((Object)temp1);
        try {
            temp1.openStream().close();
            PathTypeTest.fail((String)("The relative URL " + temp1 + " is not supposed to exist!"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void absolute() throws FileNotFoundException, IOException {
        URL testFile = TestData.url((Object)((Object)this), (String)"/rgb/global_mosaic_0.png");
        testFile.openStream().close();
        URL temp = PathType.ABSOLUTE.resolvePath(TestData.url((Object)((Object)this), (String)".").toExternalForm(), testFile.toExternalForm());
        PathTypeTest.assertNotNull((Object)temp);
        temp.openStream().close();
        URL temp1 = PathType.ABSOLUTE.resolvePath(null, testFile.toExternalForm());
        PathTypeTest.assertNotNull((Object)temp1);
        temp1.openStream().close();
        URL temp2 = PathType.ABSOLUTE.resolvePath(TestData.url((Object)((Object)this), (String)".").toExternalForm(), "rgb/global_mosaic_0.pg");
        PathTypeTest.assertNull((Object)temp2);
        try {
            temp2.openStream().close();
            PathTypeTest.fail((String)("The URL " + temp2 + " is not supposed to exist!"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

