/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MergeBehaviorTest {
    static File mergeExt;

    @BeforeClass
    public static void prepareTestMosaic() throws Exception {
        File mosaicSource = TestData.file(MergeBehaviorTest.class, (String)"merge_ext");
        mergeExt = new File("target", "merge_ext");
        FileUtils.deleteQuietly((File)mergeExt);
        FileUtils.copyDirectory((File)mosaicSource, (File)mergeExt);
    }

    @Test
    public void testGetValuesAsString() {
        String[] values = MergeBehavior.valuesAsStrings();
        Assert.assertNotNull((Object)values);
        HashSet<String> testSet = new HashSet<String>(Arrays.asList(values));
        Set expectedSet = Arrays.stream(MergeBehavior.values()).map(v -> v.name()).collect(Collectors.toSet());
        Assert.assertEquals(expectedSet, testSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMax() throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)mergeExt);
        try {
            ParameterValue mergeBehavior = ImageMosaicFormat.MERGE_BEHAVIOR.createValue();
            mergeBehavior.setValue((Object)MergeBehavior.MAX.toString());
            GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{mergeBehavior});
            Assert.assertNotNull((Object)coverage);
            RenderedImage ri = coverage.getRenderedImage();
            Assert.assertEquals((long)160L, (long)ri.getWidth());
            Assert.assertEquals((long)160L, (long)ri.getHeight());
            SampleModel sm = ri.getSampleModel();
            Assert.assertEquals((long)1L, (long)sm.getNumBands());
            Assert.assertEquals((long)0L, (long)sm.getDataType());
            this.assertPixelValue(50, ri, 80, 80);
            this.assertPixelValue(50, ri, 50, 50);
            this.assertPixelValue(50, ri, 50, 110);
            this.assertPixelValue(50, ri, 110, 110);
            this.assertPixelValue(50, ri, 110, 50);
            this.assertPixelValue(35, ri, 65, 65);
            this.assertPixelValue(35, ri, 95, 65);
            this.assertPixelValue(35, ri, 95, 95);
            this.assertPixelValue(35, ri, 65, 95);
            this.assertPixelValue(0, ri, 0, 0);
            this.assertPixelValue(0, ri, 159, 0);
            this.assertPixelValue(0, ri, 159, 159);
            this.assertPixelValue(0, ri, 0, 159);
            coverage.dispose(true);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMin() throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)mergeExt);
        try {
            ParameterValue mergeBehavior = ImageMosaicFormat.MERGE_BEHAVIOR.createValue();
            mergeBehavior.setValue((Object)MergeBehavior.MIN.toString());
            GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{mergeBehavior});
            Assert.assertNotNull((Object)coverage);
            RenderedImage ri = coverage.getRenderedImage();
            Assert.assertEquals((long)160L, (long)ri.getWidth());
            Assert.assertEquals((long)160L, (long)ri.getHeight());
            SampleModel sm = ri.getSampleModel();
            Assert.assertEquals((long)1L, (long)sm.getNumBands());
            Assert.assertEquals((long)0L, (long)sm.getDataType());
            this.assertPixelValue(20, ri, 80, 80);
            this.assertPixelValue(9, ri, 80, 99);
            this.assertPixelValue(9, ri, 80, 61);
            this.assertPixelValue(9, ri, 99, 80);
            this.assertPixelValue(9, ri, 61, 80);
            coverage.dispose(true);
        }
        finally {
            reader.dispose();
        }
    }

    private void assertPixelValue(int value, RenderedImage ri, int x, int y) {
        Raster data = ri.getData();
        int[] pixel = new int[1];
        data.getPixel(x, y, pixel);
        Assert.assertEquals((long)value, (long)pixel[0]);
    }
}

