/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.ExcessGranulePolicy;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageMosaicEgrTest {
    private static ExecutorService coverageExecutor;
    private static Hints hints;
    private File testMosaic;
    private URL testMosaicUrl;
    private File testAlphaMosaic;
    private URL testAlphaMosaicUrl;
    private File testAlphaHeteroMosaic;
    private URL testAlphaHeteroMosaicUrl;

    @AfterClass
    public static void close() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
        coverageExecutor.shutdownNow();
    }

    @BeforeClass
    public static void init() {
        CRS.reset((String)"all");
        System.setProperty("org.geotools.referencing.forceXY", "true");
        coverageExecutor = Executors.newCachedThreadPool();
        hints = new Hints(new RenderingHints((RenderingHints.Key)Hints.EXECUTOR_SERVICE, coverageExecutor));
    }

    @Before
    public void setupMosaic() throws IOException {
        this.testMosaic = new File("target", "egrMosaic");
        if (this.testMosaic.exists()) {
            FileUtils.deleteDirectory((File)this.testMosaic);
        }
        File mosaicSource = TestData.file((Object)this, (String)"egr");
        FileUtils.copyDirectory((File)mosaicSource, (File)this.testMosaic);
        this.testMosaicUrl = URLs.fileToUrl((File)this.testMosaic);
    }

    @Before
    public void setupAlphaMosaic() throws IOException {
        this.testAlphaMosaic = new File("target", "egrAlphaMosaic");
        if (this.testAlphaMosaic.exists()) {
            FileUtils.deleteDirectory((File)this.testAlphaMosaic);
        }
        File mosaicSource = TestData.file((Object)this, (String)"rgba");
        FileUtils.copyDirectory((File)mosaicSource, (File)this.testAlphaMosaic);
        Arrays.stream(this.testAlphaMosaic.listFiles(f -> {
            String name = f.getName();
            return name.startsWith("rgba") || name.equals("sample_image.dat");
        })).forEach(f -> f.delete());
        this.testAlphaMosaicUrl = URLs.fileToUrl((File)this.testAlphaMosaic);
    }

    @Before
    public void setupAlphaHeteroMosaic() throws IOException {
        this.testAlphaHeteroMosaic = new File("target", "egrAlphaHeteroMosaic");
        if (this.testAlphaHeteroMosaic.exists()) {
            FileUtils.deleteDirectory((File)this.testAlphaHeteroMosaic);
        }
        File mosaicSource = TestData.file((Object)this, (String)"egrAlpha");
        FileUtils.copyDirectory((File)mosaicSource, (File)this.testAlphaHeteroMosaic);
        this.testAlphaHeteroMosaicUrl = URLs.fileToUrl((File)this.testAlphaHeteroMosaic);
    }

    private GeneralParameterValue[] getFootprintReadParams(GridCoverage2DReader reader, AbstractMap.SimpleEntry ... entries) {
        ArrayList<ParameterValue> params = new ArrayList<ParameterValue>();
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params.add(footprintManagement);
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params.add(jaiImageRead);
        boolean foundGridGeometry = false;
        if (entries != null) {
            for (AbstractMap.SimpleEntry entry : entries) {
                ParameterValue pv = ((ParameterDescriptor)entry.getKey()).createValue();
                pv.setValue(entry.getValue());
                params.add(pv);
                foundGridGeometry |= entry.getKey().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D);
            }
        }
        if (!foundGridGeometry) {
            ParameterValue geom = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            geom.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 300, 300), (Bounds)reader.getOriginalEnvelope()));
            params.add(geom);
        }
        GeneralParameterValue[] result = params.toArray(new GeneralParameterValue[params.size()]);
        return result;
    }

    private void createRasterFootprintsProperties(File testMosaicRaster) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        p.put("footprint_source", "raster");
        try (FileOutputStream fos = new FileOutputStream(new File(testMosaicRaster, "footprints.properties"));){
            p.store(fos, null);
        }
    }

    private void createVectorFootprintsProperties(File testMosaicRaster) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        p.put("footprint_source", "sidecar");
        p.put("footprint_inset", "0.01");
        try (FileOutputStream fos = new FileOutputStream(new File(testMosaicRaster, "footprints.properties"));){
            p.store(fos, null);
        }
    }

    @Test
    public void testAllImagesRaster() throws Exception {
        this.createRasterFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-all-desc-raster.png");
        this.testAllImages(sample);
    }

    @Test
    public void testAllImagesVector() throws Exception {
        this.createVectorFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-all-desc-vector.png");
        this.testAllImages(sample);
    }

    private void testAllImages(File expectedOutput) throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testMosaicUrl, hints);
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"));
        this.testOutputCoverage(reader, readParams, expectedOutput, "3_mid.tiff", "2_right.tiff", "1_left.tiff", "0_large.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI));
        this.testOutputCoverage(reader, readParams, expectedOutput, "3_mid.tiff", "2_right.tiff", "1_left.tiff", "0_large.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, Boolean>(ImageMosaicFormat.ALLOW_MULTITHREADING, true));
        this.testOutputCoverage(reader, readParams, expectedOutput, "3_mid.tiff", "2_right.tiff", "1_left.tiff", "0_large.tiff");
        reader.dispose();
    }

    @Test
    public void testRedCoversAllRaster() throws Exception {
        this.createRasterFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-red-covers-all-raster.png");
        this.testRedCoversAll(sample);
    }

    @Test
    public void testRedCoversAllVector() throws Exception {
        this.createVectorFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-red-covers-all-vector.png");
        this.testRedCoversAll(sample);
    }

    private void testRedCoversAll(File expectedOutput) throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testMosaicUrl, hints);
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"));
        this.testOutputCoverage(reader, readParams, expectedOutput, "0_large.tiff", "1_left.tiff", "2_right.tiff", "3_mid.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI));
        this.testOutputCoverage(reader, readParams, expectedOutput, "0_large.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, Boolean>(ImageMosaicFormat.ALLOW_MULTITHREADING, true));
        this.testOutputCoverage(reader, readParams, expectedOutput, "0_large.tiff");
        reader.dispose();
    }

    @Test
    public void testLeftRightOnTopRaster() throws Exception {
        this.createRasterFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-left-right-top-raster.png");
        this.testLeftRightOnTop(sample);
    }

    @Test
    public void testLeftRightOnTopVector() throws Exception {
        this.createVectorFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-left-right-top-vector.png");
        this.testLeftRightOnTop(sample);
    }

    private void testLeftRightOnTop(File expectedOutput) throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testMosaicUrl, hints);
        Filter filter = ECQL.toFilter((String)"z <> 0");
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"), new AbstractMap.SimpleEntry<ParameterDescriptor, Filter>(ImageMosaicFormat.FILTER, filter));
        this.testOutputCoverage(reader, readParams, expectedOutput, "1_left.tiff", "2_right.tiff", "3_mid.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"), new AbstractMap.SimpleEntry<ParameterDescriptor, Filter>(ImageMosaicFormat.FILTER, filter), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI));
        this.testOutputCoverage(reader, readParams, expectedOutput, "1_left.tiff", "2_right.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z A"), new AbstractMap.SimpleEntry<ParameterDescriptor, Filter>(ImageMosaicFormat.FILTER, filter), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, Boolean>(ImageMosaicFormat.ALLOW_MULTITHREADING, true));
        this.testOutputCoverage(reader, readParams, expectedOutput, "1_left.tiff", "2_right.tiff");
        reader.dispose();
    }

    @Test
    public void testSingleRaster() throws Exception {
        this.createRasterFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-red-rect.png");
        this.checkSingle(sample);
    }

    @Test
    public void testSingleVector() throws Exception {
        this.createVectorFootprintsProperties(this.testMosaic);
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-red-rect.png");
        this.checkSingle(sample);
    }

    public void checkSingle(File expectedOutput) throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testMosaicUrl, hints);
        GridGeometry2D readGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 300, 300), (Bounds)new ReferencedEnvelope(-0.667, -0.64, 0.386, 0.412, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<DefaultParameterDescriptor, GridGeometry2D>(ImageMosaicFormat.READ_GRIDGEOMETRY2D, readGeometry), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"));
        this.testOutputCoverage(reader, readParams, expectedOutput, new String[0]);
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<DefaultParameterDescriptor, GridGeometry2D>(ImageMosaicFormat.READ_GRIDGEOMETRY2D, readGeometry), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI));
        this.testOutputCoverage(reader, readParams, expectedOutput, "0_large.tiff");
        readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<DefaultParameterDescriptor, GridGeometry2D>(ImageMosaicFormat.READ_GRIDGEOMETRY2D, readGeometry), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, Boolean>(ImageMosaicFormat.ALLOW_MULTITHREADING, true));
        this.testOutputCoverage(reader, readParams, expectedOutput, "0_large.tiff");
        reader.dispose();
    }

    private void testOutputCoverage(ImageMosaicReader reader, GeneralParameterValue[] readParams, File expectedOutput, String ... expectedImages) throws IOException {
        GridCoverage2D coverage = reader.read(readParams);
        this.assertSourceFileNames(coverage, expectedImages);
        ImageAssert.assertEquals((File)expectedOutput, (RenderedImage)coverage.getRenderedImage(), (int)300);
    }

    private void assertSourceFileNames(GridCoverage2D coverage, String ... expectedNamesArray) {
        String sources = (String)coverage.getProperty("OriginalFileSource");
        if (expectedNamesArray != null && expectedNamesArray.length > 0) {
            String[] names = sources.split("\\s*,\\s*");
            LinkedHashSet<String> actualNames = new LinkedHashSet<String>();
            for (String name : names) {
                actualNames.add(new File(name).getName());
            }
            LinkedHashSet<String> expectedNames = new LinkedHashSet<String>(Arrays.asList(expectedNamesArray));
            Assert.assertEquals(expectedNames, actualNames);
        }
    }

    @Test
    public void testHeteroCRSAlpha() throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testAlphaHeteroMosaicUrl, hints);
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.FOOTPRINT_BEHAVIOR, "Transparent"));
        GridCoverage2D coverage = reader.read(readParams);
        File expectedOutput = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-alpha-hetero.png");
        ImageAssert.assertEquals((File)expectedOutput, (RenderedImage)coverage.getRenderedImage(), (int)300);
    }

    @Test
    public void testHeteroCRSAlphaBlend() throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testAlphaHeteroMosaicUrl, hints);
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "z D"), new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.FOOTPRINT_BEHAVIOR, "Transparent"), new AbstractMap.SimpleEntry<ParameterDescriptor, Boolean>(ImageMosaicFormat.FADING, true));
        GridCoverage2D coverage = reader.read(readParams);
        File expectedOutput = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-alpha-hetero-fade.png");
        ImageAssert.assertEquals((File)expectedOutput, (RenderedImage)coverage.getRenderedImage(), (int)300);
    }

    @Test
    public void testAlpha() throws Exception {
        ImageMosaicReader reader = new ImageMosaicReader((Object)this.testAlphaMosaicUrl, hints);
        GridGeometry2D geom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 300, 300), (Bounds)new ReferencedEnvelope(-1380000.0, -1026000.0, 1866000.0, 2200000.0, reader.getCoordinateReferenceSystem()));
        GeneralParameterValue[] readParams = this.getFootprintReadParams((GridCoverage2DReader)reader, new AbstractMap.SimpleEntry<ParameterDescriptor, ExcessGranulePolicy>(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL, ExcessGranulePolicy.ROI), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.FOOTPRINT_BEHAVIOR, "Transparent"), new AbstractMap.SimpleEntry<ParameterDescriptor, String>(ImageMosaicFormat.SORT_BY, "location A"), new AbstractMap.SimpleEntry<DefaultParameterDescriptor, GridGeometry2D>(AbstractGridFormat.READ_GRIDGEOMETRY2D, geom));
        GridCoverage2D coverage = reader.read(readParams);
        File expectedOutput = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/egr-alpha.png");
        ImageAssert.assertEquals((File)expectedOutput, (RenderedImage)coverage.getRenderedImage(), (int)300);
        this.assertSourceFileNames(coverage, "passA2006128193711.png");
    }
}

