/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.net.URL;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GranuleDescriptorTest {
    @Test
    public void testBounds() throws SchemaException, ParseException {
        SimpleFeatureType schema = DataUtilities.createType((String)"index", (String)"geom:Polygon:4326,location:String,geom2:Polygon:4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        Geometry geometry = new WKTReader().read("POLYGON((0 0, 0 10, 10 10, 10 0, 0 0))");
        fb.add((Object)geometry);
        URL resource = this.getClass().getResource("test-data/rgb/global_mosaic_0.png");
        fb.add((Object)URLs.urlToFile((URL)resource));
        fb.add((Object)geometry.buffer(10.0));
        SimpleFeature feature = fb.buildFeature("xyz");
        new GranuleDescriptor(feature, null, null, null, PathType.ABSOLUTE, "location", "/tmp"){

            protected void init(BoundingBox granuleBBOX, URL granuleUrl, ImageReaderSpi suggestedSPI, MultiLevelROI roiProvider, boolean heterogeneousGranules, boolean handleArtifactsFiltering, Hints hints) {
                Assert.assertEquals((double)0.0, (double)granuleBBOX.getMinimum(0), (double)0.0);
                Assert.assertEquals((double)10.0, (double)granuleBBOX.getMaximum(0), (double)0.0);
                Assert.assertEquals((double)0.0, (double)granuleBBOX.getMinimum(1), (double)0.0);
                Assert.assertEquals((double)10.0, (double)granuleBBOX.getMaximum(1), (double)0.0);
            }
        };
    }

    @Test
    public void testSuggestedImageReaderSPI() throws Exception {
        CatalogConfigurationBean config = new CatalogConfigurationBean();
        config.setSuggestedSPI("it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi");
        ImageReaderSpi readerSpi = config.suggestedSPI();
        Assert.assertNotNull((String)"suggestedSPI wasn't found", (Object)readerSpi);
    }
}

