/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import org.geotools.gce.imagemosaic.egr.RendererUtilities;
import org.geotools.gce.imagemosaic.egr.Tile;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

class Binarizator {
    private static final Logger LOGGER = Logging.getLogger(Binarizator.class);
    private final AffineTransform w2gTransform;
    private final int tileWidth;
    private final int tileHeight;
    private final int origW;
    private final int origH;
    private List<Tile> activeTiles;

    Binarizator(Polygon bbox, int pxWidth, int pxHeight, int tileWidth, int tileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.origW = pxWidth;
        this.origH = pxHeight;
        ReferencedEnvelope env = JTS.toEnvelope((Geometry)bbox);
        this.w2gTransform = RendererUtilities.worldToScreenTransform(env, new Rectangle(pxWidth, pxHeight));
        if (this.w2gTransform == null) {
            LOGGER.info("Null transformer, possible bad bbox requested " + env);
            this.activeTiles = Collections.emptyList();
        } else {
            this.createTiles(pxWidth, pxHeight, tileWidth, tileHeight, this.w2gTransform);
        }
    }

    private void createTiles(int w, int h, int tw, int th, AffineTransform w2s) {
        int col;
        int colnum = w / tw;
        int rownum = h / th;
        this.activeTiles = new LinkedList<Tile>();
        for (col = 0; col < colnum; ++col) {
            for (int row = 0; row < rownum; ++row) {
                Tile tile = new Tile(this.tileWidth, this.tileHeight, col, row, w2s);
                this.activeTiles.add(tile);
            }
        }
        if (w % tw != 0) {
            for (int row = 0; row < rownum; ++row) {
                Tile tile = new Tile(w % tw, this.tileHeight, colnum, row, w2s, this.tileWidth, this.tileHeight);
                this.activeTiles.add(tile);
            }
        }
        if (h % th != 0) {
            for (col = 0; col < colnum; ++col) {
                Tile tile = new Tile(this.tileWidth, h % th, col, rownum, w2s, this.tileWidth, this.tileHeight);
                this.activeTiles.add(tile);
            }
        }
        if (w % tw != 0 && h % th != 0) {
            Tile tile = new Tile(w % tw, h % th, colnum, rownum, w2s, this.tileWidth, this.tileHeight);
            this.activeTiles.add(tile);
        }
    }

    public boolean isComplete() {
        return this.activeTiles.isEmpty();
    }

    public boolean add(ROI roi) {
        if (roi instanceof ROIGeometry) {
            Geometry geometry = ((ROIGeometry)roi).getAsGeometry();
            return this.add(geometry);
        }
        if (roi instanceof ROIShape) {
            Shape shape = ((ROIShape)roi).getAsShape();
            Geometry geometry = JTS.toGeometry((Shape)shape);
            return this.add(geometry);
        }
        PlanarImage roiImage = roi.getAsImage();
        Rectangle roiBounds = roiImage.getBounds();
        boolean added = false;
        Iterator<Tile> it = this.activeTiles.iterator();
        while (it.hasNext()) {
            Tile tile = it.next();
            Rectangle tileBounds = tile.getTileArea();
            if (tileBounds.intersects(roiBounds)) {
                if (!tile.draw(roiImage)) continue;
                added = true;
                if (!tile.isFullyCovered()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removing covered tile " + tile + " (" + this.activeTiles.size() + " left)");
                }
                it.remove();
                tile.dispose();
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Skipping tile " + tile);
        }
        return added;
    }

    public boolean add(Geometry geometry) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding geometry " + geometry);
        }
        PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geometry);
        LiteShape shape = new LiteShape(geometry, null, false);
        Shape projectedShape = this.w2gTransform.createTransformedShape((Shape)shape);
        boolean added = false;
        Iterator<Tile> it = this.activeTiles.iterator();
        while (it.hasNext()) {
            Tile tile = it.next();
            Polygon tileBBox = tile.getTileBBox();
            Envelope geometryEnvelope = geometry.getEnvelopeInternal();
            if (geometryEnvelope.intersects(tileBBox.getEnvelopeInternal()) && pg.intersects((Geometry)tileBBox)) {
                if (pg.contains((Geometry)tileBBox)) {
                    added = true;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Removing fully covered tile " + tile + " (" + this.activeTiles.size() + " left)");
                    }
                    it.remove();
                    tile.dispose();
                    continue;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("drawing " + pg + " on " + tile + ' ' + tileBBox);
                }
                tile.draw(projectedShape);
                if (!tile.refreshCoverageCount()) continue;
                added = true;
                if (!tile.isFullyCovered()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removing covered tile " + tile + " (" + this.activeTiles.size() + " left)");
                }
                it.remove();
                tile.dispose();
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Skipping tile " + tile);
        }
        return added;
    }

    List<Tile> getActiveTiles() {
        return this.activeTiles;
    }

    BufferedImage getDebugImage() {
        MultiPixelPackedSampleModel sampleModel = new MultiPixelPackedSampleModel(0, this.origW, this.origH, 1);
        WritableRaster mainRaster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (Point)new Point(0, 0));
        int[] data = new int[this.origW * this.origH];
        Arrays.fill(data, 0);
        mainRaster.setSamples(0, 0, this.origW, this.origH, 0, data);
        int colnum = this.origW / this.tileWidth;
        int rownum = this.origH / this.tileHeight;
        byte[] x00FF = new byte[]{0, -1};
        IndexColorModel binaryCM = new IndexColorModel(1, 2, x00FF, x00FF, x00FF);
        BufferedImage mainBI = new BufferedImage(binaryCM, mainRaster, false, null);
        Graphics2D graphics = mainBI.createGraphics();
        for (int col = 0; col <= colnum; ++col) {
            for (int row = 0; row <= rownum; ++row) {
                graphics.setColor(Color.WHITE);
                graphics.drawRect(col * this.tileWidth, row * this.tileHeight, this.tileWidth - 1, this.tileHeight - 1);
                this.drawChecks(graphics, col, row);
                graphics.setColor(Color.BLACK);
            }
        }
        for (Tile tile : this.activeTiles) {
            WritableRaster tileRaster = tile.getRaster();
            int col = tile.getCol();
            int row = tile.getRow();
            if (tileRaster != null) {
                mainRaster.setDataElements(col * this.tileWidth, row * this.tileHeight, tileRaster);
                continue;
            }
            graphics.setColor(Color.BLACK);
            graphics.fillRect(col * this.tileWidth, row * this.tileHeight, this.tileWidth - 1, this.tileHeight - 1);
            graphics.setColor(Color.WHITE);
            this.drawCross(graphics, col, row);
        }
        return mainBI;
    }

    private void drawCross(Graphics2D graphics, int col, int row) {
        graphics.drawRect(col * this.tileWidth, row * this.tileHeight, this.tileWidth - 1, this.tileHeight - 1);
        graphics.drawLine(col * this.tileWidth, row * this.tileHeight, col * this.tileWidth + this.tileWidth - 1, row * this.tileHeight + this.tileHeight - 1);
        graphics.drawLine(col * this.tileWidth + this.tileWidth - 1, row * this.tileWidth, col * this.tileWidth, row * this.tileHeight + this.tileHeight - 1);
    }

    private void drawChecks(Graphics2D graphics, int col, int row) {
        graphics.setColor(Color.WHITE);
        for (int y = 0; y < this.tileHeight; ++y) {
            for (int x = y % 2; x < this.tileWidth; x += 2) {
                graphics.drawRect(col * this.tileWidth + x, row * this.tileWidth + y, 0, 0);
            }
        }
    }
}

