/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.Repository;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.gce.imagemosaic.URLSourceSPIProvider;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CachingDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CogConfiguration;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.LockingGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.RepositoryDataStoreCatalog;
import org.geotools.gce.imagemosaic.catalog.STRTreeGranuleCatalog;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.URLs;
import org.geotools.util.decorate.Wrapper;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class GranuleCatalogFactory {
    private static final Logger LOGGER = Logging.getLogger(GranuleCatalogFactory.class);

    private GranuleCatalogFactory() {
    }

    public static GranuleCatalog createGranuleCatalog(Properties params, boolean caching, boolean create, DataStoreFactorySpi spi, Hints hints) {
        AbstractGTDataStoreGranuleCatalog gtCatalog;
        Repository repository = (Repository)hints.get((Object)Hints.REPOSITORY);
        String storeName = (String)params.get("StoreName");
        if (storeName != null && !storeName.trim().isEmpty()) {
            if (repository == null) {
                throw new IllegalArgumentException("Was given a store name " + storeName + " but there is no Repository to resolve it");
            }
            gtCatalog = new RepositoryDataStoreCatalog(params, create, repository, storeName, spi, hints);
        } else {
            gtCatalog = new GTDataStoreGranuleCatalog(params, create, spi, hints);
        }
        DataStore store = ((AbstractGTDataStoreGranuleCatalog)gtCatalog).getTileIndexStore();
        GranuleCatalog catalog = caching ? new STRTreeGranuleCatalog(params, gtCatalog, hints) : new CachingDataStoreGranuleCatalog(gtCatalog);
        if (store instanceof Wrapper) {
            store = Optional.ofNullable((DataStore)((Wrapper)store).unwrap(JDBCDataStore.class)).orElse(store);
        }
        if (!(store instanceof JDBCDataStore)) {
            catalog = new LockingGranuleCatalog(catalog, hints);
        }
        return catalog;
    }

    public static GranuleCatalog createGranuleCatalog(URL sourceURL, CatalogConfigurationBean catalogConfigurationBean, Properties overrideParams, Hints hints) {
        DataStoreFactorySpi spi;
        Properties params;
        block15: {
            String typeName;
            File sourceFile = URLs.urlToFile((URL)sourceURL);
            String extension = FilenameUtils.getExtension((String)sourceFile.getAbsolutePath());
            params = new Properties();
            params.put("PathType", (Object)catalogConfigurationBean.getPathType());
            if (catalogConfigurationBean.getLocationAttribute() != null) {
                params.put("LocationAttribute", catalogConfigurationBean.getLocationAttribute());
            }
            if (catalogConfigurationBean.getSuggestedSPI() != null) {
                params.put("SuggestedSPI", catalogConfigurationBean.getSuggestedSPI());
            }
            if (catalogConfigurationBean.getSuggestedFormat() != null) {
                params.put("SuggestedFormat", catalogConfigurationBean.getSuggestedFormat());
            }
            if (catalogConfigurationBean.getSuggestedIsSPI() != null) {
                params.put("SuggestedIsSPI", catalogConfigurationBean.getSuggestedIsSPI());
            }
            params.put("Heterogeneous", (Object)catalogConfigurationBean.isHeterogeneous());
            URLSourceSPIProvider urlSourceSpiProvider = catalogConfigurationBean.getUrlSourceSPIProvider();
            params.put("Cog", (Object)(urlSourceSpiProvider != null && urlSourceSpiProvider instanceof CogConfiguration ? 1 : 0));
            params.put("WrapStore", (Object)catalogConfigurationBean.isWrapStore());
            if (sourceURL != null) {
                File parentDirectory = URLs.urlToFile((URL)sourceURL);
                if (parentDirectory.isFile()) {
                    parentDirectory = parentDirectory.getParentFile();
                }
                params.put("ParentLocation", URLs.fileToUrl((File)parentDirectory).toString());
            }
            if ((typeName = catalogConfigurationBean.getTypeName()) != null) {
                params.put("TypeName", catalogConfigurationBean.getTypeName());
            }
            spi = null;
            if (extension.equalsIgnoreCase("shp")) {
                params.put(ShapefileDataStoreFactory.URLP.key, sourceURL);
                params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
                params.put(ShapefileDataStoreFactory.ENABLE_SPATIAL_INDEX.key, Boolean.TRUE);
                params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.FALSE);
                params.put(ShapefileDataStoreFactory.CACHE_MEMORY_MAPS.key, Boolean.FALSE);
                params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
                spi = Utils.SHAPE_SPI;
            } else {
                Properties properties = CoverageUtilities.loadPropertiesFromURL((URL)sourceURL);
                if (properties == null) {
                    return null;
                }
                for (Object p : properties.keySet()) {
                    params.put(p.toString(), properties.get(p).toString());
                }
                String SPIClass = properties.getProperty("SPI");
                try {
                    spi = (DataStoreFactorySpi)Class.forName(SPIClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (properties.get("StoreName") != null) break block15;
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    return null;
                }
            }
        }
        if (overrideParams != null && !overrideParams.isEmpty()) {
            params.putAll((Map<?, ?>)overrideParams);
        }
        return GranuleCatalogFactory.createGranuleCatalog(params, catalogConfigurationBean.isCaching(), false, spi, hints);
    }
}

