/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.core.SourceSPIProvider;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStreamSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogSourceSPIProvider;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.beanutils.BeanUtils;
import org.geotools.gce.imagemosaic.URLSourceSPIProvider;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.util.Utilities;

public class CogConfiguration
implements URLSourceSPIProvider {
    private static final ImageReaderSpi COG_IMAGE_READER_SPI = new CogImageReaderSpi();
    private static final ImageInputStreamSpi COG_IMAGE_INPUT_STREAM_SPI = new CogImageInputStreamSpi();
    private String user;
    private String password;
    private String rangeReader;
    private boolean useCache;

    public CogConfiguration() {
    }

    public CogConfiguration(CogConfiguration that) {
        Utilities.ensureNonNull((String)"CogConfiguration", (Object)that);
        try {
            BeanUtils.copyProperties((Object)this, (Object)that);
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
        catch (InvocationTargetException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
    }

    public CogConfiguration(Indexer indexer) {
        String password;
        String cogRangeReader = IndexerUtils.getParameter("CogRangeReader", indexer);
        this.rangeReader = cogRangeReader != null ? cogRangeReader : "it.geosolutions.imageioimpl.plugins.cog.HttpRangeReader";
        String user = IndexerUtils.getParameter("CogUser", indexer);
        if (user != null) {
            this.user = user;
        }
        if ((password = IndexerUtils.getParameter("CogPassword", indexer)) != null) {
            this.password = password;
        }
        if (IndexerUtils.getParameterAsBoolean("CogUseCache", indexer)) {
            this.useCache = true;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRangeReader() {
        return this.rangeReader;
    }

    public void setRangeReader(String rangeReader) {
        this.rangeReader = rangeReader;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public BasicAuthURI createUri(String url) {
        URI uri = URI.create(url);
        return new BasicAuthURI(uri, this.isUseCache(), this.getUser(), this.getPassword());
    }

    @Override
    public SourceSPIProvider getSourceSPIProvider(URL sourceUrl) {
        CogSourceSPIProvider readerInputObject = new CogSourceSPIProvider(this.createUri(sourceUrl.toString()), COG_IMAGE_READER_SPI, COG_IMAGE_INPUT_STREAM_SPI, this.getRangeReader());
        return readerInputObject;
    }
}

