/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.BoundsFeatureCollection;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterVisitor;
import org.opengis.geometry.BoundingBox;

class CachingDataStoreGranuleCatalog
extends GranuleCatalog {
    private static final Logger LOGGER = Logging.getLogger(CachingDataStoreGranuleCatalog.class);
    private final AbstractGTDataStoreGranuleCatalog adaptee;
    private final SoftValueHashMap<String, GranuleDescriptor> descriptorsCache = new SoftValueHashMap();

    public CachingDataStoreGranuleCatalog(AbstractGTDataStoreGranuleCatalog adaptee) {
        super(null);
        this.adaptee = adaptee;
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        this.adaptee.addGranules(typeName, granules, transaction);
    }

    @Override
    public void computeAggregateFunction(Query q, FeatureCalc function) throws IOException {
        this.adaptee.computeAggregateFunction(q, function);
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        this.adaptee.createType(namespace, typeName, typeSpec);
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        this.adaptee.createType(featureType);
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        this.adaptee.createType(identification, typeSpec);
    }

    @Override
    public void dispose() {
        this.adaptee.dispose();
        if (this.multiScaleROIProvider != null) {
            this.multiScaleROIProvider.dispose();
            this.multiScaleROIProvider = null;
        }
    }

    @Override
    public BoundingBox getBounds(String typeName) {
        return this.adaptee.getBounds(typeName);
    }

    @Override
    public BoundingBox getBounds(String typeName, Transaction t) {
        return this.adaptee.getBounds(typeName, t);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.getGranules(q, Transaction.AUTO_COMMIT);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        boolean decorateWithBounds = Boolean.TRUE.equals(q.getHints().get((Object)GranuleSource.NATIVE_BOUNDS));
        if (decorateWithBounds) {
            Query copy = new Query(q);
            copy.getHints().remove((Object)GranuleSource.NATIVE_BOUNDS);
            q = copy;
            SimpleFeatureCollection granules = this.adaptee.getGranules(q, t);
            return new BoundsFeatureCollection(granules, this::getGranuleDescriptor);
        }
        return this.adaptee.getGranules(q, t);
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        return this.adaptee.getGranulesCount(q);
    }

    @Override
    public void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        SimpleFeatureCollection features = this.adaptee.getGranules(q);
        if (features == null) {
            throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Index Loaded");
        }
        Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
        q.getFilter().accept((FilterVisitor)bboxExtractor, null);
        ReferencedEnvelope requestedBBox = bboxExtractor.getBBox();
        Polygon intersectionGeometry = requestedBBox != null ? JTS.toGeometry((ReferencedEnvelope)requestedBBox) : null;
        try (SimpleFeatureIterator fi = features.features();){
            while (fi.hasNext() && !visitor.isVisitComplete()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                GranuleDescriptor granule = this.getGranuleDescriptor(sf);
                if (granule == null) continue;
                Geometry footprint = granule.getFootprint();
                if (intersectionGeometry == null || footprint == null || this.polygonOverlap(footprint, (Geometry)intersectionGeometry)) {
                    visitor.visit(granule, sf);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Skipping granule " + granule + "\n since its ROI does not intersect the requested area");
            }
        }
    }

    protected GranuleDescriptor getGranuleDescriptor(SimpleFeature sf) {
        String featureId = sf.getID();
        GranuleDescriptor granule = null;
        if (this.descriptorsCache.containsKey((Object)featureId)) {
            granule = (GranuleDescriptor)this.descriptorsCache.get((Object)featureId);
        } else {
            try {
                MultiLevelROI footprint = this.getGranuleFootprint(sf);
                if (footprint == null || !footprint.isEmpty()) {
                    granule = new GranuleDescriptor(sf, this.adaptee.suggestedFormat, this.adaptee.suggestedRasterSPI, this.adaptee.suggestedIsSPI, this.adaptee.pathType, this.adaptee.locationAttribute, this.adaptee.parentLocation, footprint, this.adaptee.heterogeneous, this.adaptee.hints);
                    this.descriptorsCache.put((Object)featureId, (Object)granule);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Skipping invalid granule", e);
            }
        }
        return granule;
    }

    private boolean polygonOverlap(Geometry g1, Geometry g2) {
        Geometry intersection = g1.intersection(g2);
        return intersection != null && intersection.getDimension() == 2;
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        return this.adaptee.getQueryCapabilities(typeName);
    }

    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        return this.adaptee.getType(typeName);
    }

    @Override
    public int removeGranules(Query query) {
        return this.removeGranules(query, Transaction.AUTO_COMMIT);
    }

    @Override
    public int removeGranules(Query query, Transaction transaction) {
        int val = this.adaptee.removeGranules(query, transaction);
        if (val >= 1) {
            this.descriptorsCache.clear();
        }
        return val;
    }

    @Override
    public String[] getTypeNames() {
        return this.adaptee.getTypeNames();
    }

    public GranuleCatalog getAdaptee() {
        return this.adaptee;
    }

    @Override
    public void removeType(String typeName) throws IOException {
        this.adaptee.removeType(typeName);
    }

    @Override
    public void drop() throws IOException {
        this.adaptee.drop();
    }
}

