/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.ReadResolutionCalculator;
import org.geotools.data.DataSourceException;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class SpatialRequestHelper {
    private static final Logger LOGGER = Logging.getLogger(SpatialRequestHelper.class);
    private ReferencedEnvelope requestedBBox;
    private Rectangle requestedRasterArea;
    private Rectangle computedRasterArea;
    private CoordinateReferenceSystem requestCRS;
    private AffineTransform requestedGridToWorld;
    private double[] computedResolution;
    private GeneralEnvelope requestedBBOXInCoverageGeographicCRS;
    private MathTransform requestCRSToCoverageGeographicCRS2D;
    private MathTransform destinationToSourceTransform;
    private final CoverageProperties coverageProperties;
    private CoverageProperties alternativeProperties;
    private boolean accurateResolution;
    private boolean emptyRequest;
    private GeneralEnvelope approximateRequestedBBoInNativeCRS;
    private boolean isSupportingAlternativeCRSOutput;
    private AffineTransform computedGridToWorld;
    private GridGeometry2D requestedGridGeometry;

    public SpatialRequestHelper(CoverageProperties coverageProperties) {
        this.coverageProperties = coverageProperties;
    }

    public void setAlternativeProperties(CoverageProperties alternativeProperties) {
        this.alternativeProperties = alternativeProperties;
    }

    public void setRequestedGridGeometry(GridGeometry2D gridGeometry) {
        Utilities.ensureNonNull((String)"girdGeometry", (Object)gridGeometry);
        this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)gridGeometry.getEnvelope2D());
        this.requestedRasterArea = gridGeometry.getGridRange2D().getBounds();
        this.requestedGridGeometry = gridGeometry;
        this.requestedGridToWorld = (AffineTransform)gridGeometry.getGridToCRS2D();
    }

    public void compute() throws DataSourceException {
        if (this.requestedBBox == null) {
            this.requestedBBox = new ReferencedEnvelope((Envelope)this.coverageProperties.bbox, this.coverageProperties.crs2D);
            this.requestedRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.computedResolution = (double[])this.coverageProperties.fullResolution.clone();
            this.coverageProperties.computedBBox = new ReferencedEnvelope((Envelope)this.coverageProperties.bbox, this.coverageProperties.crs2D);
            this.computedRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.computedGridToWorld = this.requestedGridToWorld = (AffineTransform)this.coverageProperties.gridToWorld2D;
            if (this.requestedBBox.isEmpty()) {
                this.emptyRequest = true;
            }
            return;
        }
        this.inspectCoordinateReferenceSystems();
        this.computeCropBBOX();
        if (this.emptyRequest || this.coverageProperties.computedBBox == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RequestedBBox empty or null");
            }
            return;
        }
        this.computeRasterArea();
        if (this.emptyRequest || this.computedRasterArea == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CropRasterArea empty or null");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.computedRasterArea.toString()).append("\n").append("Corresponding source Envelope = ").append(this.coverageProperties.computedBBox.toString());
            LOGGER.log(Level.FINER, sb.toString());
        }
        this.computeResolution();
    }

    private void inspectCoordinateReferenceSystems() throws DataSourceException {
        this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        CoordinateReferenceSystem referenceCRS = this.getReferenceCRS(false);
        if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)referenceCRS)) {
            try {
                this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)referenceCRS, (boolean)true);
                if (this.isSupportingAlternativeCRSOutput) {
                    MathTransform2D alternativeTransform = (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.getReferenceCRS(true), (boolean)true);
                    this.alternativeProperties.setGridToWorld2D(alternativeTransform);
                    this.alternativeProperties.setReprojectionNeeded(alternativeTransform != null && !alternativeTransform.isIdentity());
                }
            }
            catch (FactoryException e) {
                throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
            }
        }
        if (this.destinationToSourceTransform != null) {
            if (this.destinationToSourceTransform.isIdentity()) {
                this.destinationToSourceTransform = null;
                this.requestedBBox = new ReferencedEnvelope((Envelope)this.requestedBBox, referenceCRS);
            } else {
                this.coverageProperties.setReprojectionNeeded(true);
                if (this.destinationToSourceTransform instanceof AffineTransform) {
                    AffineTransform mutableTransform = (AffineTransform)this.requestedGridToWorld.clone();
                    mutableTransform.preConcatenate((AffineTransform)this.destinationToSourceTransform);
                    try {
                        MathTransform tempTransform = PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)mutableTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                        this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)tempTransform, (org.opengis.geometry.Envelope)new GeneralEnvelope((Rectangle2D)this.requestedRasterArea)));
                    }
                    catch (Exception e) {
                        throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
                    }
                    this.destinationToSourceTransform = null;
                    this.coverageProperties.setReprojectionNeeded(false);
                }
            }
        }
    }

    private void computeRasterArea() throws DataSourceException {
        if (this.emptyRequest || this.getComputedBBox() == null) {
            throw new IllegalStateException("IllegalState, unable to compute raster area for null bbox");
        }
        try {
            Rectangle computedRasterArea;
            MathTransform2D requestedWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
            this.computedRasterArea = !this.isNeedsReprojection(true) ? new GeneralGridEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)this.getComputedBBox(true))), PixelInCell.CELL_CORNER, false).toRectangle() : (computedRasterArea = this.computeRasterArea((ReferencedEnvelope)this.getComputedBBox(true), requestedWorldToGrid));
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
        if (this.computedRasterArea.isEmpty()) {
            this.emptyRequest = true;
            return;
        }
    }

    private Rectangle computeRasterArea(ReferencedEnvelope computedBBox, MathTransform2D requestedWorldToGrid) throws TransformException, FactoryException {
        ReferencedEnvelope cropBBOXInRequestCRS = Utils.reprojectEnvelope(computedBBox, this.requestCRS, this.requestedBBox);
        cropBBOXInRequestCRS.intersection((Envelope)this.requestedBBox);
        Rectangle computedRasterArea = new GeneralGridEnvelope((org.opengis.geometry.Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (org.opengis.geometry.Envelope)cropBBOXInRequestCRS), PixelInCell.CELL_CORNER, false).toRectangle();
        XRectangle2D.intersect((Rectangle2D)computedRasterArea, (Rectangle2D)this.requestedRasterArea, (Rectangle2D)computedRasterArea);
        return computedRasterArea;
    }

    private void computeResolution() {
        try {
            GridGeometry2D gridGeometry;
            ReferencedEnvelope computedBBOX = (ReferencedEnvelope)this.getComputedBBox(true);
            if (this.isNeedsReprojection(true)) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.computedRasterArea), (org.opengis.geometry.Envelope)computedBBOX);
                this.computedGridToWorld = geMapper.createAffineTransform();
                gridGeometry = this.accurateResolution ? this.requestedGridGeometry : new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.computedRasterArea), (org.opengis.geometry.Envelope)computedBBOX);
            } else {
                gridGeometry = this.requestedGridGeometry;
                this.computedGridToWorld = this.requestedGridToWorld;
            }
            ReadResolutionCalculator calculator = new ReadResolutionCalculator(gridGeometry, this.coverageProperties.crs2D, this.coverageProperties.fullResolution);
            calculator.setAccurateResolution(this.accurateResolution);
            this.computedResolution = calculator.computeRequestedResolution(ReferencedEnvelope.reference((ReferencedEnvelope)computedBBOX));
            return;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, using highest available");
            this.computedResolution = this.coverageProperties.fullResolution;
            return;
        }
    }

    private void computeCropBBOX() throws DataSourceException {
        try {
            ReferencedEnvelope computedBBox;
            if (this.isNeedsReprojection()) {
                try {
                    computedBBox = Utils.reprojectEnvelope(this.requestedBBox, this.coverageProperties.crs2D, this.coverageProperties.bbox);
                }
                catch (FactoryException e) {
                    throw new DataSourceException((Throwable)e);
                }
                if (this.isSupportingAlternativeCRSOutput && !this.isNeedsReprojection(true)) {
                    this.alternativeProperties.computedBBox = this.requestedBBox;
                }
            } else {
                computedBBox = new ReferencedEnvelope(this.requestedBBox);
            }
            if (!computedBBox.intersects((BoundingBox)this.coverageProperties.bbox)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The computed CropBoundingBox " + this.coverageProperties.computedBBox + " Doesn't intersect the coverage BoundingBox " + this.coverageProperties.bbox + " resulting in an empty request");
                }
                this.coverageProperties.computedBBox = null;
                this.emptyRequest = true;
                return;
            }
            if ((computedBBox = new ReferencedEnvelope((Envelope)computedBBox.intersection((Envelope)this.coverageProperties.bbox), this.coverageProperties.crs2D)).isEmpty()) {
                this.emptyRequest = true;
            }
            this.coverageProperties.computedBBox = computedBBox;
            return;
        }
        catch (TransformException te) {
            block17: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
                try {
                    if (this.coverageProperties.geographicCRS != null && this.coverageProperties.geographicBBox != null) {
                        if (!CRS.equalsIgnoreMetadata((Object)this.coverageProperties.geographicCRS, (Object)this.requestCRS)) {
                            this.requestedBBOXInCoverageGeographicCRS = CRS.transform((org.opengis.geometry.Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.coverageProperties.geographicCRS);
                            this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS);
                        }
                        if (this.requestedBBOXInCoverageGeographicCRS == null) {
                            this.requestedBBOXInCoverageGeographicCRS = new GeneralEnvelope(this.requestCRS);
                        }
                        if (!this.requestedBBOXInCoverageGeographicCRS.intersects((org.opengis.geometry.Envelope)this.coverageProperties.geographicBBox, true)) {
                            this.coverageProperties.computedBBox = null;
                            this.emptyRequest = true;
                            return;
                        }
                        this.requestedBBOXInCoverageGeographicCRS.intersect((org.opengis.geometry.Envelope)this.coverageProperties.geographicBBox);
                        this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS);
                        this.approximateRequestedBBoInNativeCRS = CRS.transform((org.opengis.geometry.Envelope)this.requestedBBOXInCoverageGeographicCRS, (CoordinateReferenceSystem)this.coverageProperties.crs2D);
                        this.approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.coverageProperties.crs2D);
                        this.coverageProperties.computedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)this.approximateRequestedBBoInNativeCRS);
                        return;
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block17;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
            this.coverageProperties.computedBBox = null;
            return;
        }
    }

    public boolean isEmpty() {
        return this.emptyRequest;
    }

    public boolean isNeedsReprojection() {
        return this.isNeedsReprojection(false);
    }

    public boolean isNeedsReprojection(boolean useAlternativeIfAvailable) {
        return this.getProperty(useAlternativeIfAvailable).isReprojectionNeeded();
    }

    private CoverageProperties getProperty(boolean useAlternativeIfAvailable) {
        return useAlternativeIfAvailable && this.isSupportingAlternativeCRSOutput ? this.alternativeProperties : this.coverageProperties;
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }

    public double[] getComputedResolution() {
        return this.computedResolution != null ? (double[])this.computedResolution.clone() : null;
    }

    public Rectangle getComputedRasterArea() {
        return (Rectangle)(this.computedRasterArea != null ? this.computedRasterArea.clone() : this.computedRasterArea);
    }

    public BoundingBox getComputedBBox() {
        return this.getComputedBBox(false);
    }

    public BoundingBox getComputedBBox(boolean useAlternativeIfAvailable) {
        return this.getProperty(useAlternativeIfAvailable).getComputedBBox();
    }

    public BoundingBox getCoverageBBox() {
        return this.coverageProperties.getBbox();
    }

    public CoordinateReferenceSystem getReferenceCRS(boolean useAlternativeIfAvailable) {
        return this.getProperty(useAlternativeIfAvailable).getCrs2D();
    }

    public boolean isSupportingAlternativeCRSOutput() {
        return this.isSupportingAlternativeCRSOutput;
    }

    public void setSupportingAlternativeCRSOutput(boolean isSupportingAlternativeCRS) {
        this.isSupportingAlternativeCRSOutput = isSupportingAlternativeCRS;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpatialRequestHelper [");
        if (this.requestedBBox != null) {
            builder.append("requestedBBox=");
            builder.append(this.requestedBBox);
            builder.append(", ");
        }
        if (this.coverageProperties.computedBBox != null) {
            builder.append("cropBBox=");
            builder.append(this.coverageProperties.computedBBox);
            builder.append(", ");
        }
        if (this.requestedRasterArea != null) {
            builder.append("requestedRasterArea=");
            builder.append(this.requestedRasterArea);
            builder.append(", ");
        }
        if (this.computedRasterArea != null) {
            builder.append("destinationRasterArea=");
            builder.append(this.computedRasterArea);
            builder.append(", ");
        }
        if (this.requestCRS != null) {
            builder.append("requestCRS=");
            builder.append(this.requestCRS);
            builder.append(", ");
        }
        if (this.requestedGridToWorld != null) {
            builder.append("requestedGridToWorld=");
            builder.append(this.requestedGridToWorld);
            builder.append(", ");
        }
        if (this.computedResolution != null) {
            builder.append("requestedResolution=");
            builder.append(Arrays.toString(this.computedResolution));
            builder.append(", ");
        }
        if (this.requestedBBOXInCoverageGeographicCRS != null) {
            builder.append("requestedBBOXInCoverageGeographicCRS=");
            builder.append(this.requestedBBOXInCoverageGeographicCRS);
            builder.append(", ");
        }
        if (this.requestCRSToCoverageGeographicCRS2D != null) {
            builder.append("requestCRSToCoverageGeographicCRS2D=");
            builder.append(this.requestCRSToCoverageGeographicCRS2D);
            builder.append(", ");
        }
        if (this.destinationToSourceTransform != null) {
            builder.append("destinationToSourceTransform=");
            builder.append(this.destinationToSourceTransform);
            builder.append(", ");
        }
        if (this.coverageProperties != null) {
            builder.append("coverageProperties=");
            builder.append(this.coverageProperties);
            builder.append(", ");
        }
        builder.append("accurateResolution=");
        builder.append(this.accurateResolution);
        builder.append(", empty=");
        builder.append(this.emptyRequest);
        builder.append(", needsReprojection=");
        builder.append(this.isNeedsReprojection());
        builder.append(", ");
        if (this.approximateRequestedBBoInNativeCRS != null) {
            builder.append("approximateRequestedBBoInNativeCRS=");
            builder.append(this.approximateRequestedBBoInNativeCRS);
        }
        builder.append("]");
        return builder.toString();
    }

    public AffineTransform getComputedGridToWorld() {
        return this.computedGridToWorld;
    }

    public static class CoverageProperties {
        ReferencedEnvelope bbox;
        Rectangle rasterArea;
        double[] fullResolution;
        MathTransform2D gridToWorld2D;
        CoordinateReferenceSystem crs2D;
        ReferencedEnvelope geographicBBox;
        CoordinateReferenceSystem geographicCRS;
        ReferencedEnvelope computedBBox;
        boolean reprojectionNeeded;

        public ReferencedEnvelope getBbox() {
            return this.bbox;
        }

        public void setBBox(ReferencedEnvelope bbox) {
            this.bbox = bbox;
        }

        public Rectangle getRasterArea() {
            return this.rasterArea;
        }

        public void setRasterArea(Rectangle rasterArea) {
            this.rasterArea = rasterArea;
        }

        public double[] getFullResolution() {
            return this.fullResolution;
        }

        public void setFullResolution(double[] fullResolution) {
            this.fullResolution = fullResolution;
        }

        public MathTransform2D getGridToWorld2D() {
            return this.gridToWorld2D;
        }

        public void setGridToWorld2D(MathTransform2D gridToWorld2D) {
            this.gridToWorld2D = gridToWorld2D;
        }

        public CoordinateReferenceSystem getCrs2D() {
            return this.crs2D;
        }

        public void setCrs2D(CoordinateReferenceSystem crs2d) {
            this.crs2D = crs2d;
        }

        public ReferencedEnvelope getGeographicBBox() {
            return this.geographicBBox;
        }

        public void setGeographicBBox(ReferencedEnvelope geographicBBox) {
            this.geographicBBox = geographicBBox;
        }

        public CoordinateReferenceSystem getGeographicCRS2D() {
            return this.geographicCRS;
        }

        public void setGeographicCRS2D(CoordinateReferenceSystem geographicCRS2D) {
            this.geographicCRS = geographicCRS2D;
        }

        public ReferencedEnvelope getComputedBBox() {
            return this.computedBBox;
        }

        public void setComputedBBox(ReferencedEnvelope computedBBox) {
            this.computedBBox = computedBBox;
        }

        public boolean isReprojectionNeeded() {
            return this.reprojectionNeeded;
        }

        public void setReprojectionNeeded(boolean reprojectionNeeded) {
            this.reprojectionNeeded = reprojectionNeeded;
        }
    }
}

