/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.RenderingHints;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.util.logging.Logging;

public final class ImageMosaicFormatFactory
implements GridFormatFactorySpi {
    private static final String GDAL_JP2ECW_SPI = "it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi";
    private static final String GDAL_JP2KAKADU_SPI = "it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReaderSpi";
    private static final String GDAL_JP2MrSID_SPI = "it.geosolutions.imageio.plugins.jp2mrsid.JP2GDALMrSidImageReaderSpi";
    private static final String GDAL_SPI = "it.geosolutions.imageio.gdalframework.GDALImageReaderSpi";
    private static final String KAKADU_SPI = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReaderSpi";
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicFormatFactory.class);

    private static boolean hasJP2GDALECW() {
        block15: {
            try {
                Class<?> cl = Class.forName(GDAL_JP2ECW_SPI);
                Class<?> cGdal = Class.forName(GDAL_SPI);
                Object jp2ecwSPI = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = cGdal.getDeclaredMethod("isAvailable", null);
                if (method != null) {
                    return (Boolean)method.invoke(jp2ecwSPI, (Object[])null);
                }
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (NoSuchMethodException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (InvocationTargetException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
                }
            }
            catch (InstantiationException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block15;
                LOGGER.log(Level.FINE, "Unable to load GDAL JP2 ECW Reader SPI", e);
            }
        }
        return false;
    }

    private static boolean hasJP2GDALKakadu() {
        block15: {
            try {
                Class<?> cl = Class.forName(GDAL_JP2KAKADU_SPI);
                Class<?> cGdal = Class.forName(GDAL_SPI);
                Object jp2Kak = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = cGdal.getDeclaredMethod("isAvailable", null);
                if (method != null) {
                    return (Boolean)method.invoke(jp2Kak, (Object[])null);
                }
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (NoSuchMethodException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (InvocationTargetException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
                }
            }
            catch (InstantiationException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block15;
                LOGGER.log(Level.FINE, "Unable to load GDAL JP2 Kakadu Reader SPI", e);
            }
        }
        return false;
    }

    private static boolean hasJP2GDALMRSID() {
        block15: {
            try {
                Class<?> cl = Class.forName(GDAL_JP2MrSID_SPI);
                Class<?> cGdal = Class.forName(GDAL_SPI);
                Object jp2MrSid = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = cGdal.getDeclaredMethod("isAvailable", null);
                if (method != null) {
                    return (Boolean)method.invoke(jp2MrSid, (Object[])null);
                }
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (NoSuchMethodException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (InvocationTargetException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
                }
            }
            catch (InstantiationException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block15;
                LOGGER.log(Level.FINE, "Unable to load GDAL JP2 MrSID Reader SPI", e);
            }
        }
        return false;
    }

    private static boolean hasJP2Kakadu() {
        block13: {
            try {
                Class.forName(KAKADU_SPI);
                Class<?> utilityClass = Class.forName("it.geosolutions.util.KakaduUtilities");
                Method method = utilityClass.getDeclaredMethod("isKakaduAvailable", null);
                if (method != null) {
                    return (Boolean)method.invoke(null, (Object[])null);
                }
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
                }
            }
            catch (SecurityException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
                }
            }
            catch (NoSuchMethodException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
                }
            }
            catch (InvocationTargetException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block13;
                LOGGER.log(Level.FINE, "Unable to load kakadu JPEG2000 reader spi", e);
            }
        }
        return false;
    }

    private static void replaceECW() {
        block4: {
            try {
                String imageioJ2KImageReaderName;
                boolean succeeded;
                boolean succeeded2;
                Class.forName(GDAL_JP2ECW_SPI);
                String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
                if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2ECW_SPI, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi:" + imageioJ2KImageReaderCodecName);
                }
                if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2ECW_SPI, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi:" + imageioJ2KImageReaderName);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "Unable to load specific JPEG2000 reader spi", e);
            }
        }
    }

    private static void replaceGDALKakadu() {
        block4: {
            try {
                String imageioJ2KImageReaderName;
                boolean succeeded;
                boolean succeeded2;
                Class.forName(GDAL_JP2KAKADU_SPI);
                String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
                if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2KAKADU_SPI, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReaderSpi:" + imageioJ2KImageReaderCodecName);
                }
                if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2KAKADU_SPI, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReaderSpi:" + imageioJ2KImageReaderName);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "Unable to load specific JPEG2000 reader spi", e);
            }
        }
    }

    private static void replaceJP2Kakadu() {
        block4: {
            try {
                String imageioJ2KImageReaderName;
                boolean succeeded;
                boolean succeeded2;
                Class.forName(KAKADU_SPI);
                String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
                if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)KAKADU_SPI, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReaderSpi:" + imageioJ2KImageReaderCodecName);
                }
                if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)KAKADU_SPI, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReaderSpi:" + imageioJ2KImageReaderName);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "Unable to load specific JPEG2000 reader spi", e);
            }
        }
    }

    private static void replaceMRSID() {
        block4: {
            try {
                String imageioJ2KImageReaderName;
                boolean succeeded;
                boolean succeeded2;
                Class.forName(GDAL_JP2MrSID_SPI);
                String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
                if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2MrSID_SPI, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2mrsid.JP2GDALMrSidImageReaderSpi:" + imageioJ2KImageReaderCodecName);
                }
                if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)GDAL_JP2MrSID_SPI, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000")) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between jp2 readers spi-it.geosolutions.imageio.plugins.jp2mrsid.JP2GDALMrSidImageReaderSpi:" + imageioJ2KImageReaderName);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "Unable to load specific JPEG2000 reader spi", e);
            }
        }
    }

    private static void replaceTIFF() {
        block3: {
            try {
                String customTiffName = it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi.class.getName();
                Class.forName(customTiffName);
                String imageioTiffName = TIFFImageReaderSpi.class.getName();
                boolean succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)customTiffName, (String)imageioTiffName, (String)"tiff");
                if (!succeeded && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to set ordering between tiff readers spi");
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, "Unable to load specific TIFF reader spi", e);
            }
        }
    }

    public AbstractGridFormat createFormat() {
        return new ImageMosaicFormat();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public boolean isAvailable() {
        boolean available = true;
        try {
            Class.forName("javax.media.jai.JAI");
            Class.forName("com.sun.media.jai.operator.ImageReadDescriptor");
        }
        catch (ClassNotFoundException cnf) {
            available = false;
        }
        return available;
    }

    static {
        ImageMosaicFormatFactory.replaceTIFF();
        if (ImageMosaicFormatFactory.hasJP2Kakadu()) {
            ImageMosaicFormatFactory.replaceJP2Kakadu();
        } else {
            if (ImageMosaicFormatFactory.hasJP2GDALECW()) {
                ImageMosaicFormatFactory.replaceECW();
            }
            if (ImageMosaicFormatFactory.hasJP2GDALMRSID()) {
                ImageMosaicFormatFactory.replaceMRSID();
            }
            if (ImageMosaicFormatFactory.hasJP2GDALKakadu()) {
                ImageMosaicFormatFactory.replaceGDALKakadu();
            }
        }
    }
}

