/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicElementConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ImageMosaicDatastoreWalker
extends ImageMosaicWalker
implements Runnable {
    protected ImageMosaicElementConsumer<SimpleFeature> consumer;
    static final Logger LOGGER = Logging.getLogger(ImageMosaicDatastoreWalker.class);

    public ImageMosaicDatastoreWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, ImageMosaicElementConsumer<SimpleFeature> consumer) {
        super(configHandler, eventHandler);
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block52: {
            String message;
            GranuleCatalog catalog;
            SimpleFeatureIterator it;
            block51: {
                it = null;
                catalog = null;
                this.configHandler.indexingPreamble();
                this.startTransaction();
                catalog = this.configHandler.getCatalog();
                String locationAttrName = this.configHandler.getRunConfiguration().getParameter("LocationAttribute");
                String requestedTypeName = this.configHandler.getRunConfiguration().getParameter("TypeName");
                String[] typeNames = catalog.getTypeNames();
                if (typeNames != null) {
                    block30: for (String typeName : catalog.getTypeNames()) {
                        if (requestedTypeName != null && !requestedTypeName.equals(typeName)) continue;
                        if (!Utils.isValidMosaicSchema(catalog.getType(typeName), locationAttrName)) {
                            LOGGER.log(Level.FINE, "Skipping invalid mosaic index table " + typeName);
                            continue;
                        }
                        Query query = new Query(typeName);
                        int numFiles = catalog.getGranulesCount(query);
                        if (numFiles <= 0) {
                            LOGGER.log(Level.FINE, "No rows in the typeName: " + typeName);
                            continue;
                        }
                        this.setNumElements(numFiles);
                        SimpleFeatureCollection coll = catalog.getGranules(query);
                        SimpleFeatureType schema = (SimpleFeatureType)coll.getSchema();
                        if (schema.getDescriptor(locationAttrName) == null) {
                            LOGGER.fine("Skipping feature type " + typeName + " as the location attribute " + locationAttrName + " is not part of the schema");
                            continue;
                        }
                        if (schema.getGeometryDescriptor() == null) {
                            LOGGER.fine("Skipping feature type " + typeName + " as it does not have a footprint column");
                            continue;
                        }
                        it = coll.features();
                        while (it.hasNext()) {
                            SimpleFeature feature = (SimpleFeature)it.next();
                            this.consumer.handleElement(feature, this);
                            if (!this.getStop()) continue;
                            continue block30;
                        }
                    }
                }
                if (this.getStop()) {
                    this.rollbackTransaction();
                } else {
                    this.commitTransaction();
                }
                if (it == null) break block51;
                try {
                    it.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            try {
                this.closeTransaction();
            }
            catch (Exception e) {
                message = "Unable to close indexing" + e.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                this.eventHandler.fireException(e);
            }
            try {
                this.configHandler.indexingPostamble(!this.getStop());
            }
            catch (Exception e) {
                message = "Unable to close indexing" + e.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                this.eventHandler.fireException(e);
            }
            try {
                if (catalog != null) {
                    catalog.dispose();
                }
                break block52;
            }
            catch (RuntimeException e) {
                message = "Failed to dispose harvesting catalog";
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                break block52;
            }
            catch (Exception e) {
                String message22;
                block53: {
                    try {
                        LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                        try {
                            this.rollbackTransaction();
                        }
                        catch (IOException e1) {
                            throw new IllegalStateException(e1);
                        }
                        if (it == null) break block53;
                    }
                    catch (Throwable throwable) {
                        block54: {
                            String message32;
                            if (it != null) {
                                try {
                                    it.close();
                                }
                                catch (Exception e2) {
                                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                                }
                            }
                            try {
                                this.closeTransaction();
                            }
                            catch (Exception e3) {
                                message32 = "Unable to close indexing" + e3.getLocalizedMessage();
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, message32, e3);
                                }
                                this.eventHandler.fireException(e3);
                            }
                            try {
                                this.configHandler.indexingPostamble(!this.getStop());
                            }
                            catch (Exception e4) {
                                message32 = "Unable to close indexing" + e4.getLocalizedMessage();
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, message32, e4);
                                }
                                this.eventHandler.fireException(e4);
                            }
                            try {
                                if (catalog != null) {
                                    catalog.dispose();
                                }
                            }
                            catch (RuntimeException e5) {
                                message32 = "Failed to dispose harvesting catalog";
                                if (!LOGGER.isLoggable(Level.WARNING)) break block54;
                                LOGGER.log(Level.WARNING, message32, e5);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        it.close();
                    }
                    catch (Exception e6) {
                        LOGGER.log(Level.FINE, e6.getLocalizedMessage(), e6);
                    }
                }
                try {
                    this.closeTransaction();
                }
                catch (Exception e7) {
                    message22 = "Unable to close indexing" + e7.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e7);
                    }
                    this.eventHandler.fireException(e7);
                }
                try {
                    this.configHandler.indexingPostamble(!this.getStop());
                }
                catch (Exception e8) {
                    message22 = "Unable to close indexing" + e8.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e8);
                    }
                    this.eventHandler.fireException(e8);
                }
                try {
                    if (catalog != null) {
                        catalog.dispose();
                    }
                }
                catch (RuntimeException e9) {
                    message22 = "Failed to dispose harvesting catalog";
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e9);
                    }
                }
            }
        }
    }
}

