/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.ImageLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.DefaultProgressListener;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.CoverageNameHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDatastoreWalker;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicFileFeatureConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicSourceElement;
import org.geotools.gce.imagemosaic.ImageMosaicURLFeatureConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ShapefileCompatibleFeature;
import org.geotools.gce.imagemosaic.URLSourceSPIProvider;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.acceptors.DefaultGranuleAcceptorFactory;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptorFactorySPI;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptorFactorySPIFinder;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CogConfiguration;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProviderMosaicFactory;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.catalogbuilder.MosaicBeanBuilder;
import org.geotools.gce.imagemosaic.granulehandler.DefaultGranuleHandler;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandler;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandlerFactoryFinder;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandlerFactorySPI;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandlingException;
import org.geotools.gce.imagemosaic.namecollector.DefaultCoverageNameCollectorSPI;
import org.geotools.gce.imagemosaic.properties.CRSExtractor;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

public class ImageMosaicConfigHandler {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicConfigHandler.class);
    private static final Boolean USE_MEMORY_MAPPED_BUFFERS = !System.getProperty("os.name", "Windows").contains("Windows");
    private List<PropertiesCollector> propertiesCollectors = null;
    private Map<String, MosaicConfigurationBean> configurations = new HashMap<String, MosaicConfigurationBean>();
    private volatile boolean stop = false;
    protected GranuleCatalog catalog;
    private CatalogBuilderConfiguration runConfiguration;
    private ImageReaderSpi cachedReaderSPI;
    private AbstractGridFormat cachedFormat;
    private ReferencedEnvelope imposedBBox;
    private ImageMosaicReader parentReader;
    private File indexerFile;
    private File parent;
    private ImageMosaicEventHandlers eventHandler;
    private boolean useExistingSchema;
    private boolean cog;
    private List<GranuleAcceptor> granuleAcceptors = new ArrayList<GranuleAcceptor>();
    private GranuleHandler granuleHandler = new DefaultGranuleHandler();
    private CoverageNameHandler coverageNameHandler = new CoverageNameHandler(new DefaultCoverageNameCollectorSPI());

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public ImageMosaicConfigHandler(CatalogBuilderConfiguration configuration, ImageMosaicEventHandlers eventHandler) {
        Utilities.ensureNonNull((String)"runConfiguration", (Object)configuration);
        Utilities.ensureNonNull((String)"eventHandler", (Object)eventHandler);
        this.eventHandler = eventHandler;
        Indexer defaultIndexer = configuration.getIndexer();
        ParametersType params = null;
        String rootMosaicDir = null;
        if (defaultIndexer != null) {
            params = defaultIndexer.getParameters();
            rootMosaicDir = IndexerUtils.getParam(params, "RootMosaicDirectory");
        }
        Utilities.ensureNonNull((String)"root location", rootMosaicDir);
        this.parent = new File(rootMosaicDir);
        Indexer indexer = IndexerUtils.initializeIndexer(params, this.parent);
        if (indexer != null) {
            this.indexerFile = indexer.getIndexerFile();
        }
        Hints hints = configuration.getHints();
        String ancillaryFile = null;
        String datastoreFile = null;
        if (indexer != null) {
            String datastoreFileParam;
            configuration.setIndexer(indexer);
            String auxiliaryFileParam = IndexerUtils.getParameter("AuxiliaryFile", indexer);
            if (auxiliaryFileParam != null) {
                ancillaryFile = auxiliaryFileParam;
            }
            if ((datastoreFileParam = IndexerUtils.getParameter("AuxiliaryDatastoreFile", indexer)) != null) {
                datastoreFile = datastoreFileParam;
            }
            if (datastoreFileParam != null || auxiliaryFileParam != null) {
                this.setReader(hints, false);
            }
            if (IndexerUtils.getParameterAsBoolean("UseExistingSchema", indexer)) {
                this.useExistingSchema = true;
            }
            if (IndexerUtils.getParameterAsBoolean("Cog", indexer)) {
                this.cog = true;
            }
        }
        this.initializeGranuleAcceptors(indexer);
        this.initializeGranuleHandler(indexer);
        this.initializeCoverageNameHandler(indexer);
        this.updateConfigurationHints(configuration, hints, ancillaryFile, datastoreFile, IndexerUtils.getParam(params, "RootMosaicDirectory"));
        configuration.check();
        this.runConfiguration = new CatalogBuilderConfiguration(configuration);
    }

    private void initializeGranuleAcceptors(Indexer indexer) {
        String granuleAcceptorsString;
        if (indexer != null && (granuleAcceptorsString = IndexerUtils.getParameter("GranuleAcceptors", indexer)) != null && granuleAcceptorsString.length() > 0) {
            Map<String, GranuleAcceptorFactorySPI> granuleAcceptorsMap = GranuleAcceptorFactorySPIFinder.getGranuleAcceptorFactorySPI();
            Arrays.stream(granuleAcceptorsString.split(",")).forEach(factoryImpl -> {
                if (granuleAcceptorsMap.containsKey(factoryImpl)) {
                    this.granuleAcceptors.addAll(((GranuleAcceptorFactorySPI)granuleAcceptorsMap.get(factoryImpl)).create());
                }
            });
        }
        if (this.granuleAcceptors.isEmpty()) {
            this.granuleAcceptors.addAll(new DefaultGranuleAcceptorFactory().create());
        }
    }

    private void initializeGranuleHandler(Indexer indexer) {
        GranuleHandlerFactorySPI factory;
        String granuleHandlerString;
        if (indexer != null && (granuleHandlerString = IndexerUtils.getParameter("GranuleHandler", indexer)) != null && granuleHandlerString.length() > 0 && (factory = GranuleHandlerFactoryFinder.getGranuleHandlersSPI().get(granuleHandlerString)) != null) {
            this.granuleHandler = factory.create();
        }
    }

    private void initializeCoverageNameHandler(Indexer indexer) {
        String coverageNameCollectorString;
        if (indexer != null && (coverageNameCollectorString = IndexerUtils.getParameter("CoverageNameCollectorSPI", indexer)) != null && coverageNameCollectorString.length() > 0) {
            this.coverageNameHandler = new CoverageNameHandler(coverageNameCollectorString);
        }
    }

    private GranuleCatalog createCatalog(CatalogBuilderConfiguration runConfiguration, boolean create) throws IOException {
        GranuleCatalog catalog;
        File parent = new File(runConfiguration.getParameter("RootMosaicDirectory"));
        File datastoreProperties = new File(parent, "datastore.properties");
        if (Utils.checkFileReadable(datastoreProperties)) {
            Properties properties = ImageMosaicConfigHandler.createGranuleCatalogProperties(datastoreProperties);
            String indexerTypeName = runConfiguration.getParameter("TypeName");
            if (indexerTypeName != null && properties.getProperty("TypeName") == null) {
                properties.put("TypeName", indexerTypeName);
            }
            catalog = ImageMosaicConfigHandler.createGranuleCatalogFromDatastore(parent, properties, create, Boolean.parseBoolean(runConfiguration.getParameter("WrapStore")), runConfiguration.getHints());
        } else {
            URL file = URLs.fileToUrl((File)new File(parent, runConfiguration.getParameter("Name") + ".shp"));
            Properties params = new Properties();
            params.put(ShapefileDataStoreFactory.URLP.key, file);
            if (file.getProtocol().equalsIgnoreCase("file")) {
                params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
            }
            params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, USE_MEMORY_MAPPED_BUFFERS);
            params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
            params.put("LocationAttribute", runConfiguration.getParameter("LocationAttribute"));
            catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, create, Utils.SHAPE_SPI, runConfiguration.getHints());
            MultiLevelROIProvider roi = MultiLevelROIProviderMosaicFactory.createFootprintProvider(parent, runConfiguration.getHints());
            catalog.setMultiScaleROIProvider(roi);
        }
        return catalog;
    }

    static Properties createGranuleCatalogProperties(File datastoreProperties) throws IOException {
        Properties properties = CoverageUtilities.loadPropertiesFromURL((URL)URLs.fileToUrl((File)datastoreProperties));
        if (properties == null) {
            throw new IOException("Unable to load properties from:" + datastoreProperties.getAbsolutePath());
        }
        return properties;
    }

    static GranuleCatalog createGranuleCatalogFromDatastore(File parent, File datastoreProperties, boolean create, Hints hints) throws IOException {
        return ImageMosaicConfigHandler.createGranuleCatalogFromDatastore(parent, datastoreProperties, create, false, hints);
    }

    private static GranuleCatalog createGranuleCatalogFromDatastore(File parent, File datastoreProperties, boolean create, boolean wraps, Hints hints) throws IOException {
        Utilities.ensureNonNull((String)"datastoreProperties", (Object)datastoreProperties);
        Properties properties = ImageMosaicConfigHandler.createGranuleCatalogProperties(datastoreProperties);
        return ImageMosaicConfigHandler.createGranuleCatalogFromDatastore(parent, properties, create, wraps, hints);
    }

    private static GranuleCatalog createGranuleCatalogFromDatastore(File parent, Properties properties, boolean create, boolean wraps, Hints hints) throws IOException {
        GranuleCatalog catalog = null;
        String SPIClass = properties.getProperty("SPI");
        DataStoreFactorySpi spi = null;
        try {
            if (SPIClass == null) {
                if (properties.get("StoreName") == null) {
                    throw new IllegalArgumentException("Required property SPI is missing from configuration");
                }
            } else {
                spi = (DataStoreFactorySpi)Class.forName(SPIClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            properties.put("ParentLocation", URLs.fileToUrl((File)parent).toExternalForm());
            if (wraps) {
                properties.put("WrapStore", (Object)wraps);
            }
            catalog = GranuleCatalogFactory.createGranuleCatalog(properties, false, create, spi, hints);
            MultiLevelROIProvider rois = MultiLevelROIProviderMosaicFactory.createFootprintProvider(parent);
            catalog.setMultiScaleROIProvider(rois);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        return catalog;
    }

    private SimpleFeatureType createSchema(CatalogBuilderConfiguration runConfiguration, String name, CoordinateReferenceSystem actualCRS) {
        SimpleFeatureType indexSchema = null;
        SchemaType schema = null;
        String schemaAttributes = null;
        Indexer indexer = runConfiguration.getIndexer();
        if (indexer != null) {
            List<SchemaType> schemaList;
            SchemasType schemas = indexer.getSchemas();
            Indexer.Coverages.Coverage coverage = IndexerUtils.getCoverage(indexer, name);
            if (coverage != null) {
                schema = IndexerUtils.getSchema(indexer, coverage);
            }
            if (schema != null) {
                schemaAttributes = schema.getAttributes();
            } else if (schemas != null && !(schemaList = schemas.getSchema()).isEmpty()) {
                schemaAttributes = schemaList.get(0).getAttributes();
            }
        }
        if (schemaAttributes == null) {
            schemaAttributes = runConfiguration.getSchema(name);
        }
        if (schemaAttributes != null) {
            schemaAttributes = schemaAttributes.trim();
            try {
                Set identifiers;
                indexSchema = DataUtilities.createType((String)name, (String)schemaAttributes);
                indexSchema = DataUtilities.createSubType((SimpleFeatureType)indexSchema, (String[])DataUtilities.attributeNames((SimpleFeatureType)indexSchema), (CoordinateReferenceSystem)actualCRS);
                if (actualCRS != null && ((identifiers = actualCRS.getIdentifiers()) == null || identifiers.isEmpty())) {
                    Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)actualCRS, (boolean)true);
                    int nativeSrid = code == null ? 0 : code;
                    GeometryDescriptor geometryDescriptor = indexSchema.getGeometryDescriptor();
                    if (geometryDescriptor != null) {
                        Map userData = geometryDescriptor.getUserData();
                        userData.put("nativeSRID", nativeSrid);
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                indexSchema = null;
            }
        }
        if (indexSchema == null) {
            SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
            String typeName = runConfiguration.getParameter("TypeName");
            featureBuilder.setName(typeName != null ? typeName : name);
            featureBuilder.setNamespaceURI((URI)null);
            featureBuilder.add(runConfiguration.getParameter("LocationAttribute").trim(), String.class);
            featureBuilder.add("the_geom", Polygon.class, actualCRS);
            featureBuilder.setDefaultGeometry("the_geom");
            String timeAttribute = runConfiguration.getTimeAttribute();
            ImageMosaicConfigHandler.addAttributes(timeAttribute, featureBuilder, Date.class);
            indexSchema = featureBuilder.buildFeatureType();
        }
        return indexSchema;
    }

    private static void addAttributes(String attribute, SimpleFeatureTypeBuilder featureBuilder, Class classType) {
        if (attribute != null) {
            if (!attribute.contains(";")) {
                featureBuilder.add(attribute, classType);
            } else {
                String[] ranges = attribute.split(";");
                if (ranges.length != 2) {
                    throw new IllegalArgumentException("All ranges attribute need to be composed of a maximum of 2 elements:\nAs an instance (min;max) or (low;high) or (begin;end) , ...");
                }
                featureBuilder.add(ranges[0], classType);
                featureBuilder.add(ranges[1], classType);
            }
        }
    }

    private void updateCatalog(String coverageName, ImageMosaicSourceElement elementBeingProcessed, GridCoverage2DReader inputReader, ImageMosaicReader mosaicReader, CatalogBuilderConfiguration configuration, GeneralEnvelope envelope, DefaultTransaction transaction, List<PropertiesCollector> propertiesCollectors) throws IOException, GranuleHandlingException {
        GranuleStore store = (GranuleStore)mosaicReader.getGranules(coverageName, false);
        if (store == null) {
            throw new IllegalArgumentException("No valid granule store has been found for: " + coverageName);
        }
        SimpleFeatureType indexSchema = store.getSchema();
        ShapefileCompatibleFeature feature = new ShapefileCompatibleFeature(DataUtilities.template((SimpleFeatureType)indexSchema));
        store.setTransaction((Transaction)transaction);
        ListFeatureCollection collection = new ListFeatureCollection(indexSchema);
        String fileLocation = elementBeingProcessed.getLocation(configuration);
        String locationAttribute = configuration.getParameter("LocationAttribute");
        MosaicConfigurationBean mosaicConfiguration = this.getConfigurations().get(coverageName);
        GranuleHandler geometryHandler = this.getGeometryHandler();
        if (inputReader instanceof StructuredGridCoverage2DReader) {
            this.handleStructuredGridCoverage(((StructuredGridCoverage2DReader)inputReader).getGranules(coverageName, true), elementBeingProcessed, inputReader, propertiesCollectors, indexSchema, feature, collection, fileLocation, locationAttribute, mosaicConfiguration);
        } else {
            geometryHandler.handleGranule(elementBeingProcessed, inputReader, feature, indexSchema, null, null, mosaicConfiguration);
            feature.setAttribute(locationAttribute, fileLocation);
            ImageMosaicConfigHandler.updateAttributesFromCollectors(feature, elementBeingProcessed, inputReader, propertiesCollectors);
            collection.add((SimpleFeature)feature);
        }
        boolean ignoreCase = elementBeingProcessed.getInnerObject() instanceof File && !ImageMosaicConfigHandler.isCaseSensitiveFileSystem((File)elementBeingProcessed.getInnerObject());
        PropertyIsEqualTo filter = Utils.FF.equal((Expression)Utils.FF.property(locationAttribute), (Expression)Utils.FF.literal((Object)fileLocation), ignoreCase);
        store.removeGranules((Filter)filter);
        store.addGranules((SimpleFeatureCollection)collection);
    }

    private void handleStructuredGridCoverage(GranuleSource granules, final ImageMosaicSourceElement elementBeingProcessed, final GridCoverage2DReader inputReader, final List<PropertiesCollector> propertiesCollectors, final SimpleFeatureType indexSchema, SimpleFeature feature, final ListFeatureCollection collection, final String fileLocation, final String locationAttribute, final MosaicConfigurationBean mosaicConfiguration) throws IOException {
        GranuleSource source = granules;
        SimpleFeatureCollection originCollection = source.getGranules(null);
        final DefaultProgressListener listener = new DefaultProgressListener();
        Collection destProps = feature.getProperties();
        final HashSet<Name> destAttributes = new HashSet<Name>();
        for (Property prop : destProps) {
            destAttributes.add(prop.getName());
        }
        final GranuleHandler geometryHandler = this.granuleHandler;
        originCollection.accepts((FeatureVisitor)new AbstractFeatureVisitor(){

            public void visit(Feature feature) {
                if (feature instanceof SimpleFeature) {
                    SimpleFeature sourceFeature = (SimpleFeature)feature;
                    SimpleFeature destFeature = DataUtilities.template((SimpleFeatureType)indexSchema);
                    Collection props = sourceFeature.getProperties();
                    Name propName = null;
                    Object propValue = null;
                    for (Property prop : props) {
                        Name geometryName = sourceFeature.getFeatureType().getGeometryDescriptor().getName();
                        if (prop.getName().equals((Object)geometryName)) {
                            try {
                                geometryHandler.handleGranule(elementBeingProcessed, inputReader, destFeature, destFeature.getFeatureType(), sourceFeature, sourceFeature.getFeatureType(), mosaicConfiguration);
                                continue;
                            }
                            catch (GranuleHandlingException e) {
                                throw new RuntimeException("Error handling structured coverage granule", e);
                            }
                        }
                        propName = prop.getName();
                        propValue = prop.getValue();
                        if (!destAttributes.contains(propName)) continue;
                        destFeature.setAttribute(propName, propValue);
                    }
                    destFeature.setAttribute(locationAttribute, (Object)fileLocation);
                    ImageMosaicConfigHandler.updateAttributesFromCollectors(destFeature, elementBeingProcessed, inputReader, propertiesCollectors);
                    collection.add(destFeature);
                    if (listener.isCanceled() || listener.hasExceptions()) {
                        if (listener.hasExceptions()) {
                            throw new RuntimeException((Throwable)listener.getExceptions().peek());
                        }
                        throw new IllegalStateException("Feature visitor has been canceled");
                    }
                }
            }
        }, (ProgressListener)listener);
    }

    private GranuleHandler getGeometryHandler() {
        return this.granuleHandler;
    }

    private static boolean isCaseSensitiveFileSystem(File fileBeingProcessed) {
        File loCase = new File(fileBeingProcessed.getParentFile(), fileBeingProcessed.getName().toLowerCase());
        File upCase = new File(fileBeingProcessed.getParentFile(), fileBeingProcessed.getName().toUpperCase());
        return loCase.exists() && upCase.exists();
    }

    private static void updateAttributesFromCollectors(SimpleFeature feature, ImageMosaicSourceElement elementBeingProcessed, GridCoverage2DReader inputReader, List<PropertiesCollector> propertiesCollectors) {
        if (propertiesCollectors != null && propertiesCollectors.size() > 0) {
            for (PropertiesCollector pc : propertiesCollectors) {
                elementBeingProcessed.addToCollector(pc);
                pc.collect(inputReader).setProperties(feature);
                pc.reset();
            }
        }
    }

    private static void checkTypeName(URL sourceURL, MosaicConfigurationBean configuration) throws IOException {
        CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
        if (catalogBean.getTypeName() == null) {
            if (sourceURL.getPath().endsWith("shp")) {
                File file = URLs.urlToFile((URL)sourceURL);
                catalogBean.setTypeName(FilenameUtils.getBaseName((String)file.getCanonicalPath()));
            } else {
                catalogBean.setTypeName("mosaic");
            }
        }
    }

    static GranuleCatalog createCatalog(URL sourceURL, MosaicConfigurationBean configuration, Hints hints) throws IOException {
        CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
        ImageMosaicConfigHandler.checkTypeName(sourceURL, configuration);
        if (hints != null && hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
            String hintLocation = (String)hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
            if (!catalogBean.getLocationAttribute().equalsIgnoreCase(hintLocation)) {
                throw new DataSourceException("wrong location attribute");
            }
        }
        GranuleCatalog catalog = GranuleCatalogFactory.createGranuleCatalog(sourceURL, catalogBean, null, hints);
        File parent = URLs.urlToFile((URL)sourceURL).getParentFile();
        MultiLevelROIProvider rois = MultiLevelROIProviderMosaicFactory.createFootprintProvider(parent);
        catalog.setMultiScaleROIProvider(rois);
        return catalog;
    }

    private ImageMosaicReader getImageMosaicReader(Hints hints) {
        Object reader;
        ImageMosaicReader imReader = null;
        if (hints != null && hints.containsKey((Object)Utils.MOSAIC_READER) && (reader = hints.get((Object)Utils.MOSAIC_READER)) instanceof ImageMosaicReader) {
            if (this.getParentReader() == null) {
                this.setParentReader((ImageMosaicReader)((Object)reader));
            }
            imReader = (ImageMosaicReader)((Object)reader);
        }
        return imReader;
    }

    private void setReader(Hints hints, boolean updateHints) {
        ImageMosaicReader reader = this.getImageMosaicReader(hints);
        if (reader != null && updateHints) {
            Hints readerHints = reader.getHints();
            readerHints.add((RenderingHints)hints);
        }
    }

    private Hints updateRepositoryHints(CatalogBuilderConfiguration configuration, Hints hints) {
        Hints readerHints;
        ImageMosaicReader reader = this.getImageMosaicReader(hints);
        if (reader != null && (readerHints = reader.getHints()) != null && readerHints.containsKey((Object)Hints.REPOSITORY)) {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.REPOSITORY, readerHints.get((Object)Hints.REPOSITORY)));
        }
        return hints;
    }

    private void updateConfigurationHints(CatalogBuilderConfiguration configuration, Hints hints, String ancillaryFile, String datastoreFile, String rootMosaicDir) {
        boolean isAbsolutePath = Boolean.parseBoolean(configuration.getParameter("AbsolutePath"));
        hints = this.updateHints(ancillaryFile, isAbsolutePath, rootMosaicDir, configuration, hints, Utils.AUXILIARY_FILES_PATH);
        hints = this.updateHints(datastoreFile, isAbsolutePath, rootMosaicDir, configuration, hints, Utils.AUXILIARY_DATASTORE_PATH);
        hints = this.updateRepositoryHints(configuration, hints);
        this.setReader(hints, true);
    }

    private Hints updateHints(String filePath, boolean isAbsolutePath, String rootMosaicDir, CatalogBuilderConfiguration configuration, Hints hints, Hints.Key key) {
        String updatedFilePath = null;
        if (filePath != null) {
            updatedFilePath = isAbsolutePath && !filePath.startsWith(rootMosaicDir) ? rootMosaicDir + File.separatorChar + filePath : filePath;
            if (hints != null) {
                hints.put((Object)key, (Object)updatedFilePath);
            } else {
                hints = new Hints((RenderingHints.Key)key, (Object)updatedFilePath);
                configuration.setHints(hints);
            }
            if (!isAbsolutePath) {
                hints.put((Object)Utils.PARENT_DIR, (Object)rootMosaicDir);
            }
        }
        return hints;
    }

    public void reset() {
        this.eventHandler.removeAllProcessingEventListeners();
        this.stop = false;
        this.runConfiguration = null;
        this.catalog.dispose();
    }

    public boolean getStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
    }

    void indexingPreamble() throws IOException {
        block2: {
            this.catalog = this.buildCatalog();
            String bbox = this.runConfiguration.getParameter("Envelope2D");
            try {
                this.imposedBBox = Utils.parseEnvelope(bbox);
            }
            catch (Exception e) {
                this.imposedBBox = null;
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, "Unable to parse imposed bbox", e);
            }
        }
        this.loadPropertyCollectors();
    }

    protected GranuleCatalog buildCatalog() throws IOException {
        GranuleCatalog catalog;
        this.getParentReader().granuleCatalog = catalog = this.createCatalog(this.runConfiguration, !this.useExistingSchema);
        return catalog;
    }

    private void loadPropertyCollectors() {
        Indexer indexer = this.runConfiguration.getIndexer();
        Indexer.Collectors collectors = indexer.getCollectors();
        Boolean heterogeneousCRS = Boolean.valueOf(IndexerUtils.getParameter("HeterogeneousCRS", indexer));
        if (collectors == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No properties collector have been found");
            }
            if (heterogeneousCRS.booleanValue()) {
                this.propertiesCollectors = Collections.singletonList(new CRSExtractor());
                for (MosaicConfigurationBean configuration : this.configurations.values()) {
                    configuration.getCatalogConfigurationBean().setHeterogeneousCRS(true);
                }
            }
            return;
        }
        List<Indexer.Collectors.Collector> collectorList = collectors.getCollector();
        Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        ArrayList<PropertiesCollector> pcs = new ArrayList<PropertiesCollector>();
        boolean hasCRSCollector = false;
        for (Indexer.Collectors.Collector collector : collectorList) {
            PropertiesCollector pc;
            PropertiesCollectorSPI selectedSPI = null;
            String spiName = collector.getSpi();
            for (PropertiesCollectorSPI spi : pcSPIs) {
                if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(spiName)) continue;
                selectedSPI = spi;
                break;
            }
            if (selectedSPI == null) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to find a PropertyCollector for this definition: " + spiName);
                continue;
            }
            String collectorValue = collector.getValue();
            String config = null;
            if (collectorValue != null) {
                config = !collectorValue.startsWith("regex=") ? "regex=" + collector.getValue() : collector.getValue();
            }
            if ((pc = selectedSPI.create(config, Arrays.asList(collector.getMapped()))) != null) {
                hasCRSCollector |= pc instanceof CRSExtractor;
                pcs.add(pc);
                continue;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Unable to create PropertyCollector");
        }
        if (heterogeneousCRS.booleanValue() && !hasCRSCollector) {
            pcs.add(new CRSExtractor());
        }
        this.propertiesCollectors = pcs;
    }

    void indexingPostamble(boolean success) throws IOException {
        if (success) {
            boolean haveConfigs;
            Indexer indexer = this.runConfiguration.getIndexer();
            boolean supportsEmpty = false;
            if (indexer != null) {
                supportsEmpty = IndexerUtils.getParameterAsBoolean("CanBeEmpty", indexer);
            }
            boolean bl = haveConfigs = this.configurations != null && !this.configurations.isEmpty();
            if (haveConfigs || supportsEmpty) {
                Set<String> keys = this.configurations.keySet();
                int keySize = keys.size();
                if (haveConfigs || !supportsEmpty) {
                    boolean useName = keySize > 1;
                    for (String key : keys) {
                        MosaicConfigurationBean mosaicConfiguration = this.configurations.get(key);
                        RasterManager manager = this.parentReader.getRasterManager(key);
                        manager.initialize(supportsEmpty);
                        this.createSampleImage(mosaicConfiguration, useName);
                        this.eventHandler.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
                        this.createPropertiesFiles(mosaicConfiguration);
                    }
                }
                String base = FilenameUtils.getName((String)this.parent.getAbsolutePath());
                if (supportsEmpty || keySize > 1 || keySize > 0 && !base.equals(keys.iterator().next())) {
                    File mosaicFile = null;
                    File originFile = null;
                    if (this.indexerFile.getAbsolutePath().endsWith("xml")) {
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.xml", base + ".xml"));
                        originFile = this.indexerFile;
                    } else if (this.indexerFile.getAbsolutePath().endsWith("properties")) {
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.properties", base + ".properties"));
                        originFile = this.indexerFile;
                    } else {
                        String source = this.runConfiguration.getParameter("RootMosaicDirectory") + File.separatorChar + this.configurations.get(keys.iterator().next()).getName() + ".properties";
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.properties", base + ".properties"));
                        originFile = new File(source);
                    }
                    if (!mosaicFile.exists()) {
                        FileUtils.copyFile((File)originFile, (File)mosaicFile);
                    }
                }
                this.eventHandler.fireEvent(Level.FINE, "Done!!!", 100.0);
            } else {
                this.eventHandler.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
            }
        } else {
            this.eventHandler.fireEvent(Level.FINE, "Canceled!!!", 100.0);
        }
    }

    private void createSampleImage(MosaicConfigurationBean mosaicConfiguration, boolean useName) {
        Utilities.ensureNonNull((String)"mosaicConfiguration", (Object)mosaicConfiguration);
        String filePath = null;
        if (mosaicConfiguration.getSampleModel() != null && mosaicConfiguration.getColorModel() != null) {
            String baseName = this.runConfiguration.getParameter("RootMosaicDirectory") + "/";
            filePath = baseName + (useName ? mosaicConfiguration.getName() : "") + "sample_image.dat";
            try {
                Utils.storeSampleImage(new File(filePath), mosaicConfiguration.getSampleModel(), mosaicConfiguration.getColorModel());
            }
            catch (IOException e) {
                this.eventHandler.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            }
        }
    }

    private void createPropertiesFiles(MosaicConfigurationBean mosaicConfiguration) {
        URLSourceSPIProvider urlSourceSpiProvider;
        String additionalDomainAttribute;
        String crsAttribute;
        String elevationAttribute;
        CatalogConfigurationBean catalogConfigurationBean = mosaicConfiguration.getCatalogConfigurationBean();
        Properties properties = new Properties();
        properties.setProperty("PathType", catalogConfigurationBean.getPathType().toString());
        properties.setProperty("LocationAttribute", catalogConfigurationBean.getLocationAttribute());
        String timeAttribute = mosaicConfiguration.getTimeAttribute();
        if (timeAttribute != null) {
            properties.setProperty("TimeAttribute", mosaicConfiguration.getTimeAttribute());
        }
        if ((elevationAttribute = mosaicConfiguration.getElevationAttribute()) != null) {
            properties.setProperty("ElevationAttribute", mosaicConfiguration.getElevationAttribute());
        }
        if ((crsAttribute = mosaicConfiguration.getCRSAttribute()) != null) {
            properties.setProperty("CrsAttribute", mosaicConfiguration.getCRSAttribute());
        }
        if ((additionalDomainAttribute = mosaicConfiguration.getAdditionalDomainAttributes()) != null) {
            properties.setProperty("AdditionalDomainAttributes", mosaicConfiguration.getAdditionalDomainAttributes());
        }
        int numberOfLevels = mosaicConfiguration.getLevelsNum();
        double[][] resolutionLevels = mosaicConfiguration.getLevels();
        properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
        StringBuilder levels = new StringBuilder();
        for (int k = 0; k < numberOfLevels; ++k) {
            levels.append(Double.toString(resolutionLevels[k][0])).append(",").append(Double.toString(resolutionLevels[k][1]));
            if (k >= numberOfLevels - 1) continue;
            levels.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("Name", mosaicConfiguration.getName());
        String typeName = mosaicConfiguration.getCatalogConfigurationBean().getTypeName();
        if (typeName == null) {
            typeName = mosaicConfiguration.getName();
        }
        properties.setProperty("TypeName", typeName);
        properties.setProperty("ExpandToRGB", Boolean.toString(mosaicConfiguration.isExpandToRGB()));
        properties.setProperty("CheckAuxiliaryMetadata", Boolean.toString(mosaicConfiguration.isCheckAuxiliaryMetadata()));
        properties.setProperty("Heterogeneous", Boolean.toString(catalogConfigurationBean.isHeterogeneous()));
        properties.setProperty("HeterogeneousCRS", Boolean.toString(catalogConfigurationBean.isHeterogeneousCRS()));
        boolean wrapStore = catalogConfigurationBean.isWrapStore();
        if (wrapStore) {
            properties.setProperty("WrapStore", Boolean.toString(wrapStore));
        }
        if (this.cachedReaderSPI != null) {
            properties.setProperty("SuggestedSPI", this.cachedReaderSPI.getClass().getName());
        }
        if (this.cachedFormat != null) {
            properties.setProperty("SuggestedFormat", this.cachedFormat.getClass().getName());
        }
        if ((urlSourceSpiProvider = catalogConfigurationBean.getUrlSourceSPIProvider()) instanceof CogConfiguration) {
            String password;
            String user;
            CogConfiguration cogBean = (CogConfiguration)urlSourceSpiProvider;
            properties.setProperty("Cog", Boolean.toString(true));
            String rangeReader = cogBean.getRangeReader();
            if (rangeReader != null) {
                properties.setProperty("CogRangeReader", rangeReader);
            }
            if ((user = cogBean.getUser()) != null) {
                properties.setProperty("CogUser", user);
            }
            if ((password = cogBean.getPassword()) != null) {
                properties.setProperty("CogPassword", password);
            }
            boolean useCache = cogBean.isUseCache();
            properties.setProperty("CogUseCache", Boolean.toString(useCache));
        }
        if (this.imposedBBox != null) {
            properties.setProperty("Envelope2D", this.imposedBBox.getMinX() + "," + this.imposedBBox.getMinY() + " " + this.imposedBBox.getMaxX() + "," + this.imposedBBox.getMaxY());
        }
        properties.setProperty("Caching", Boolean.toString(catalogConfigurationBean.isCaching()));
        if (mosaicConfiguration.getAuxiliaryFilePath() != null) {
            properties.setProperty("AuxiliaryFile", mosaicConfiguration.getAuxiliaryFilePath());
        }
        if (mosaicConfiguration.getAuxiliaryDatastorePath() != null) {
            properties.setProperty("AuxiliaryDatastoreFile", mosaicConfiguration.getAuxiliaryDatastorePath());
        }
        if (mosaicConfiguration.getCoverageNameCollectorSpi() != null) {
            properties.setProperty("CoverageNameCollectorSPI", mosaicConfiguration.getCoverageNameCollectorSpi());
        }
        if (mosaicConfiguration.getCrs() != null) {
            properties.setProperty("MosaicCRS", CRS.toSRS((CoordinateReferenceSystem)mosaicConfiguration.getCrs()));
        }
        if (mosaicConfiguration.getNoData() != null) {
            properties.setProperty("NoData", String.valueOf(mosaicConfiguration.getNoData()));
        }
        String filePath = this.runConfiguration.getParameter("RootMosaicDirectory") + "/" + mosaicConfiguration.getName() + ".properties";
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(filePath));){
            properties.store(outStream, "-Automagically created from GeoTools-");
        }
        catch (IOException e) {
            this.eventHandler.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
        }
    }

    protected boolean coverageExists(String coverageName) throws IOException {
        String[] coverages;
        for (String coverage : coverages = this.getParentReader().getGridCoverageNames()) {
            if (!coverage.equals(coverageName)) continue;
            return true;
        }
        return false;
    }

    public void updateConfiguration(GridCoverage2DReader coverageReader, String inputCoverageName, File fileBeingProcessed, int fileIndex, double numFiles, DefaultTransaction transaction) throws IOException, GranuleHandlingException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        this.updateConfiguration(coverageReader, inputCoverageName, new ImageMosaicSourceElement.FileElement(fileBeingProcessed), fileIndex, numFiles, transaction);
    }

    public void updateConfiguration(GridCoverage2DReader coverageReader, String inputCoverageName, ImageMosaicSourceElement element, int fileIndex, double numFiles, DefaultTransaction transaction) throws IOException, GranuleHandlingException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        CatalogBuilderConfiguration catalogConfig;
        String targetCoverageName = this.getTargetCoverageName(coverageReader, inputCoverageName);
        Indexer indexer = this.getRunConfiguration().getIndexer();
        boolean coverageExists = this.coverageExists(targetCoverageName);
        MosaicConfigurationBean mosaicConfiguration = null;
        MosaicConfigurationBean currentConfigurationBean = null;
        RasterManager rasterManager = null;
        if (coverageExists) {
            rasterManager = this.getParentReader().getRasterManager(targetCoverageName);
            mosaicConfiguration = rasterManager.getConfiguration();
            this.configurations.put(mosaicConfiguration.getName(), mosaicConfiguration);
        }
        MosaicBeanBuilder configBuilder = new MosaicBeanBuilder();
        GeneralEnvelope envelope = coverageReader.getOriginalEnvelope(inputCoverageName);
        CoordinateReferenceSystem actualCRS = coverageReader.getCoordinateReferenceSystem(inputCoverageName);
        SampleModel sm = null;
        ColorModel cm = null;
        int numberOfLevels = 1;
        double[][] resolutionLevels = null;
        Boolean heterogeneousCRS = Boolean.valueOf(IndexerUtils.getParameter("HeterogeneousCRS", indexer));
        if (mosaicConfiguration == null) {
            String mosaicCrs;
            catalogConfig = this.getRunConfiguration();
            ImageLayout layout = coverageReader.getImageLayout(inputCoverageName);
            cm = layout.getColorModel(null);
            sm = layout.getSampleModel(null);
            configBuilder.setSampleModel(sm);
            configBuilder.setColorModel(cm);
            ColorModel defaultCM = cm;
            if (defaultCM instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)defaultCM;
                byte[][] defaultPalette = Utils.extractPalette(icm);
                configBuilder.setPalette(defaultPalette);
            }
            if ((mosaicCrs = IndexerUtils.getParameter("MosaicCRS", indexer)) != null) {
                configBuilder.setCrs(CRS.decode((String)mosaicCrs, (boolean)true));
            } else {
                configBuilder.setCrs(actualCRS);
            }
            String noData = IndexerUtils.getParameter("NoData", indexer);
            if (noData != null && !noData.isEmpty()) {
                try {
                    double noDataValue = Double.parseDouble(noData);
                    configBuilder.setNoData(noDataValue);
                }
                catch (NumberFormatException e) {
                    String error = "Invalid NoData specification " + noData + ", was expecting a number";
                    LOGGER.log(Level.WARNING, error);
                    throw new RuntimeException(error, e);
                }
            }
            resolutionLevels = this.getResolutionLevels(coverageReader, inputCoverageName, configBuilder.getCrs());
            numberOfLevels = resolutionLevels.length;
            configBuilder.setLevels(resolutionLevels);
            configBuilder.setLevelsNum(numberOfLevels);
            configBuilder.setName(targetCoverageName);
            configBuilder.setTimeAttribute(IndexerUtils.getAttribute(targetCoverageName, "TIME", indexer));
            configBuilder.setCrsAttribute(IndexerUtils.getAttribute(targetCoverageName, "CrsAttribute", indexer));
            configBuilder.setElevationAttribute(IndexerUtils.getAttribute(targetCoverageName, "ELEVATION", indexer));
            configBuilder.setAdditionalDomainAttributes(IndexerUtils.getAttribute(targetCoverageName, "ADDITIONAL", indexer));
            Hints runHints = this.getRunConfiguration().getHints();
            if (runHints != null) {
                String auxiliaryDatastorePath;
                String auxiliaryFilePath;
                if (runHints.containsKey((Object)Utils.AUXILIARY_FILES_PATH) && (auxiliaryFilePath = (String)runHints.get((Object)Utils.AUXILIARY_FILES_PATH)) != null && auxiliaryFilePath.trim().length() > 0) {
                    configBuilder.setAuxiliaryFilePath(auxiliaryFilePath);
                }
                if (runHints.containsKey((Object)Utils.AUXILIARY_DATASTORE_PATH) && (auxiliaryDatastorePath = (String)runHints.get((Object)Utils.AUXILIARY_DATASTORE_PATH)) != null && auxiliaryDatastorePath.trim().length() > 0) {
                    configBuilder.setAuxiliaryDatastorePath(auxiliaryDatastorePath);
                }
            }
            CatalogConfigurationBean catalogConfigurationBean = new CatalogConfigurationBean();
            catalogConfigurationBean.setCaching(IndexerUtils.getParameterAsBoolean("Caching", indexer));
            if (IndexerUtils.getParameterAsBoolean("AbsolutePath", indexer)) {
                catalogConfigurationBean.setPathType(PathType.ABSOLUTE);
            } else {
                catalogConfigurationBean.setPathType(PathType.RELATIVE);
            }
            PathType pathType = IndexerUtils.getParameterAsEnum("PathType", PathType.class, indexer);
            if (pathType != null) {
                catalogConfigurationBean.setPathType(pathType);
            }
            catalogConfigurationBean.setLocationAttribute(IndexerUtils.getParameter("LocationAttribute", indexer));
            catalogConfigurationBean.setWrapStore(IndexerUtils.getParameterAsBoolean("WrapStore", indexer));
            this.setCogConfiguration(catalogConfigurationBean, indexer);
            String configuredTypeName = IndexerUtils.getParameter("TypeName", indexer);
            if (configuredTypeName != null) {
                catalogConfigurationBean.setTypeName(configuredTypeName);
            } else {
                catalogConfigurationBean.setTypeName(targetCoverageName);
            }
            configBuilder.setCatalogConfigurationBean(catalogConfigurationBean);
            configBuilder.setCheckAuxiliaryMetadata(IndexerUtils.getParameterAsBoolean("CheckAuxiliaryMetadata", indexer));
            currentConfigurationBean = configBuilder.getMosaicConfigurationBean();
            if (heterogeneousCRS.booleanValue()) {
                currentConfigurationBean.getCatalogConfigurationBean().setHeterogeneous(true);
                currentConfigurationBean.getCatalogConfigurationBean().setHeterogeneousCRS(true);
            }
            this.getParentReader().addRasterManager(currentConfigurationBean, false);
            if (!this.useExistingSchema) {
                SimpleFeatureType indexSchema = this.createSchema(this.getRunConfiguration(), currentConfigurationBean.getName(), configBuilder.getCrs());
                this.getParentReader().createCoverage(targetCoverageName, indexSchema);
            }
            this.getConfigurations().put(currentConfigurationBean.getName(), currentConfigurationBean);
        } else {
            catalogConfig = new CatalogBuilderConfiguration();
            CatalogConfigurationBean bean = mosaicConfiguration.getCatalogConfigurationBean();
            catalogConfig.setParameter("LocationAttribute", bean.getLocationAttribute());
            catalogConfig.setParameter("AbsolutePath", Boolean.toString(bean.getPathType() == PathType.ABSOLUTE));
            catalogConfig.setParameter("PathType", bean.getPathType().toString());
            catalogConfig.setParameter("RootMosaicDirectory", this.getRunConfiguration().getParameter("RootMosaicDirectory"));
            CatalogConfigurationBean catalogConfigurationBean = bean;
            resolutionLevels = this.getResolutionLevels(coverageReader, inputCoverageName, mosaicConfiguration.getCrs());
            numberOfLevels = resolutionLevels.length;
            int originalNumberOfLevels = mosaicConfiguration.getLevelsNum();
            boolean needUpdate = false;
            if (Utils.homogeneousCheck(Math.min(numberOfLevels, originalNumberOfLevels), resolutionLevels, mosaicConfiguration.getLevels())) {
                if (numberOfLevels != originalNumberOfLevels) {
                    catalogConfigurationBean.setHeterogeneous(true);
                    if (numberOfLevels > originalNumberOfLevels) {
                        needUpdate = true;
                    }
                }
            } else {
                catalogConfigurationBean.setHeterogeneous(true);
                if (this.isHigherResolution(resolutionLevels, mosaicConfiguration.getLevels())) {
                    needUpdate = true;
                }
            }
            if (needUpdate) {
                mosaicConfiguration.setLevels(resolutionLevels);
                mosaicConfiguration.setLevelsNum(numberOfLevels);
                this.getConfigurations().put(mosaicConfiguration.getName(), mosaicConfiguration);
            }
        }
        if (!this.useExistingSchema) {
            this.updateCatalog(targetCoverageName, element, coverageReader, this.getParentReader(), catalogConfig, envelope, transaction, this.getPropertiesCollectors());
        }
    }

    private void setCogConfiguration(CatalogConfigurationBean catalogConfigurationBean, Indexer indexer) {
        if (IndexerUtils.getParameterAsBoolean("Cog", indexer)) {
            CogConfiguration cogConfiguration = new CogConfiguration(indexer);
            catalogConfigurationBean.setUrlSourceSPIProvider(cogConfiguration);
        }
    }

    private double[][] getResolutionLevels(GridCoverage2DReader coverageReader, String inputCoverageName, CoordinateReferenceSystem mosaicCRS) throws IOException, FactoryException, TransformException {
        double[][] resolutionLevels = coverageReader.getResolutionLevels(inputCoverageName);
        CoordinateReferenceSystem readerCRS = coverageReader.getCoordinateReferenceSystem();
        if (mosaicCRS != null && readerCRS != null && !CRS.equalsIgnoreMetadata((Object)mosaicCRS, (Object)readerCRS)) {
            resolutionLevels = this.transformResolutionLevels(resolutionLevels, readerCRS, mosaicCRS, coverageReader.getOriginalEnvelope());
        }
        return resolutionLevels;
    }

    private double[][] transformResolutionLevels(double[][] resolutionLevels, CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, GeneralEnvelope sourceEnvelope) throws FactoryException, TransformException {
        int numLevels = resolutionLevels.length;
        double[] points = new double[numLevels * 8];
        double baseX = sourceEnvelope.getMedian(0);
        double baseY = sourceEnvelope.getMedian(1);
        int j = 0;
        for (int i = 0; i < numLevels; ++i) {
            points[j++] = baseX;
            points[j++] = baseY;
            points[j++] = baseX + resolutionLevels[i][0];
            points[j++] = baseY;
            points[j++] = baseX;
            points[j++] = baseY;
            points[j++] = baseX;
            points[j++] = baseY + resolutionLevels[i][1];
        }
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS);
        mt.transform(points, 0, points, 0, numLevels * 4);
        double[][] result = new double[numLevels][2];
        for (int i = 0; i < numLevels; ++i) {
            result[i][0] = this.distance(points, i * 8);
            result[i][1] = this.distance(points, i * 8 + 4);
        }
        return result;
    }

    private double distance(double[] points, int base) {
        double dx = points[base + 2] - points[base];
        double dy = points[base + 3] - points[base + 1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public String getTargetCoverageName(GridCoverage2DReader inputCoverageReader, String inputCoverageName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", this.getRunConfiguration().getParameter("Name"));
        map.put("InputCoverageName", inputCoverageName);
        return this.coverageNameHandler.getTargetCoverageName(inputCoverageReader, map);
    }

    private boolean isHigherResolution(double[][] a, double[][] b) {
        for (int i = 0; i < Math.min(a.length, b.length); ++i) {
            for (int j = 0; j < Math.min(a[i].length, b[i].length); ++j) {
                if (a[i][j] < b[i][j]) {
                    return true;
                }
                if (!(a[i][j] > b[i][j])) continue;
                return false;
            }
        }
        return false;
    }

    public void dispose() {
        this.reset();
    }

    public Map<String, MosaicConfigurationBean> getConfigurations() {
        return this.configurations;
    }

    public GranuleCatalog getCatalog() {
        return this.catalog;
    }

    public CatalogBuilderConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    public ImageMosaicReader getParentReader() {
        return this.parentReader;
    }

    public void setParentReader(ImageMosaicReader parentReader) {
        this.parentReader = parentReader;
    }

    public List<PropertiesCollector> getPropertiesCollectors() {
        return this.propertiesCollectors;
    }

    public boolean isUseExistingSchema() {
        return this.useExistingSchema;
    }

    public boolean isCog() {
        return this.cog;
    }

    public ImageReaderSpi getCachedReaderSPI() {
        return this.cachedReaderSPI;
    }

    public void setCachedReaderSPI(ImageReaderSpi cachedReaderSPI) {
        this.cachedReaderSPI = cachedReaderSPI;
    }

    public AbstractGridFormat getCachedFormat() {
        return this.cachedFormat;
    }

    public void setCachedFormat(AbstractGridFormat cachedFormat) {
        this.cachedFormat = cachedFormat;
    }

    public List<GranuleAcceptor> getGranuleAcceptors() {
        return this.granuleAcceptors;
    }

    public RasterManager getRasterManagerForTargetCoverage(String targetCoverageName) {
        return this.getParentReader().getRasterManager(targetCoverageName);
    }

    public ImageMosaicWalker createWalker() {
        ImageMosaicWalker walker;
        if (this.isCog()) {
            CogConfiguration urlSourceSPIProvider = new CogConfiguration(this.getRunConfiguration().getIndexer());
            ImageMosaicURLFeatureConsumer.ImageMosaicURLConsumer urlsConsumer = new ImageMosaicURLFeatureConsumer.ImageMosaicURLConsumer(urlSourceSPIProvider);
            walker = new ImageMosaicDatastoreWalker(this, this.eventHandler, new ImageMosaicURLFeatureConsumer(urlsConsumer));
        } else {
            walker = this.isUseExistingSchema() ? new ImageMosaicDatastoreWalker(this, this.eventHandler, new ImageMosaicFileFeatureConsumer()) : new ImageMosaicDirectoryWalker(this, this.eventHandler);
        }
        return walker;
    }
}

