/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.awt.RenderingHints;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.URLs;

public abstract class DefaultPropertiesCollectorSPI
implements PropertiesCollectorSPI {
    private final String name;
    public static final String REGEX_PREFIX = "regex=";

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultPropertiesCollectorSPI(String name) {
        this.name = name;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    @Override
    public PropertiesCollector create(Object o, List<String> propertyNames) {
        Properties properties;
        URL source = null;
        String property = null;
        if (o instanceof URL) {
            source = (URL)o;
        } else if (o instanceof File) {
            source = URLs.fileToUrl((File)((File)o));
        } else if (o instanceof String) {
            try {
                source = new URL((String)o);
            }
            catch (MalformedURLException e) {
                String value = (String)o;
                if (value.startsWith(REGEX_PREFIX)) {
                    property = value.substring(REGEX_PREFIX.length());
                }
                return null;
            }
        } else {
            return null;
        }
        if (source != null && (properties = CoverageUtilities.loadPropertiesFromURL((URL)source)).containsKey("regex")) {
            property = properties.getProperty("regex");
        }
        if (property != null) {
            return this.createInternal(this, propertyNames, property.trim());
        }
        return null;
    }

    protected abstract PropertiesCollector createInternal(PropertiesCollectorSPI var1, List<String> var2, String var3);
}

