/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.namecollector;

import it.geosolutions.imageio.core.SourceSPIProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollector;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollectorSPI;

public class FileNameRegexNameCollectorSPI
implements CoverageNameCollectorSPI {
    public static String REGEX = "regex";

    @Override
    public CoverageNameCollector create(Object object, Map<String, String> map) {
        String regex = null;
        if (map != null && map.containsKey(REGEX) && (regex = map.get(REGEX)) != null) {
            return new FileNameRegexBasedCoverageNameCollector(regex);
        }
        throw new IllegalArgumentException("FileNameRegexNameCollectorSPI should have a defined REGEX property in the map");
    }

    static class FileNameRegexBasedCoverageNameCollector
    implements CoverageNameCollector {
        private Pattern pattern;

        public FileNameRegexBasedCoverageNameCollector(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getName(GridCoverage2DReader reader, Map<String, String> map) {
            Object source = reader.getSource();
            Utils.SourceGetter sourceGetter = new Utils.SourceGetter(source);
            File file = sourceGetter.getFile();
            String path = null;
            if (file == null) {
                if (!(source instanceof SourceSPIProvider)) throw new IllegalArgumentException("Unable to retrieve a valid source file for the specified reader");
                SourceSPIProvider provider = (SourceSPIProvider)source;
                try {
                    path = provider.getSourceUrl().toString();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Unable to retrieve a valid source for the specified reader");
                }
                int indexOf = path.lastIndexOf("/");
                path = path.substring(indexOf + 1);
            } else {
                path = file.getAbsolutePath();
            }
            String baseName = FilenameUtils.getBaseName((String)path);
            Matcher matcher = this.pattern.matcher(baseName);
            if (!matcher.find()) throw new IllegalArgumentException("Unable to retrieve the coverageName");
            int count = matcher.groupCount();
            Object match = "";
            for (int i = 1; i <= count; ++i) {
                match = (String)match + matcher.group(i);
            }
            return match;
        }
    }
}

