/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.namecollector;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollector;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollectorSPI;

public class ColorSpaceNameCollectorSPI
implements CoverageNameCollectorSPI {
    @Override
    public CoverageNameCollector create(Object object, Map<String, String> properties) {
        return new ColorSpaceBasedNameCollector();
    }

    static class ColorSpaceBasedNameCollector
    implements CoverageNameCollector {
        private static final String GRAY = "GRAY";
        private static final String RGB = "RGB";

        @Override
        public String getName(GridCoverage2DReader reader, Map<String, String> map) {
            String coverageName = null;
            try {
                ImageLayout layout = reader.getImageLayout();
                ColorModel cm = layout.getColorModel(null);
                ColorSpace cs = cm.getColorSpace();
                int type = cs.getType();
                switch (type) {
                    case 6: {
                        coverageName = GRAY;
                        break;
                    }
                    case 5: {
                        coverageName = RGB;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The specified ColorSpace's type is not supported: " + type);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return coverageName;
        }
    }
}

