/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.oracle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.transform.Definition;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.catalog.oracle.FeatureTypeMapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractFeatureTypeMapper
implements FeatureTypeMapper {
    protected Name originalName;
    protected String mappedName;
    protected CoordinateReferenceSystem coordinateReferenceSystem;
    protected List<Definition> definitions;
    protected SimpleFeatureType wrappedFeatureType;
    protected SimpleFeatureType mappedFeatureType;
    protected Map<Name, Definition> definitionsMapping;
    protected SimpleFeatureSource simpleFeatureSource;
    protected int maxLength;

    protected AbstractFeatureTypeMapper(SimpleFeatureType featureType, int maxLength) throws CQLException {
        this.wrappedFeatureType = featureType;
        this.maxLength = maxLength;
        this.originalName = featureType.getName();
        this.mappedName = this.originalName.getLocalPart();
        this.mappedName = this.remap(this.mappedName);
        List attributes = featureType.getAttributeDescriptors();
        this.definitions = new LinkedList<Definition>();
        this.definitionsMapping = new HashMap<Name, Definition>();
        for (AttributeDescriptor attribute : attributes) {
            String originalAttribute = attribute.getLocalName();
            AttributeType type = attribute.getType();
            Class binding = type.getBinding();
            String attributeName = this.remap(originalAttribute);
            Definition definition = new Definition(originalAttribute, ECQL.toExpression((String)attributeName), binding);
            this.definitions.add(definition);
            this.definitionsMapping.put(attribute.getName(), definition);
        }
    }

    @Override
    public Name getName() {
        return this.originalName;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    @Override
    public SimpleFeatureType getMappedFeatureType() {
        return this.mappedFeatureType;
    }

    @Override
    public SimpleFeatureType getWrappedFeatureType() {
        return this.wrappedFeatureType;
    }

    @Override
    public SimpleFeatureSource getSimpleFeatureSource() {
        return this.simpleFeatureSource;
    }

    @Override
    public String remap(String name) {
        return this.remap(name, this.maxLength);
    }

    protected String remap(String name, int maxLength) {
        String mappedName = name;
        mappedName = mappedName.length() >= maxLength ? mappedName.substring(0, maxLength) : mappedName;
        return mappedName;
    }

    public void setSimpleFeatureSource(SimpleFeatureSource simpleFeatureSource) {
        this.simpleFeatureSource = simpleFeatureSource;
    }

    protected void remapFeatureType() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(this.mappedName);
        List descriptors = this.wrappedFeatureType.getAttributeDescriptors();
        for (AttributeDescriptor descriptor : descriptors) {
            Name name = descriptor.getName();
            Definition definition = this.definitionsMapping.get(name);
            AttributeType type = descriptor.getType();
            if (type instanceof GeometryType) {
                this.coordinateReferenceSystem = ((GeometryType)type).getCoordinateReferenceSystem();
                this.remapGeometryAttribute(tb, definition, descriptor, type);
                continue;
            }
            tb.add(definition.getExpression().toString(), definition.getBinding());
        }
        this.mappedFeatureType = tb.buildFeatureType();
    }

    protected void remapGeometryAttribute(SimpleFeatureTypeBuilder tb, Definition definition, AttributeDescriptor descriptor, AttributeType type) {
        tb.add(definition.getExpression().toString(), definition.getBinding(), this.coordinateReferenceSystem);
    }
}

