/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.index;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.SourceSPIProviderFactory;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CogConfiguration;
import org.geotools.gce.imagemosaic.catalog.index.AttributeType;
import org.geotools.gce.imagemosaic.catalog.index.DomainType;
import org.geotools.gce.imagemosaic.catalog.index.DomainsType;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class IndexerUtils {
    public static final String INDEXER_XML = "indexer.xml";
    public static final String INDEXER_PROPERTIES = "indexer.properties";
    private static final Logger LOGGER = Logging.getLogger(IndexerUtils.class);

    public static void setPropertyCollectors(Indexer indexer, String propertyCollectors) {
        Indexer.Collectors collectors = Utils.OBJECT_FACTORY.createIndexerCollectors();
        indexer.setCollectors(collectors);
        List<Indexer.Collectors.Collector> collectorList = collectors.getCollector();
        propertyCollectors = propertyCollectors.trim();
        if (propertyCollectors != null && propertyCollectors.length() > 0) {
            String[] propColls;
            for (String pcDef : propColls = propertyCollectors.split(",")) {
                int roundRPosLast;
                int squareLPos = pcDef.indexOf("[");
                int squareRPos = pcDef.indexOf("]");
                int roundLPos = pcDef.indexOf("(");
                int roundRPos = pcDef.indexOf(")");
                if (roundRPos != (roundRPosLast = pcDef.lastIndexOf(")"))) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundLPos == -1 || roundRPos == -1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundLPos == 0) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundRPos != pcDef.length() - 1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                String spi = null;
                spi = squareLPos != -1 ? pcDef.substring(0, squareLPos) : pcDef.substring(0, roundLPos);
                String config = squareLPos < squareRPos ? pcDef.substring(squareLPos + 1, squareRPos) : "";
                String value = null;
                if (config.length() > 0) {
                    File configFile = new File(IndexerUtils.getParameter("RootMosaicDirectory", indexer), config + ".properties");
                    if (!Utils.checkFileReadable(configFile)) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Unable to access the file for this PropertyCollector: " + configFile.getAbsolutePath());
                        }
                    } else {
                        Properties properties = CoverageUtilities.loadPropertiesFromURL((URL)URLs.fileToUrl((File)configFile));
                        if (properties.containsKey("regex")) {
                            value = properties.getProperty("regex");
                        }
                    }
                }
                String[] propertyNames = pcDef.substring(roundLPos + 1, roundRPos).split(",");
                Indexer.Collectors.Collector collector = Utils.OBJECT_FACTORY.createIndexerCollectorsCollector();
                collector.setSpi(spi);
                collector.setMapped(propertyNames[0]);
                collector.setValue(value);
                collectorList.add(collector);
            }
        }
    }

    public static Indexer.Coverages.Coverage getCoverage(Indexer indexer, String name) {
        Indexer.Coverages coverages = indexer.getCoverages();
        if (coverages != null) {
            List<Indexer.Coverages.Coverage> coverageList = coverages.getCoverage();
            for (Indexer.Coverages.Coverage coverage : coverageList) {
                String coverageName = coverage.getName();
                if (coverageName == null || !coverageName.equalsIgnoreCase(name)) continue;
                return coverage;
            }
        }
        return null;
    }

    public static String refineParameterValue(String parameterName, String parameterValue) {
        if (parameterName.equalsIgnoreCase("RootMosaicDirectory")) {
            Utilities.ensureNonNull((String)"parameterValue", (Object)parameterValue);
            String testingDirectory = parameterValue;
            parameterValue = Utils.checkDirectory(testingDirectory, false);
        }
        return parameterValue;
    }

    public static void setAttributes(DomainType domain, String values) {
        if (values.contains(";")) {
            String[] properties;
            for (String prop : properties = values.split(";")) {
                IndexerUtils.addAttribute(domain, prop);
            }
        } else {
            IndexerUtils.addAttribute(domain, values);
        }
    }

    private static void addAttribute(DomainType domain, String attributeValue) {
        AttributeType attribute = Utils.OBJECT_FACTORY.createAttributeType();
        attribute.setAttribute(attributeValue);
        List<AttributeType> listAttributes = domain.getAttributes();
        listAttributes.add(attribute);
    }

    public static void setParam(List<ParametersType.Parameter> parameters, String parameterName, String parameterValue) {
        ParametersType.Parameter param = null;
        for (ParametersType.Parameter parameter : parameters) {
            if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
            param = parameter;
            break;
        }
        if (param == null) {
            param = Utils.OBJECT_FACTORY.createParametersTypeParameter();
            parameters.add(param);
        }
        param.setName(parameterName);
        param.setValue(IndexerUtils.refineParameterValue(parameterName, parameterValue));
    }

    public static void setParam(List<ParametersType.Parameter> parameters, Properties props, String propName) {
        IndexerUtils.setParam(parameters, propName, props.getProperty(propName));
    }

    public static boolean getParameterAsBoolean(String parameterName, Indexer indexer) {
        String value = IndexerUtils.getParameter(parameterName, indexer);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static Integer getParameterAsInteger(String parameterName, Indexer indexer) {
        String value = IndexerUtils.getParameter(parameterName, indexer);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public static <T extends Enum> T getParameterAsEnum(String parameterName, Class<T> enumClass, Indexer indexer) {
        String value = IndexerUtils.getParameter(parameterName, indexer);
        if (value != null) {
            return Enum.valueOf(enumClass, value);
        }
        return null;
    }

    public static String getParam(ParametersType params, String parameterName) {
        List<ParametersType.Parameter> parameters = null;
        if (params != null) {
            parameters = params.getParameter();
            for (ParametersType.Parameter param : parameters) {
                if (!param.getName().equalsIgnoreCase(parameterName)) continue;
                return param.getValue();
            }
        }
        return null;
    }

    public static String getParameter(String parameterName, Indexer indexer) {
        ParametersType params = indexer.getParameters();
        return IndexerUtils.getParam(params, parameterName);
    }

    public static String getParameter(String parameterName, File indexerFile) {
        if (indexerFile != null && indexerFile.exists()) {
            try {
                String value;
                Indexer indexerInstance = Utils.unmarshal(indexerFile);
                if (indexerInstance != null && (value = IndexerUtils.getParameter(parameterName, indexerInstance)) != null) {
                    return value;
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void parseAdditionalDomains(String attributes, List<DomainType> domainList) {
        String[] domainsAttributes;
        for (String domainAttributes : domainsAttributes = attributes.split(",")) {
            String domainName;
            DomainType domain = Utils.OBJECT_FACTORY.createDomainType();
            String domainAttribs = domainName = domainAttributes.trim();
            if (domainAttributes.contains("(") && domainAttributes.contains(")")) {
                domainName = domainName.substring(0, domainName.indexOf("(")).trim();
                domainAttribs = domainAttribs.substring(domainAttribs.indexOf("(")).replace("(", "").replace(")", "");
            }
            domain.setName(domainName);
            IndexerUtils.setAttributes(domain, domainAttribs);
            domainList.add(domain);
        }
    }

    private static String getAttributesAsString(DomainType domain, boolean domainPrefix) {
        String currentDomainName = domain.getName();
        List<AttributeType> listAttributes = domain.getAttributes();
        if (!listAttributes.isEmpty()) {
            Object attribs = null;
            if (listAttributes.size() == 1) {
                attribs = listAttributes.get(0).getAttribute().trim();
            } else {
                String attr0 = listAttributes.get(0).getAttribute().trim();
                String attr1 = listAttributes.get(1).getAttribute().trim();
                attribs = attr0 + ";" + attr1;
            }
            if (domainPrefix) {
                return currentDomainName + "(" + (String)attribs + ")";
            }
            return attribs;
        }
        return null;
    }

    public static DomainType getDomain(DomainType domain, DomainsType refDomains) {
        String domainRef;
        String currentDomainName = domain.getName();
        if (currentDomainName == null && (domainRef = domain.getRef()) != null && refDomains != null) {
            for (DomainType refDomain : refDomains.getDomain()) {
                if (!refDomain.getName().equalsIgnoreCase(domainRef)) continue;
                currentDomainName = domainRef;
                return refDomain;
            }
        }
        return domain;
    }

    public static String getAttribute(String coverageName, String domainName, Indexer indexer) {
        if (indexer != null) {
            List<Indexer.Coverages.Coverage> coverageList;
            Indexer.Coverages coverages = indexer.getCoverages();
            DomainsType refDomains = indexer.getDomains();
            if (coverages != null && (coverageList = coverages.getCoverage()) != null && !coverageList.isEmpty()) {
                for (Indexer.Coverages.Coverage coverage : coverageList) {
                    List<DomainType> domainList;
                    DomainsType domains;
                    String currentCoverageName = coverage.getName();
                    if (currentCoverageName != null && !currentCoverageName.equalsIgnoreCase(coverageName) || (domains = coverage.getDomains()) == null || (domainList = domains.getDomain()) == null) continue;
                    if (!domainName.equalsIgnoreCase("ADDITIONAL")) {
                        for (DomainType domain : domainList) {
                            DomainType currentDomain = IndexerUtils.getDomain(domain, refDomains);
                            String currentDomainName = currentDomain.getName();
                            if (currentDomainName == null || !currentDomainName.equalsIgnoreCase(domainName)) continue;
                            return IndexerUtils.getAttributesAsString(currentDomain, false);
                        }
                        continue;
                    }
                    return IndexerUtils.getAdditionalDomainAttributes(refDomains, domainList);
                }
            }
        }
        return null;
    }

    private static String getAdditionalDomainAttributes(DomainsType refDomains, List<DomainType> domainList) {
        StringBuilder additionalDomainAttributes = new StringBuilder();
        for (DomainType domain : domainList) {
            DomainType currentDomain = IndexerUtils.getDomain(domain, refDomains);
            String domName = currentDomain.getName();
            if (domName.equalsIgnoreCase("TIME") || domName.equalsIgnoreCase("ELEVATION")) continue;
            additionalDomainAttributes.append(IndexerUtils.getAttributesAsString(currentDomain, true));
            additionalDomainAttributes.append(",");
        }
        String attribs = additionalDomainAttributes.toString();
        if (attribs != null && attribs.length() > 0) {
            attribs = attribs.substring(0, attribs.length() - 1);
        }
        if (attribs.length() > 0) {
            return attribs;
        }
        return null;
    }

    public static SchemaType getSchema(Indexer indexer, Indexer.Coverages.Coverage coverage) {
        Utilities.ensureNonNull((String)"coverage", (Object)coverage);
        SchemaType schema = coverage.getSchema();
        if (schema != null) {
            String schemaRef = schema.getRef();
            if (schemaRef != null && (schema = IndexerUtils.getSchemaRef(indexer, schemaRef)) != null) {
                return schema;
            }
            return schema;
        }
        return null;
    }

    private static SchemaType getSchemaRef(Indexer indexer, String schemaRef) {
        Utilities.ensureNonNull((String)"schemaRef", (Object)schemaRef);
        Utilities.ensureNonNull((String)"indexer", (Object)indexer);
        SchemasType schemas = indexer.getSchemas();
        if (schemas != null) {
            List<SchemaType> schemaList = schemas.getSchema();
            for (SchemaType schema : schemaList) {
                String schemaName = schema.getName();
                if (schemaName == null || !schemaName.equalsIgnoreCase(schemaRef)) continue;
                return schema;
            }
        }
        return null;
    }

    public static Indexer createDefaultIndexer() {
        Indexer defaultIndexer = Utils.OBJECT_FACTORY.createIndexer();
        ParametersType parameters = Utils.OBJECT_FACTORY.createParametersType();
        List<ParametersType.Parameter> parameterList = parameters.getParameter();
        defaultIndexer.setParameters(parameters);
        IndexerUtils.setParam(parameterList, "LocationAttribute", "location");
        IndexerUtils.setParam(parameterList, "Wildcard", "*.*");
        IndexerUtils.setParam(parameterList, "FootprintManagement", Boolean.toString(true));
        IndexerUtils.setParam(parameterList, "AbsolutePath", Boolean.toString(false));
        IndexerUtils.setParam(parameterList, "Recursive", Boolean.toString(true));
        IndexerUtils.setParam(parameterList, "Name", "index");
        return defaultIndexer;
    }

    public static Indexer initializeIndexer(ParametersType params, File parent) {
        File indexerFile = new File(parent, INDEXER_XML);
        Indexer indexer = null;
        if (Utils.checkFileReadable(indexerFile)) {
            try {
                indexer = Utils.unmarshal(indexerFile);
                if (indexer != null) {
                    IndexerUtils.copyDefaultParams(params, indexer);
                }
            }
            catch (JAXBException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            indexerFile = new File(parent, INDEXER_PROPERTIES);
            if (Utils.checkFileReadable(indexerFile)) {
                Properties props = CoverageUtilities.loadPropertiesFromURL((URL)URLs.fileToUrl((File)indexerFile));
                indexer = IndexerUtils.createIndexer(props, params);
            }
        }
        if (indexer != null) {
            indexer.setIndexerFile(indexerFile);
        }
        return indexer;
    }

    private static void copyDefaultParams(ParametersType params, Indexer indexer) {
        List<ParametersType.Parameter> defaultParamList;
        if (params != null && (defaultParamList = params.getParameter()) != null && !defaultParamList.isEmpty()) {
            ParametersType parameters = indexer.getParameters();
            if (parameters == null) {
                parameters = Utils.OBJECT_FACTORY.createParametersType();
                indexer.setParameters(parameters);
            }
            List<ParametersType.Parameter> parameterList = parameters.getParameter();
            for (ParametersType.Parameter defaultParameter : defaultParamList) {
                String defaultParameterName = defaultParameter.getName();
                if (IndexerUtils.getParameter(defaultParameterName, indexer) != null) continue;
                IndexerUtils.setParam(parameterList, defaultParameterName, defaultParameter.getValue());
            }
        }
    }

    private static Indexer createIndexer(Properties props, ParametersType params) {
        Indexer indexer = Utils.OBJECT_FACTORY.createIndexer();
        indexer.setParameters(params != null ? params : Utils.OBJECT_FACTORY.createParametersType());
        Indexer.Coverages coverages = Utils.OBJECT_FACTORY.createIndexerCoverages();
        indexer.setCoverages(coverages);
        List<Indexer.Coverages.Coverage> coverageList = coverages.getCoverage();
        Indexer.Coverages.Coverage coverage = Utils.OBJECT_FACTORY.createIndexerCoveragesCoverage();
        coverageList.add(coverage);
        List<ParametersType.Parameter> parameters = indexer.getParameters().getParameter();
        if (props.containsKey("Name")) {
            IndexerUtils.setParam(parameters, props, "Name");
            coverage.setName(props.getProperty("Name"));
        }
        if (props.containsKey("TypeName")) {
            IndexerUtils.setParam(parameters, props, "TypeName");
            coverage.setName(props.getProperty("TypeName"));
        }
        IndexerUtils.addProperty("AbsolutePath", props, parameters);
        IndexerUtils.addProperty("PathType", props, parameters);
        IndexerUtils.addProperty("Recursive", props, parameters);
        if (props.containsKey("Cog")) {
            IndexerUtils.setParam(parameters, props, "Cog");
            if (props.containsKey("CogRangeReader")) {
                IndexerUtils.setParam(parameters, props, "CogRangeReader");
            } else {
                IndexerUtils.setParam(parameters, "CogRangeReader", "it.geosolutions.imageioimpl.plugins.cog.HttpRangeReader");
            }
            IndexerUtils.addProperty("CogUseCache", props, parameters);
            IndexerUtils.addProperty("CogPassword", props, parameters);
            IndexerUtils.addProperty("CogUser", props, parameters);
        }
        IndexerUtils.addProperty("Wildcard", props, parameters);
        IndexerUtils.addProperty("GranuleAcceptors", props, parameters);
        IndexerUtils.addProperty("GranuleHandler", props, parameters);
        IndexerUtils.addProperty("CoverageNameCollectorSPI", props, parameters);
        if (props.containsKey("Schema")) {
            SchemasType schemas = Utils.OBJECT_FACTORY.createSchemasType();
            SchemaType schema = Utils.OBJECT_FACTORY.createSchemaType();
            indexer.setSchemas(schemas);
            schemas.getSchema().add(schema);
            schema.setAttributes(props.getProperty("Schema"));
            schema.setName(IndexerUtils.getParameter("Name", indexer));
        }
        IndexerUtils.addDomain(props, coverage, "TimeAttribute", "TIME");
        IndexerUtils.addDomain(props, coverage, "ElevationAttribute", "ELEVATION");
        IndexerUtils.addDomain(props, coverage, "CrsAttribute", "CRS");
        IndexerUtils.addDomain(props, coverage, "ResolutionAttribute", "RESOLUTION");
        IndexerUtils.addDomain(props, coverage, "ResolutionXAttribute", "RESOLUTION_X");
        IndexerUtils.addDomain(props, coverage, "ResolutionYAttribute", "RESOLUTION_Y");
        IndexerUtils.addProperty("TimeAttribute", props, parameters);
        IndexerUtils.addProperty("ElevationAttribute", props, parameters);
        IndexerUtils.addProperty("CrsAttribute", props, parameters);
        IndexerUtils.addProperty("ResolutionAttribute", props, parameters);
        IndexerUtils.addProperty("ResolutionXAttribute", props, parameters);
        IndexerUtils.addProperty("ResolutionYAttribute", props, parameters);
        IndexerUtils.addProperty("PropertySelection", props, parameters);
        if (props.containsKey("AdditionalDomainAttributes")) {
            DomainsType domains = coverage.getDomains();
            if (domains == null) {
                domains = Utils.OBJECT_FACTORY.createDomainsType();
                coverage.setDomains(domains);
            }
            List<DomainType> domainList = domains.getDomain();
            String attributes = props.getProperty("AdditionalDomainAttributes");
            IndexerUtils.parseAdditionalDomains(attributes, domainList);
        }
        IndexerUtils.addProperty("Envelope2D", props, parameters);
        IndexerUtils.addProperty("ResolutionLevels", props, parameters);
        if (props.containsKey("PropertyCollectors")) {
            IndexerUtils.setPropertyCollectors(indexer, props.getProperty("PropertyCollectors"));
        }
        IndexerUtils.addProperty("Caching", props, parameters);
        IndexerUtils.addProperty("RootMosaicDirectory", props, parameters);
        IndexerUtils.addProperty("IndexingDirectories", props, parameters);
        IndexerUtils.addProperty("AuxiliaryFile", props, parameters);
        IndexerUtils.addProperty("AuxiliaryDatastoreFile", props, parameters);
        IndexerUtils.addProperty("CanBeEmpty", props, parameters);
        IndexerUtils.addProperty("WrapStore", props, parameters);
        IndexerUtils.addProperty("UseExistingSchema", props, parameters);
        IndexerUtils.addProperty("CheckAuxiliaryMetadata", props, parameters);
        IndexerUtils.addProperty("GranuleCollectorFactory", props, parameters);
        IndexerUtils.addProperty("HeterogeneousCRS", props, parameters);
        IndexerUtils.addProperty("CrsAttribute", props, parameters);
        IndexerUtils.addProperty("MosaicCRS", props, parameters);
        IndexerUtils.addProperty("NoData", props, parameters);
        IndexerUtils.addProperty("SkipExternalOverviews", props, parameters);
        IndexerUtils.addProperty("LocationAttribute", props, parameters);
        IndexerUtils.addProperty("MaxInitTiles", props, parameters);
        IndexerUtils.addProperty("QueryCacheMaxAge", props, parameters);
        IndexerUtils.addProperty("QueryCacheMaxFeatures", props, parameters);
        return indexer;
    }

    private static void addProperty(String propertyName, Properties props, List<ParametersType.Parameter> parameters) {
        if (props.containsKey(propertyName)) {
            IndexerUtils.setParam(parameters, props, propertyName);
        }
    }

    public static SourceSPIProviderFactory getSourceSPIProviderFactory(Indexer indexer) {
        boolean cog = IndexerUtils.getParameterAsBoolean("Cog", indexer);
        if (cog) {
            return new CogConfiguration(indexer);
        }
        return null;
    }

    private static void addDomain(Properties props, Indexer.Coverages.Coverage coverage, String attributeName, String domainName) {
        if (props.containsKey(attributeName)) {
            DomainsType domains = coverage.getDomains();
            if (domains == null) {
                domains = Utils.OBJECT_FACTORY.createDomainsType();
                coverage.setDomains(domains);
            }
            List<DomainType> domainList = domains.getDomain();
            DomainType domain = Utils.OBJECT_FACTORY.createDomainType();
            domain.setName(domainName.toLowerCase());
            IndexerUtils.setAttributes(domain, props.getProperty(attributeName));
            domainList.add(domain);
        }
    }

    public static void setParam(Indexer indexer, String paramName, String paramValue) {
        IndexerUtils.setParam(indexer.getParameters().getParameter(), paramName, paramValue);
    }
}

