/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.util.logging.Logging;

public class SupportFilesCollector {
    static final Logger LOGGER = Logging.getLogger(SupportFilesCollector.class);
    private static final String PRJ = ".PRJ";
    private static final String PRJ_ = ".prj";
    private static final String TFW = ".TFW";
    private static final String TFW_ = ".tfw";
    private static final String WLD = ".WLD";
    private static final String WLD_ = ".wld";
    private static final String JGW = ".JGW";
    private static final String JGW_ = ".jgw";
    private static final String PGW = ".PGW";
    private static final String PGW_ = ".pgw";
    private static final String MSK = ".TIF.MSK";
    private static final String MSK_ = ".tif.msk";
    private static final String OVR = ".TIF.OVR";
    private static final String OVR_ = ".tif.ovr";
    static final Map<String, SupportFilesCollector> COLLECTORS = new HashMap<String, SupportFilesCollector>();
    private String[] supportingExtensions;

    public static SupportFilesCollector getCollectorFor(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        return COLLECTORS.get(extension.toUpperCase());
    }

    public SupportFilesCollector(String[] supportingExtensions) {
        this.supportingExtensions = supportingExtensions;
    }

    public List<File> getSupportFiles(String filePath) {
        LinkedHashSet<File> supportFiles = null;
        String parent = FilenameUtils.getFullPath((String)filePath);
        String mainName = FilenameUtils.getName((String)filePath);
        String baseName = FilenameUtils.removeExtension((String)mainName);
        for (String extension : this.supportingExtensions) {
            String newFilePath = parent + baseName + extension;
            File file = new File(newFilePath);
            if (!file.exists()) continue;
            if (supportFiles == null) {
                supportFiles = new LinkedHashSet<File>();
            }
            try {
                supportFiles.add(file.getCanonicalFile());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to canonicalize file, will add as is: " + String.valueOf(file));
                supportFiles.add(file);
            }
        }
        return supportFiles == null ? null : new ArrayList(supportFiles);
    }

    static {
        String[] PNG_ = new String[]{WLD_, PRJ_, PGW_, WLD, PGW, PRJ};
        String[] JPG_ = new String[]{WLD_, PRJ_, JGW_, WLD, JGW, PRJ};
        String[] GIF_ = new String[]{WLD_, PRJ_, WLD, PRJ};
        String[] TIF_ = new String[]{TFW_, PRJ_, WLD_, OVR_, MSK_, TFW, WLD, PRJ, OVR, MSK};
        SupportFilesCollector PNG = new SupportFilesCollector(PNG_);
        SupportFilesCollector JPG = new SupportFilesCollector(JPG_);
        SupportFilesCollector TIF = new SupportFilesCollector(TIF_);
        SupportFilesCollector GIF = new SupportFilesCollector(GIF_);
        COLLECTORS.put("PNG", PNG);
        COLLECTORS.put("JPG", JPG);
        COLLECTORS.put("JPEG", JPG);
        COLLECTORS.put("GIF", GIF);
        COLLECTORS.put("TIF", TIF);
        COLLECTORS.put("TIFF", TIF);
    }
}

