/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.ExcessGranulePolicy;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicQueryBuilder;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.SpatialRequestHelper;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class RasterLayerRequest {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerRequest.class);
    private static final int DEFAULT_PADDING = 10;
    private ReadType readType = (Boolean)AbstractGridFormat.USE_JAI_IMAGEREAD.getDefaultValue() != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
    SpatialRequestHelper spatialRequestHelper;
    private DecimationPolicy decimationPolicy;
    private OverviewPolicy overviewPolicy;
    private Interpolation interpolation;
    private FootprintBehavior footprintBehavior = FootprintBehavior.None;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold;
    private double[] virtualNativeResolution;
    private boolean heterogeneousGranules = false;
    private boolean heterogeneousCRS = false;
    private boolean useAlternativeCRS = false;
    RasterManager rasterManager;
    private Color inputTransparentColor = (Color)AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
    private boolean blend = (Boolean)ImageMosaicFormat.FADING.getDefaultValue();
    private MergeBehavior mergeBehavior = MergeBehavior.getDefault();
    private Color outputTransparentColor = (Color)ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
    private int maximumNumberOfGranules = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    private double[] backgroundValues;
    private Dimension tileDimensions;
    private boolean multithreadingAllowed;
    private List<?> requestedTimes;
    private List<?> elevation;
    protected Filter filter;
    private boolean accurateResolution;
    private Geometry geometryMask;
    private double maskingBufferPixels;
    private boolean setRoiProperty;
    private final Map<String, List> requestedAdditionalDomains = new HashMap<String, List>();
    private int[] bands;
    private String sortClause;
    private ExcessGranulePolicy excessGranuleRemovalPolicy;
    private boolean rescalingEnabled = true;
    private GeneralParameterValue[] params;
    private Envelope2D requestedBounds;
    private GridGeometry2D requestedGridGeometry;

    public List<?> getElevation() {
        return this.elevation;
    }

    public String getSortClause() {
        return this.sortClause;
    }

    public GeneralParameterValue[] getParams() {
        return this.params;
    }

    public void setSortClause(String sortClause) {
        this.sortClause = sortClause;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Envelope2D getRequestedBounds() {
        return this.requestedBounds;
    }

    public List<?> getRequestedTimes() {
        return this.requestedTimes;
    }

    public boolean isMultithreadingAllowed() {
        return this.multithreadingAllowed;
    }

    public DecimationPolicy getDecimationPolicy() {
        return this.decimationPolicy;
    }

    public boolean isHeterogeneousGranules() {
        return this.heterogeneousGranules;
    }

    public boolean isUseAlternativeCRS() {
        return this.useAlternativeCRS;
    }

    public ExcessGranulePolicy getExcessGranuleRemovalPolicy() {
        return this.excessGranuleRemovalPolicy;
    }

    public void setExcessGranuleRemovalPolicy(ExcessGranulePolicy policy) {
        this.excessGranuleRemovalPolicy = policy;
    }

    public void setHeterogeneousGranules(boolean heterogeneousGranules) {
        this.heterogeneousGranules = heterogeneousGranules;
    }

    public RasterManager getRasterManager() {
        return this.rasterManager;
    }

    public Map<String, List> getRequestedAdditionalDomains() {
        return new HashMap<String, List>(this.requestedAdditionalDomains);
    }

    public RasterLayerRequest(GeneralParameterValue[] params, RasterManager rasterManager) throws IOException {
        this.params = params;
        this.rasterManager = rasterManager;
        this.heterogeneousGranules = rasterManager.heterogeneousGranules;
        this.heterogeneousCRS = rasterManager.heterogeneousCRS;
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        coverageProperties.setBBox(rasterManager.spatialDomainManager.coverageBBox);
        coverageProperties.setRasterArea(rasterManager.spatialDomainManager.coverageRasterArea);
        coverageProperties.setFullResolution(rasterManager.spatialDomainManager.coverageFullResolution);
        coverageProperties.setGridToWorld2D(rasterManager.spatialDomainManager.coverageGridToWorld2D);
        coverageProperties.setCrs2D(rasterManager.spatialDomainManager.coverageCRS2D);
        coverageProperties.setGeographicBBox(rasterManager.spatialDomainManager.coverageGeographicBBox);
        coverageProperties.setGeographicCRS2D(rasterManager.spatialDomainManager.coverageGeographicCRS2D);
        this.spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        this.setDefaultParameterValues();
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                if (!(gParam instanceof ParameterValue)) continue;
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                this.extractParameter(param, (Identifier)name);
            }
        }
        this.checkAlternativeCRSIsSupported();
        this.computeRequestedGridGeometry();
        coverageProperties.setBBox(this.computeCoverageBoundingBox(rasterManager));
        this.checkReadType();
        this.spatialRequestHelper.setAccurateResolution(this.accurateResolution);
        this.spatialRequestHelper.compute();
    }

    private void checkAlternativeCRSIsSupported() throws IOException {
        if (this.heterogeneousCRS && this.useAlternativeCRS && this.requestedBounds != null) {
            CoordinateReferenceSystem requestedCRS = this.requestedBounds.getCoordinateReferenceSystem();
            Integer requestedEpsgCode = null;
            try {
                requestedEpsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)requestedCRS, (boolean)false);
            }
            catch (FactoryException e) {
                throw new IOException("Exception occurred while looking for an epsgCode on the provided crs: " + String.valueOf(requestedCRS), e);
            }
            if (!CRS.equalsIgnoreMetadata((Object)requestedCRS, (Object)this.spatialRequestHelper.getReferenceCRS(false)) && this.rasterManager.hasAlternativeCRS(requestedEpsgCode)) {
                this.spatialRequestHelper.setSupportingAlternativeCRSOutput(true);
                SpatialRequestHelper.CoverageProperties alternativeProperties = new SpatialRequestHelper.CoverageProperties();
                alternativeProperties.setCrs2D(requestedCRS);
                alternativeProperties.setBBox(ReferencedEnvelope.reference((Envelope)this.requestedBounds));
                this.spatialRequestHelper.setAlternativeProperties(alternativeProperties);
            } else {
                this.useAlternativeCRS = false;
            }
        }
    }

    private void computeRequestedGridGeometry() throws IOException {
        if (this.requestedGridGeometry != null) {
            if (this.heterogeneousCRS && !this.useAlternativeCRS) {
                GridEnvelope2D paddedRange = new GridEnvelope2D((Rectangle)this.requestedGridGeometry.getGridRange2D());
                paddedRange.setBounds(paddedRange.x - 10, paddedRange.y - 10, paddedRange.width + 20, paddedRange.height + 20);
                GridGeometry2D padded = new GridGeometry2D((GridEnvelope)paddedRange, this.requestedGridGeometry.getGridToCRS(), this.requestedGridGeometry.getCoordinateReferenceSystem());
                this.spatialRequestHelper.setRequestedGridGeometry(padded.toCanonical());
            } else {
                this.spatialRequestHelper.setRequestedGridGeometry(this.requestedGridGeometry.toCanonical());
            }
        }
    }

    protected ReferencedEnvelope computeCoverageBoundingBox(RasterManager rasterManager) throws IOException {
        try {
            SimpleFeatureCollection features;
            ReferencedEnvelope envelope;
            ReferencedEnvelope queryBounds = null;
            if (this.requestedBounds != null) {
                try {
                    ReferencedEnvelope re = ReferencedEnvelope.reference((Envelope)this.requestedBounds);
                    queryBounds = re.transform(rasterManager.spatialDomainManager.coverageCRS2D, true);
                }
                catch (FactoryException | TransformException e) {
                    LOGGER.log(Level.FINE, "Failed to reproject requested envelope in native, skipping spatial filter in output bounds computation", e);
                }
            }
            MosaicQueryBuilder builder = new MosaicQueryBuilder(this, queryBounds);
            Query query = builder.build();
            query.setSortBy(null);
            GranuleSource granules = rasterManager.getGranuleSource(true, null);
            GeometryDescriptor gd = granules.getSchema().getGeometryDescriptor();
            if (gd != null) {
                query.setPropertyNames(new String[]{gd.getLocalName()});
            }
            if ((envelope = DataUtilities.bounds((FeatureCollection)(features = granules.getGranules(query)))) != null && !envelope.isEmpty()) {
                return envelope;
            }
        }
        catch (FactoryException | TransformException e) {
            throw new IOException(e);
        }
        return rasterManager.spatialDomainManager.coverageBBox;
    }

    private void setDefaultParameterValues() {
        ParameterValueGroup readParams = this.rasterManager.parentReader.getFormat().getReadParameters();
        if (readParams == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No default values for the read parameters!");
            }
            return;
        }
        List parametersDescriptors = readParams.getDescriptor().descriptors();
        for (GeneralParameterDescriptor descriptor : parametersDescriptors) {
            Object value;
            ReferenceIdentifier name;
            block25: {
                String[] tilesSize;
                String suggestedTileSize;
                if (!(descriptor instanceof ParameterDescriptor)) continue;
                ParameterDescriptor desc = (ParameterDescriptor)descriptor;
                name = desc.getName();
                value = desc.getDefaultValue();
                if (descriptor.getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                    if (value == null) continue;
                    GridGeometry2D gg = (GridGeometry2D)value;
                    this.spatialRequestHelper.setRequestedGridGeometry(gg);
                    continue;
                }
                if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                    if (value == null) continue;
                    this.readType = (Boolean)value != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                    continue;
                }
                if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                    if (value == null) continue;
                    this.overviewPolicy = (OverviewPolicy)value;
                    continue;
                }
                if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                    if (value == null) continue;
                    this.decimationPolicy = (DecimationPolicy)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                    if (value == null) continue;
                    this.interpolation = (Interpolation)value;
                    continue;
                }
                if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                    if (value == null) continue;
                    this.inputTransparentColor = (Color)value;
                    this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                    continue;
                }
                if (name.equals(ImageMosaicFormat.FADING.getName())) {
                    if (value == null) continue;
                    this.blend = (Boolean)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                    if (value == null) continue;
                    this.outputTransparentColor = (Color)value;
                    this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                    continue;
                }
                if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                    if (value == null) continue;
                    this.backgroundValues = (double[])value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                    if (value == null) continue;
                    this.maximumNumberOfGranules = (Integer)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                    if (value == null) continue;
                    this.defaultArtifactsFilterThreshold = (Integer)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                    if (value == null) continue;
                    this.artifactsFilterPTileThreshold = (Double)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.VIRTUAL_NATIVE_RESOLUTION.getName())) {
                    if (value == null) continue;
                    this.virtualNativeResolution = (double[])value;
                    return;
                }
                if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                    if (value == null) continue;
                    this.multithreadingAllowed = (Boolean)value;
                    continue;
                }
                if (name.equals(AbstractGridFormat.FOOTPRINT_BEHAVIOR.getName())) {
                    if (value == null) continue;
                    this.footprintBehavior = FootprintBehavior.valueOf((String)((String)value));
                    continue;
                }
                if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)value) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                    try {
                        int tileWidth = Integer.valueOf(tilesSize[0].trim());
                        int tileHeight = Integer.valueOf(tilesSize[1].trim());
                        this.tileDimensions = new Dimension(tileWidth, tileHeight);
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block25;
                        LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                    }
                }
            }
            if (name.equals(ImageMosaicFormat.ACCURATE_RESOLUTION.getName())) {
                if (value == null) continue;
                this.accurateResolution = (Boolean)value;
                return;
            }
            if (name.equals(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL.getName())) {
                if (value == null) continue;
                this.excessGranuleRemovalPolicy = (ExcessGranulePolicy)((Object)value);
                return;
            }
            if (name.equals(ImageMosaicFormat.GEOMETRY_MASK.getName())) {
                if (value == null) continue;
                this.geometryMask = (Geometry)value;
                return;
            }
            if (name.equals(ImageMosaicFormat.MASKING_BUFFER_PIXELS.getName())) {
                if (value == null) continue;
                this.maskingBufferPixels = ((Float)value).floatValue();
                continue;
            }
            if (!name.equals(ImageMosaicFormat.SET_ROI_PROPERTY.getName()) || value == null) continue;
            this.setRoiProperty = (Boolean)value;
        }
    }

    private void extractParameter(ParameterValue<?> param, Identifier name) throws IOException {
        Object value;
        Object value2;
        block64: {
            String[] tilesSize;
            String suggestedTileSize;
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                Object value3 = param.getValue();
                if (value3 == null) {
                    return;
                }
                this.requestedGridGeometry = (GridGeometry2D)value3;
                this.requestedBounds = this.requestedGridGeometry.getEnvelope2D();
                return;
            }
            if (name.equals(ImageMosaicFormat.OUTPUT_TO_ALTERNATIVE_CRS.getName())) {
                Object value4 = param.getValue();
                if (value4 == null) {
                    return;
                }
                this.useAlternativeCRS = (Boolean)value4;
                return;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                Object value5 = param.getValue();
                if (value5 == null) {
                    return;
                }
                this.readType = param.booleanValue() ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                return;
            }
            if (name.equals(ImageMosaicFormat.SORT_BY.getName())) {
                Object value6 = param.getValue();
                if (value6 == null) {
                    return;
                }
                this.sortClause = param.stringValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.MERGE_BEHAVIOR.getName())) {
                Object value7 = param.getValue();
                if (value7 == null) {
                    return;
                }
                this.mergeBehavior = MergeBehavior.valueOf(param.stringValue().toUpperCase());
                return;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                Object value8 = param.getValue();
                if (value8 == null) {
                    return;
                }
                this.overviewPolicy = (OverviewPolicy)value8;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Requested OverviewPolicy: " + String.valueOf(this.overviewPolicy));
                }
                return;
            }
            if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                Object value9 = param.getValue();
                if (value9 == null) {
                    return;
                }
                this.decimationPolicy = (DecimationPolicy)value9;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Requested DecimationPolicy: " + String.valueOf(this.decimationPolicy));
                }
                return;
            }
            if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                Object value10 = param.getValue();
                if (value10 == null) {
                    return;
                }
                this.interpolation = (Interpolation)value10;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Requested interpolation: " + String.valueOf(this.interpolation));
                }
                return;
            }
            if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                Object value11 = param.getValue();
                if (value11 == null) {
                    return;
                }
                this.inputTransparentColor = (Color)value11;
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.FADING.getName())) {
                Object value12 = param.getValue();
                if (value12 == null) {
                    return;
                }
                this.blend = (Boolean)value12;
                return;
            }
            if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                Object value13 = param.getValue();
                if (value13 == null) {
                    return;
                }
                this.outputTransparentColor = (Color)value13;
                this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                Object value14 = param.getValue();
                if (value14 == null) {
                    return;
                }
                this.backgroundValues = (double[])value14;
                return;
            }
            if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                Object value15 = param.getValue();
                if (value15 == null) {
                    return;
                }
                this.maximumNumberOfGranules = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                Object value16 = param.getValue();
                if (value16 == null) {
                    return;
                }
                this.defaultArtifactsFilterThreshold = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                Object value17 = param.getValue();
                if (value17 == null) {
                    return;
                }
                this.artifactsFilterPTileThreshold = param.doubleValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.VIRTUAL_NATIVE_RESOLUTION.getName())) {
                Object value18 = param.getValue();
                if (value18 == null) {
                    return;
                }
                this.virtualNativeResolution = (double[])value18;
                return;
            }
            if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                Object value19 = param.getValue();
                if (value19 == null) {
                    return;
                }
                this.multithreadingAllowed = (Boolean)value19;
                return;
            }
            if (name.equals(AbstractGridFormat.FOOTPRINT_BEHAVIOR.getName())) {
                Object value20 = param.getValue();
                if (value20 == null) {
                    return;
                }
                this.footprintBehavior = FootprintBehavior.valueOf((String)((String)value20));
                return;
            }
            if (name.equals(ImageMosaicFormat.ACCURATE_RESOLUTION.getName())) {
                Object value21 = param.getValue();
                if (value21 == null) {
                    return;
                }
                this.accurateResolution = (Boolean)value21;
                return;
            }
            if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)param.getValue()) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                try {
                    int tileWidth = Integer.valueOf(tilesSize[0].trim());
                    int tileHeight = Integer.valueOf(tilesSize[1].trim());
                    this.tileDimensions = new Dimension(tileWidth, tileHeight);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block64;
                    LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                }
            }
        }
        if (name.equals(ImageMosaicFormat.TIME.getName())) {
            value2 = param.getValue();
            if (value2 == null) {
                return;
            }
            List dates = (List)value2;
            if (dates == null || dates.isEmpty()) {
                return;
            }
            this.requestedTimes = dates;
            return;
        }
        if (name.equals(ImageMosaicFormat.ELEVATION.getName())) {
            value2 = param.getValue();
            if (value2 == null) {
                return;
            }
            this.elevation = (List)value2;
            return;
        }
        if (name.equals(ImageMosaicFormat.FILTER.getName())) {
            value2 = param.getValue();
            if (value2 == null) {
                return;
            }
            this.filter = (Filter)value2;
            return;
        }
        String paramName = name.getCode();
        if (this.rasterManager.domainsManager != null && this.rasterManager.domainsManager.isParameterSupported(name)) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof List) {
                List values = (List)value;
                this.requestedAdditionalDomains.put(paramName, values);
            }
            return;
        }
        if (name.equals(ImageMosaicFormat.BANDS.getName())) {
            this.bands = (int[])param.getValue();
        }
        if (name.equals(ImageMosaicFormat.EXCESS_GRANULE_REMOVAL.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.excessGranuleRemovalPolicy = (ExcessGranulePolicy)((Object)value);
            return;
        }
        if (name.equals(ImageMosaicFormat.GEOMETRY_MASK.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.geometryMask = (Geometry)value;
            return;
        }
        if (name.equals(ImageMosaicFormat.MASKING_BUFFER_PIXELS.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.maskingBufferPixels = param.doubleValue();
            return;
        }
        if (name.equals(ImageMosaicFormat.SET_ROI_PROPERTY.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.setRoiProperty = (Boolean)value;
            return;
        }
        if (name.equals(AbstractGridFormat.RESCALE_PIXELS.getName())) {
            this.rescalingEnabled = Boolean.TRUE.equals(param.getValue());
            return;
        }
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }

    private void checkReadType() {
        Object o;
        if (this.readType != ReadType.UNSPECIFIED) {
            return;
        }
        Hints hints = this.rasterManager.getHints();
        if (hints != null && (o = hints.get((Object)Hints.USE_JAI_IMAGEREAD)) != null) {
            this.readType = (ReadType)o;
        }
        this.readType = ReadType.getDefault();
    }

    public double[] getVirtualNativeResolution() {
        return this.virtualNativeResolution;
    }

    public Color getInputTransparentColor() {
        return this.inputTransparentColor;
    }

    public Color getOutputTransparentColor() {
        return this.outputTransparentColor;
    }

    public int getMaximumNumberOfGranules() {
        return this.maximumNumberOfGranules;
    }

    public FootprintBehavior getFootprintBehavior() {
        return this.footprintBehavior;
    }

    public int getDefaultArtifactsFilterThreshold() {
        return this.defaultArtifactsFilterThreshold;
    }

    void setFootprintBehavior(FootprintBehavior footprintBehavior) {
        this.footprintBehavior = footprintBehavior;
    }

    public double getArtifactsFilterPTileThreshold() {
        return this.artifactsFilterPTileThreshold;
    }

    public boolean isBlend() {
        return this.blend;
    }

    public ReadType getReadType() {
        return this.readType;
    }

    public double[] getBackgroundValues() {
        return this.backgroundValues;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public Dimension getTileDimensions() {
        return this.tileDimensions;
    }

    public MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    public OverviewPolicy getOverviewPolicy() {
        return this.overviewPolicy;
    }

    public boolean isEmpty() {
        return this.spatialRequestHelper.isEmpty();
    }

    public int[] getBands() {
        return this.bands;
    }

    public Geometry getGeometryMask() {
        return this.geometryMask;
    }

    public void setGeometryMask(Geometry geometryMask) {
        this.geometryMask = geometryMask;
    }

    public double getMaskingBufferPixels() {
        return this.maskingBufferPixels;
    }

    public void setMaskingBufferPixels(double maskingBufferPixels) {
        this.maskingBufferPixels = maskingBufferPixels;
    }

    public boolean isSetRoiProperty() {
        return this.setRoiProperty;
    }

    public void setSetRoiProperty(boolean setRoiProperty) {
        this.setRoiProperty = setRoiProperty;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RasterLayerRequest description: \n");
        builder.append(this.spatialRequestHelper).append("\n");
        builder.append("\tReadType=").append(this.readType);
        return builder.toString();
    }

    public boolean isRescalingEnabled() {
        return this.rescalingEnabled;
    }
}

