/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.gce.imagemosaic.DomainFilterBuilder;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MosaicQueryBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Polygon;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.Parameter;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class FootprintsTransformation
extends FunctionImpl
implements CoverageReadingTransformation {
    private static final String FOOTPRINTS = "footprints";
    public static FunctionName NAME = new FunctionNameImpl("footprints", FunctionNameImpl.parameter((String)"result", SimpleFeatureCollection.class), new Parameter[]{FunctionNameImpl.parameter((String)"coverage", String.class, (int)0, (int)1)});

    public FootprintsTransformation() {
        this.functionName = NAME;
    }

    public SimpleFeatureCollection evaluate(Object object) {
        if (!(object instanceof CoverageReadingTransformation.ReaderAndParams)) {
            throw new IllegalArgumentException("This filter function is supposed to be invoked on a ReaderAndParams object, but got this instead: " + String.valueOf(object));
        }
        CoverageReadingTransformation.ReaderAndParams rap = (CoverageReadingTransformation.ReaderAndParams)object;
        GridCoverage2DReader reader = rap.getReader();
        if (reader instanceof StructuredGridCoverage2DReader) {
            return this.readStructured(rap);
        }
        return this.readSimple(reader, rap.getReadParameters());
    }

    private SimpleFeatureCollection readStructured(CoverageReadingTransformation.ReaderAndParams rap) {
        try {
            StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)rap.getReader();
            String coverage = (String)Converters.convert((Object)this.getParameterValue(rap, 0), String.class);
            if (coverage == null) {
                coverage = reader.getGridCoverageNames()[0];
            }
            GranuleSource source = reader.getGranules(coverage, true);
            return source.getGranules(this.buildQuery(coverage, reader, rap.getReadParameters()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract the granules from the reader");
        }
    }

    private Query buildQuery(String coverage, StructuredGridCoverage2DReader reader, GeneralParameterValue[] readParameters) throws IOException {
        Query query = new Query(coverage);
        if (readParameters != null) {
            String sorting;
            Integer maxTiles = this.getParameter(ImageMosaicFormat.MAX_ALLOWED_TILES, Integer.class, readParameters);
            if (maxTiles != null) {
                query.setMaxFeatures(maxTiles.intValue());
            }
            if ((sorting = this.getParameter(ImageMosaicFormat.SORT_BY, String.class, readParameters)) != null && !sorting.trim().isEmpty()) {
                query.setSortBy(MosaicQueryBuilder.parseSortBy(sorting));
            }
            Filter finalFilter = this.buildFilter(coverage, reader, readParameters);
            query.setFilter(finalFilter);
        }
        return query;
    }

    private Filter buildFilter(String coverage, StructuredGridCoverage2DReader reader, GeneralParameterValue[] readParameters) throws IOException {
        GridGeometry2D gg;
        FilterFactory2 ff = FeatureUtilities.DEFAULT_FILTER_FACTORY;
        ArrayList<Object> filters = new ArrayList<Object>();
        Filter filter = this.getParameter(ImageMosaicFormat.FILTER, Filter.class, readParameters);
        if (filter != null) {
            filters.add(filter);
        }
        if ((gg = this.getParameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D, GridGeometry2D.class, readParameters)) != null) {
            filters.add(ff.bbox((Expression)ff.property(""), (BoundingBox)gg.getEnvelope2D()));
        }
        List dimensions = reader.getDimensionDescriptors(coverage);
        DimensionDescriptor timeDescriptor = this.getDimension(dimensions, "time");
        List time = this.getParameter(AbstractGridFormat.TIME, List.class, readParameters);
        if (time != null && timeDescriptor != null) {
            filters.add(this.buildFilter(timeDescriptor, time));
        }
        DimensionDescriptor elevationDescriptor = this.getDimension(dimensions, "elevation");
        List elevation = this.getParameter(AbstractGridFormat.ELEVATION, List.class, readParameters);
        if (elevation != null && elevationDescriptor != null) {
            filters.add(this.buildFilter(elevationDescriptor, elevation));
        }
        this.getCustomDimensions((GridCoverage2DReader)reader, dimensions, readParameters).forEach((dd, values) -> filters.add(this.buildFilter((DimensionDescriptor)dd, (List)values)));
        if (filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return ff.and(filters);
    }

    private Map<DimensionDescriptor, List> getCustomDimensions(GridCoverage2DReader reader, List<DimensionDescriptor> dimensions, GeneralParameterValue[] readParameters) throws IOException {
        Set descriptors = reader.getDynamicParameters();
        HashMap<DimensionDescriptor, List> result = new HashMap<DimensionDescriptor, List>();
        descriptors.forEach(pd -> {
            List value;
            DimensionDescriptor dd = this.getDimension(dimensions, pd.getName().getCode());
            if (dd != null && (value = this.getParameter((ParameterDescriptor)pd, (Class)List.class, readParameters)) != null) {
                result.put(dd, value);
            }
        });
        return result;
    }

    private DimensionDescriptor getDimension(List<DimensionDescriptor> dimensions, String name) {
        return dimensions.stream().filter(dd -> name.equalsIgnoreCase(dd.getName())).findFirst().orElse(null);
    }

    private Filter buildFilter(DimensionDescriptor dd, List values) {
        return new DomainFilterBuilder(dd.getName(), dd.getStartAttribute(), dd.getEndAttribute()).createFilter(values);
    }

    private <T> T getParameter(ParameterDescriptor pd, Class<T> clazz, GeneralParameterValue[] readParameters) {
        return Arrays.stream(readParameters).filter(p -> pd.getName().equals(p.getDescriptor().getName())).filter(p -> p instanceof ParameterValue).map(p -> (ParameterValue)p).map(p -> Converters.convert((Object)p.getValue(), (Class)clazz)).filter(v -> v != null).findFirst().orElse(null);
    }

    private SimpleFeatureCollection readSimple(GridCoverage2DReader reader, GeneralParameterValue[] readParameters) {
        ReferencedEnvelope bbox = ReferencedEnvelope.reference((Envelope)reader.getOriginalEnvelope());
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)bbox);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geom", Polygon.class, reader.getCoordinateReferenceSystem());
        tb.setName(FOOTPRINTS);
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{polygon}, (String)"footprints.1");
        return DataUtilities.collection((SimpleFeature)feature);
    }

    public Query invertQuery(Query targetQuery, GridGeometry gridGeometry) {
        return targetQuery;
    }

    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry targetGridGeometry) {
        return targetGridGeometry;
    }
}

