/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.Date;
import java.util.Iterator;
import org.geotools.gce.imagemosaic.ConvertersHack;
import org.geotools.gce.imagemosaic.RangeVisitor;
import org.geotools.util.DateRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.opengis.feature.Feature;

class DateRangeVisitor
extends RangeVisitor {
    public DateRangeVisitor(String attributeTypeName1, String attributeTypeName2) {
        super(attributeTypeName1, attributeTypeName2, RangeVisitor.RangeType.DATE);
    }

    @Override
    public void visit(Feature feature) {
        Object firstValue = this.expr1.evaluate((Object)feature);
        Object secondValue = this.expr2.evaluate((Object)feature);
        if (firstValue != null && secondValue != null) {
            Date beginDate = (Date)firstValue;
            Date endDate = (Date)secondValue;
            this.set.add(new DateRange(beginDate, endDate));
        }
    }

    @Override
    protected void populateRange() {
        Iterator iterator = this.set.iterator();
        DateRange second = null;
        while (iterator.hasNext()) {
            DateRange first = second;
            second = (DateRange)iterator.next();
            if (first == null) continue;
            if (second.intersects((Range)first)) {
                second = DateRangeVisitor.merge(first, second);
                if (iterator.hasNext()) continue;
                this.minimalRanges.add(this.formatRange(second));
                second = null;
                continue;
            }
            this.minimalRanges.add(this.formatRange(first));
            first = null;
        }
        if (second != null) {
            this.minimalRanges.add(this.formatRange(second));
        }
    }

    private String formatRange(DateRange range) {
        StringBuilder builder = new StringBuilder();
        String begin = ConvertersHack.convert(range.getMinValue(), String.class);
        String end = ConvertersHack.convert(range.getMaxValue(), String.class);
        builder.append(begin + "/" + end + "/PT1S");
        return builder.toString();
    }

    private static DateRange merge(DateRange firstDateRange, DateRange secondDateRange) {
        Utilities.ensureNonNull((String)"firstDateRange", (Object)firstDateRange);
        Utilities.ensureNonNull((String)"secondDateRange", (Object)secondDateRange);
        long beginFirst = firstDateRange.getMinValue().getTime();
        long endFirst = firstDateRange.getMaxValue().getTime();
        long beginSecond = secondDateRange.getMinValue().getTime();
        long endSecond = secondDateRange.getMaxValue().getTime();
        long max = Math.max(endFirst, endSecond);
        long min = Math.min(beginFirst, beginSecond);
        Date beginDate = new Date(min);
        Date endDate = new Date(max);
        return new DateRange(beginDate, endDate);
    }
}

