/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.string;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.string.StringFileNameExtractorSPI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class StringFileNameExtractorTest {
    private SimpleFeature feature;

    @Before
    public void setup() throws SchemaException {
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"id:int,seq:String");
        this.feature = DataUtilities.createFeature((SimpleFeatureType)ft, (String)"1|null");
    }

    @Test
    public void testNoGroupExtraction() {
        PropertiesCollectorSPI spi = this.getStringFileNameSpi();
        PropertiesCollector collector = spi.create((Object)"regex=[0-9]{8}T[0-9]{6}", Arrays.asList("seq"));
        File file = new File("polyphemus_20130301T000000_.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        String seq = (String)this.feature.getAttribute("seq");
        Assert.assertNotNull((Object)seq);
        Assert.assertEquals((Object)"20130301T000000", (Object)seq);
    }

    @Test
    public void testGroupExtraction() {
        PropertiesCollectorSPI spi = this.getStringFileNameSpi();
        PropertiesCollector collector = spi.create((Object)"regex=_([0-9]{8}T[0-9]{6})_", Arrays.asList("seq"));
        File file = new File("polyphemus_20130301T000000_.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        String seq = (String)this.feature.getAttribute("seq");
        Assert.assertNotNull((Object)seq);
        Assert.assertEquals((Object)"20130301T000000", (Object)seq);
    }

    @Test
    public void testMultipleGroupExtraction() {
        PropertiesCollectorSPI spi = this.getStringFileNameSpi();
        PropertiesCollector collector = spi.create((Object)"regex=_([0-9]{8})T([0-9]{6})_", Arrays.asList("seq"));
        File file = new File("polyphemus_20130301T000000_.nc");
        collector.collect(file);
        collector.setProperties(this.feature);
        String seq = (String)this.feature.getAttribute("seq");
        Assert.assertNotNull((Object)seq);
        Assert.assertEquals((Object)"20130301000000", (Object)seq);
    }

    private PropertiesCollectorSPI getStringFileNameSpi() {
        Set spis = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        for (PropertiesCollectorSPI spi : spis) {
            if (!spi.getName().equals(StringFileNameExtractorSPI.class.getSimpleName())) continue;
            return spi;
        }
        return null;
    }
}

