/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.granulecollector.DefaultSubmosaicProducerFactory;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducerFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.operation.MathTransform2D;

public class RasterLayerResponseTest {
    private static final double DELTA = 1.0E-5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeterogeneous() throws Exception {
        URL testMosaic = TestData.url((Object)this, (String)"heterogeneous");
        ImageMosaicReader reader = null;
        try {
            reader = new ImageMosaicFormat().getReader((Object)testMosaic);
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            Dimension dim = new Dimension();
            dim.setSize(10, 20);
            GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
            rasterArea.setSize(dim);
            GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
            GridGeometry2D gridGeometryValue = new GridGeometry2D((GridEnvelope)range, (Envelope)envelope);
            gg.setValue((Object)gridGeometryValue);
            RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
            RasterLayerRequest request = new RasterLayerRequest(new GeneralParameterValue[]{gg}, manager);
            RasterLayerResponse response = new RasterLayerResponse(request, manager, (SubmosaicProducerFactory)new DefaultSubmosaicProducerFactory());
            Class<?> c = response.getClass();
            Method method = c.getDeclaredMethod("prepareResponse", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)response, new Object[0]);
            Field finalGridToWorldCorner = c.getDeclaredField("finalGridToWorldCorner");
            finalGridToWorldCorner.setAccessible(true);
            MathTransform2D transform = (MathTransform2D)finalGridToWorldCorner.get(response);
            AffineTransform2D affineTransform = (AffineTransform2D)transform;
            AffineTransform2D gridToCRS = (AffineTransform2D)gridGeometryValue.getGridToCRS2D();
            Assert.assertEquals((double)gridToCRS.getScaleX(), (double)XAffineTransform.getScaleX0((AffineTransform)affineTransform), (double)1.0E-5);
            Assert.assertEquals((double)Math.abs(gridToCRS.getScaleY()), (double)XAffineTransform.getScaleY0((AffineTransform)affineTransform), (double)1.0E-5);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSourceUrl() throws Exception {
        URL testMosaic = TestData.url((Object)this, (String)"heterogeneous");
        ImageMosaicReader reader = null;
        try {
            reader = new ImageMosaicFormat().getReader((Object)testMosaic, null);
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            Dimension dim = new Dimension();
            dim.setSize(10, 20);
            GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
            rasterArea.setSize(dim);
            GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
            gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
            RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
            RasterLayerRequest request = new RasterLayerRequest(new GeneralParameterValue[]{gg}, manager);
            RasterLayerResponse response = new RasterLayerResponse(request, manager, (SubmosaicProducerFactory)new DefaultSubmosaicProducerFactory());
            GridCoverage2D coverage = response.createResponse();
            URL sourceUrl = (URL)coverage.getProperty("SourceUrl");
            Assert.assertNotNull((Object)sourceUrl);
            Assert.assertEquals((Object)"file", (Object)sourceUrl.getProtocol());
            Assert.assertTrue((boolean)sourceUrl.getPath().endsWith(".tif"));
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

