/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.google.common.io.Files;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.Interpolation;
import org.geotools.TestData;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MultiResolutionTest {
    @Test
    public void testCatalogBuilderSample() throws IOException, TransformException {
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)TestData.file((Object)this, (String)"multiresolution"));
        GridEnvelope originalRange = reader.getOriginalGridRange();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        CoordinateReferenceSystem nativeCRS = envelope.getCoordinateReferenceSystem();
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(nativeCRS);
        ParameterValue pam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        pam.setValue((Object)new GridGeometry2D((GridEnvelope)testRange, (Envelope)testEnvelope));
        GridCoverage2D gc = reader.read((GeneralParameterValue[])new ParameterValue[]{pam});
        Assert.assertNotNull((Object)gc);
        reader.dispose();
    }

    @Test
    public void testVirtualNativeResolution() throws IOException, TransformException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File file = folder.newFile("sample.tif");
        Files.copy((File)TestData.file((Object)this, (String)"multiresolution/sample.tif"), (File)file);
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)folder.getRoot());
        GridEnvelope originalRange = reader.getOriginalGridRange();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        MathTransform g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        AffineTransform2D at = (AffineTransform2D)g2w;
        ParameterValue virtualNativeRes = ImageMosaicFormat.VIRTUAL_NATIVE_RESOLUTION.createValue();
        virtualNativeRes.setValue((Object)new double[]{at.getScaleX() * 16.0, -at.getScaleY() * 16.0});
        ParameterValue pam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        pam.setValue((Object)new GridGeometry2D(originalRange, (Envelope)envelope));
        GridCoverage2D gc = reader.read((GeneralParameterValue[])new ParameterValue[]{virtualNativeRes, pam});
        RenderedImage ri = gc.getRenderedImage();
        Assert.assertTrue((ri.getWidth() < 20 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getHeight() < 20 ? 1 : 0) != 0);
        reader.dispose();
    }

    @Test
    public void testVirtualNativeResolutionNoOverviews() throws IOException, TransformException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File srtm = folder.newFile("sample_noov.tif");
        Files.copy((File)TestData.file((Object)this, (String)"multiresolution/sample_noov.tif"), (File)srtm);
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)folder.getRoot());
        GridEnvelope originalRange = reader.getOriginalGridRange();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        MathTransform g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        AffineTransform2D at = (AffineTransform2D)g2w;
        ParameterValue virtualNativeRes = ImageMosaicFormat.VIRTUAL_NATIVE_RESOLUTION.createValue();
        virtualNativeRes.setValue((Object)new double[]{at.getScaleX() * 16.0, -at.getScaleY() * 16.0});
        ParameterValue pam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        pam.setValue((Object)new GridGeometry2D(originalRange, (Envelope)envelope));
        GridCoverage2D gc = reader.read((GeneralParameterValue[])new ParameterValue[]{virtualNativeRes, pam});
        RenderedImage ri = gc.getRenderedImage();
        Assert.assertTrue((ri.getWidth() < 20 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getHeight() < 20 ? 1 : 0) != 0);
        reader.dispose();
    }

    @Test
    public void testPickHighestResolution() throws IOException, TransformException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File srtm = folder.newFile("srtm.tiff");
        File sfdem = folder.newFile("sfdem.tiff");
        Files.copy((File)TestData.file((Object)this, (String)"multiresolution/srtm.tiff"), (File)srtm);
        Files.copy((File)TestData.file((Object)this, (String)"multiresolution/sfdem.tiff"), (File)sfdem);
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)folder.getRoot());
        GeoTiffFormat tiffFormat = new GeoTiffFormat();
        GeoTiffReader sfdemReader = tiffFormat.getReader((Object)sfdem);
        this.assertEquals(sfdemReader.getResolutionLevels()[0], reader.getResolutionLevels()[0], 0.001);
        sfdemReader.dispose();
    }

    @Test
    public void testVirtualNativeResolutionPreserveAffine() throws IOException, TransformException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File file = folder.newFile("sample.tif");
        Files.copy((File)TestData.file((Object)this, (String)"multiresolution/sample2.tif"), (File)file);
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)folder.getRoot());
        GridEnvelope originalRange = reader.getOriginalGridRange();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        MathTransform g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        AffineTransform2D at = (AffineTransform2D)g2w;
        ParameterValue virtualNativeRes = ImageMosaicFormat.VIRTUAL_NATIVE_RESOLUTION.createValue();
        virtualNativeRes.setValue((Object)new double[]{at.getScaleX() * 40.0, -at.getScaleY() * 40.0});
        ParameterValue decimation = ImageMosaicFormat.DECIMATION_POLICY.createValue();
        decimation.setValue((Object)DecimationPolicy.DISALLOW);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        gg.setValue((Object)new GridGeometry2D(originalRange, (Envelope)envelope));
        ParameterValue interpolation = AbstractGridFormat.INTERPOLATION.createValue();
        interpolation.setValue((Object)Interpolation.getInstance((int)0));
        GridCoverage2D gc = reader.read((GeneralParameterValue[])new ParameterValue[]{virtualNativeRes, gg, decimation, interpolation});
        RenderedImage ri = gc.getRenderedImage();
        ImageWorker worker = new ImageWorker(ri);
        worker = worker.crop(0.0f, 0.0f, 40.0f, 40.0f);
        double[] max = worker.getMaximums();
        double[] min = worker.getMinimums();
        this.assertEquals(max, min, 1.0E-6);
        reader.dispose();
    }

    private void assertEquals(double[] expected, double[] actuals, double epsilon) {
        Assert.assertEquals((long)expected.length, (long)actuals.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actuals[i], (double)epsilon);
        }
    }
}

