/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GranuleRemovalPolicy;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.WKBLoaderSPI;
import org.geotools.coverage.grid.io.footprint.WKTLoaderSPI;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormatFactory;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.precision.EnhancedPrecisionOp;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class ImageMosaicFootprintsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private File testMosaic;
    private URL testMosaicUrl;
    private File footprintsSource;
    private Geometry geometryMask;
    private static boolean DEBUG = false;
    @Rule
    public TemporaryFolder redFootprintFolder = new TemporaryFolder();

    @Before
    public void setupMosaic() throws IOException, ParseException {
        this.testMosaic = new File(TestData.file((Object)this, (String)"."), "footprintMosaic");
        if (this.testMosaic.exists()) {
            FileUtils.deleteDirectory((File)this.testMosaic);
        }
        File mosaicSource = TestData.file((Object)this, (String)"rgb");
        FileUtils.copyDirectory((File)mosaicSource, (File)this.testMosaic);
        this.testMosaicUrl = URLs.fileToUrl((File)this.testMosaic);
        this.footprintsSource = TestData.file((Object)this, (String)"rgb-footprints");
        WKTReader wktReader = new WKTReader();
        this.geometryMask = wktReader.read("POLYGON ((-170 -10, -72 80, 80 0, -170 -10))");
    }

    @Test
    public void testSingleShapefileDefaults() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        this.assertItalyFootprints();
    }

    @Test
    public void testWkbSidecars() throws Exception {
        ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)new File(this.footprintsSource, "footprints.shp")));
        ds.getFeatureSource().getFeatures().accepts(feature -> {
            try {
                SimpleFeature sf = (SimpleFeature)feature;
                String fileName = (String)sf.getAttribute("location");
                int idx = fileName.lastIndexOf(".");
                Geometry g = (Geometry)sf.getDefaultGeometry();
                File wkbFile = new File(this.testMosaic, fileName.substring(0, idx) + ".wkb");
                byte[] bytes = new WKBWriter().write(g);
                FileUtils.writeByteArrayToFile((File)wkbFile, (byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, null);
        ds.dispose();
        this.assertItalyFootprints();
    }

    @Test
    public void testWktSidecars() throws Exception {
        ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)new File(this.footprintsSource, "footprints.shp")));
        ds.getFeatureSource().getFeatures().accepts(feature -> {
            try {
                SimpleFeature sf = (SimpleFeature)feature;
                String fileName = (String)sf.getAttribute("location");
                int idx = fileName.lastIndexOf(".");
                Geometry g = (Geometry)sf.getDefaultGeometry();
                File wkbFile = new File(this.testMosaic, fileName.substring(0, idx) + ".wkt");
                String wkt = new WKTWriter().write(g);
                FileUtils.writeStringToFile((File)wkbFile, (String)wkt, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, null);
        ds.dispose();
        this.assertItalyFootprints();
    }

    @Test
    public void testWkbMultipleSidecars() throws Exception {
        this.testMultipleSidecars("footprint_wkbs", WKBLoaderSPI.class.getName(), true, "_%d");
    }

    @Test
    public void testWktMultipleSidecars() throws Exception {
        this.testMultipleSidecars("footprint_wkts", WKTLoaderSPI.class.getName(), false, "-%d");
    }

    @Test
    public void testWktMultipleSidecarsAutoDetect() throws Exception {
        this.testMultipleSidecars("footprint_wkts", null, false, "-%d");
    }

    private void testMultipleSidecars(String testFolder, String loaderClassName, boolean overviewsInRasterSpace, String overviewsSuffixFormat) throws Exception {
        ImageMosaicReader reader = this.getMultipleSidecarReader(testFolder, loaderClassName, overviewsInRasterSpace, overviewsSuffixFormat);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        double scalingFactorX = 0.2;
        double scalingFactorY = 0.2;
        double spanRatioX = 0.8888888888888888;
        double spanRatioY = 0.8333333333333334;
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) * 0.17777777777777778, (double)reader.getOriginalGridRange().getSpan(1) * 0.16666666666666669);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        double maxX = envelope.getMaximum(0);
        double minY = envelope.getMinimum(1);
        double minX = maxX - envelope.getSpan(0) * 0.8888888888888888;
        double maxY = minY + envelope.getSpan(1) * 0.8333333333333334;
        GeneralEnvelope env2 = new GeneralEnvelope(new double[]{minX, minY}, new double[]{maxX, maxY});
        env2.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)env2));
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{footprintManagement, gg});
        byte[] pixel = new byte[4];
        coverage.evaluate((DirectPosition)new DirectPosition2D(-89.0, 34.0), pixel);
        Assert.assertEquals((long)0L, (long)pixel[3]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(43.0, -13.0), pixel);
        Assert.assertEquals((long)0L, (long)pixel[3]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(131.0, 10.0), pixel);
        Assert.assertEquals((long)0L, (long)pixel[3]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(145.0, 0.0), pixel);
        Assert.assertEquals((long)0L, (long)pixel[3]);
    }

    private ImageMosaicReader getMultipleSidecarReader(String testFolder, String loaderClassName, boolean overviewsInRasterSpace, String overviewsSuffixFormat) throws IOException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File multiWkbs = folder.getRoot();
        FileUtils.copyDirectory((File)TestData.file((Object)this, (String)testFolder), (File)multiWkbs);
        Properties p = new Properties();
        p.put("footprint_source", "multisidecar");
        p.put("overviewsSuffixFormat", overviewsSuffixFormat);
        p.put("overviewsRoiInRasterSpace", Boolean.toString(overviewsInRasterSpace));
        if (loaderClassName != null) {
            p.put("footprintLoaderSPI", loaderClassName);
        }
        try (FileOutputStream fos = new FileOutputStream(new File(multiWkbs, "footprints.properties"));){
            p.store(fos, null);
        }
        ImageMosaicFormat format = new ImageMosaicFormat();
        return format.getReader((Object)multiWkbs);
    }

    @Test
    public void testShapefileSidecars() throws Exception {
        ShapefileDataStore ds = new ShapefileDataStore(URLs.fileToUrl((File)new File(this.footprintsSource, "footprints.shp")));
        ds.getFeatureSource().getFeatures().accepts(feature -> {
            try {
                SimpleFeature sf = (SimpleFeature)feature;
                String fileName = (String)sf.getAttribute("location");
                int idx = fileName.lastIndexOf(".");
                Geometry g = (Geometry)sf.getDefaultGeometry();
                String filename = fileName.substring(0, idx);
                File shpFile = new File(this.testMosaic, filename + ".shp");
                ShapefileDataStore sds = new ShapefileDataStore(URLs.fileToUrl((File)shpFile));
                SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                tb.setName(filename);
                GeometryDescriptor gd = sf.getFeatureType().getGeometryDescriptor();
                tb.add("the_geom", gd.getType().getBinding(), gd.getCoordinateReferenceSystem());
                SimpleFeatureType sft = tb.buildFeatureType();
                sds.createSchema(sft);
                SimpleFeatureBuilder fb = new SimpleFeatureBuilder(sft);
                fb.add((Object)g);
                SimpleFeature footprintFeature = fb.buildFeature(null);
                SimpleFeatureStore fs = (SimpleFeatureStore)sds.getFeatureSource();
                fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)footprintFeature));
                sds.dispose();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, null);
        this.assertItalyFootprints();
    }

    @Test
    public void testMasking() throws Exception {
        this.maskCoverage(false, Double.NaN, this.geometryMask);
    }

    @Test
    @Ignore
    public void testMaskingWithFootprint() throws Exception {
        this.maskCoverage(true, Double.NaN, this.geometryMask);
    }

    @Test
    public void testMaskingWithBuffer() throws Exception {
        this.maskCoverage(false, 10.0, this.geometryMask);
    }

    @Test
    @Ignore
    public void testMaskingWithBufferAndFootprint() throws Exception {
        this.maskCoverage(true, 10.0, this.geometryMask);
    }

    @Test
    @Ignore
    public void testMaskingDecimationWithBufferAndFootprint() throws Exception {
        Geometry decimatingMask = Densifier.densify((Geometry)this.geometryMask, (double)0.2);
        this.maskCoverage(true, 10.0, decimatingMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maskCoverage(boolean footprint, double buffer, Geometry geometryMask) throws Exception {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File multiWkts = folder.getRoot();
        FileUtils.copyDirectory((File)TestData.file((Object)this, (String)"footprint_wkts"), (File)multiWkts);
        Properties p = new Properties();
        p.put("footprint_source", "multisidecar");
        try (FileOutputStream fos = new FileOutputStream(new File(multiWkts, "footprints.properties"));){
            p.store(fos, null);
        }
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = null;
        GridCoverage2D coverage = null;
        try {
            reader = format.getReader((Object)multiWkts);
            AffineTransform2D g2w = (AffineTransform2D)reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
            double xScale = g2w.getScaleX();
            boolean useBuffer = !Double.isNaN(buffer);
            Geometry intersectingMask = useBuffer ? geometryMask.buffer(buffer * xScale) : geometryMask;
            Polygon unionGeometry = null;
            if (footprint) {
                Geometry leftGeometry = this.readWktGeometry("r1c1.wkt");
                Geometry rightGeometry = this.readWktGeometry("r1c2.wkt");
                unionGeometry = leftGeometry.union(rightGeometry);
            } else {
                unionGeometry = JTS.toGeometry((ReferencedEnvelope)new ReferencedEnvelope((Envelope)reader.getOriginalEnvelope()));
            }
            Geometry maskedGeometry = unionGeometry.intersection(intersectingMask);
            double inputMaskArea = maskedGeometry.getArea();
            ArrayList<ParameterValue> paramList = new ArrayList<ParameterValue>();
            if (footprint) {
                ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
                footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
                paramList.add(footprintManagement);
            }
            ParameterValue maskParam = ImageMosaicFormat.GEOMETRY_MASK.createValue();
            maskParam.setValue((Object)geometryMask);
            paramList.add(maskParam);
            ParameterValue setRoiParam = ImageMosaicFormat.SET_ROI_PROPERTY.createValue();
            setRoiParam.setValue(true);
            paramList.add(setRoiParam);
            if (useBuffer) {
                ParameterValue maskingBuffer = ImageMosaicFormat.MASKING_BUFFER_PIXELS.createValue();
                maskingBuffer.setValue(buffer);
                paramList.add(maskingBuffer);
            }
            GeneralParameterValue[] params = new GeneralParameterValue[paramList.size()];
            params = paramList.toArray(params);
            coverage = reader.read(params);
            RenderedImage image = coverage.getRenderedImage();
            if (DEBUG) {
                RenderedImageBrowser.showChain((RenderedImage)image);
                System.in.read();
            }
            ROIGeometry roi = (ROIGeometry)image.getProperty("ROI");
            MathTransform2D tx = coverage.getGridGeometry().getCRSToGrid2D(PixelOrientation.UPPER_LEFT).inverse();
            Geometry roiGeometry = roi.getAsGeometry();
            double tolerance = 0.1;
            if (geometryMask != this.geometryMask) {
                int numPoints = roiGeometry.getNumPoints();
                Assert.assertTrue((numPoints < 1000 ? 1 : 0) != 0);
                tolerance = 2.0;
            }
            Geometry coverageGeometry = JTS.transform((Geometry)roiGeometry, (MathTransform)tx);
            double coverageMaskArea = coverageGeometry.getArea();
            Geometry aMinusB = EnhancedPrecisionOp.difference((Geometry)coverageGeometry, (Geometry)maskedGeometry);
            Geometry bMinusA = EnhancedPrecisionOp.difference((Geometry)maskedGeometry, (Geometry)coverageGeometry);
            Assert.assertEquals((double)inputMaskArea, (double)coverageMaskArea, (double)tolerance);
            Assert.assertEquals((double)0.0, (double)aMinusB.getArea(), (double)tolerance);
            Assert.assertEquals((double)0.0, (double)bMinusA.getArea(), (double)tolerance);
        }
        finally {
            if (coverage != null) {
                coverage.dispose(true);
            }
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testMaskWithBackground() throws Exception {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File multiWkts = folder.getRoot();
        FileUtils.copyDirectory((File)TestData.file((Object)this, (String)"footprint_wkts"), (File)multiWkts);
        Properties p = new Properties();
        p.put("footprint_source", "multisidecar");
        try (FileOutputStream fos = new FileOutputStream(new File(multiWkts, "footprints.properties"));){
            p.store(fos, null);
        }
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = null;
        GridCoverage2D coverage = null;
        try {
            reader = format.getReader((Object)multiWkts);
            ArrayList<ParameterValue> paramList = new ArrayList<ParameterValue>();
            ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
            footprintManagement.setValue((Object)FootprintBehavior.Cut.name());
            paramList.add(footprintManagement);
            ParameterValue maskParam = ImageMosaicFormat.GEOMETRY_MASK.createValue();
            maskParam.setValue((Object)this.geometryMask);
            paramList.add(maskParam);
            ParameterValue setRoiParam = ImageMosaicFormat.SET_ROI_PROPERTY.createValue();
            setRoiParam.setValue(true);
            paramList.add(setRoiParam);
            ParameterValue bg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
            double[] bgValues = new double[]{0.0, 255.0, 0.0};
            bg.setValue((Object)bgValues);
            paramList.add(bg);
            GeneralEnvelope oldEnvelope = reader.getOriginalEnvelope();
            GeneralEnvelope cropEnvelope = new GeneralEnvelope(new double[]{oldEnvelope.getLowerCorner().getOrdinate(0) + oldEnvelope.getSpan(0) / 4.0, oldEnvelope.getLowerCorner().getOrdinate(1) + oldEnvelope.getSpan(1) / 2.0}, new double[]{oldEnvelope.getUpperCorner().getOrdinate(0) - oldEnvelope.getSpan(0) / 2.0, oldEnvelope.getUpperCorner().getOrdinate(1)});
            cropEnvelope.setCoordinateReferenceSystem(reader.getCoordinateReferenceSystem());
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            gg.setValue((Object)new GridGeometry2D(PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), (Envelope)cropEnvelope, null));
            paramList.add(gg);
            GeneralParameterValue[] params = new GeneralParameterValue[paramList.size()];
            params = paramList.toArray(params);
            coverage = reader.read(params);
            RenderedImage image = coverage.getRenderedImage();
            ROIGeometry roi = (ROIGeometry)image.getProperty("ROI");
            MathTransform2D tx = coverage.getGridGeometry().getCRSToGrid2D(PixelOrientation.UPPER_LEFT).inverse();
            Geometry roiGeometry = roi.getAsGeometry();
            Geometry coverageGeometry = JTS.transform((Geometry)roiGeometry, (MathTransform)tx);
            double coverageMaskArea = coverageGeometry.getArea();
            Geometry intersectingMask = this.geometryMask;
            Polygon requestedAreaGeometry = JTS.toGeometry((ReferencedEnvelope)new ReferencedEnvelope((Envelope)cropEnvelope));
            Geometry leftGeometry = this.readWktGeometry("r1c1.wkt");
            Geometry rightGeometry = this.readWktGeometry("r1c2.wkt");
            Geometry unionGeometry = leftGeometry.union(rightGeometry);
            Geometry maskedGeometry = requestedAreaGeometry.intersection(intersectingMask);
            maskedGeometry = unionGeometry.intersection(maskedGeometry);
            maskedGeometry = maskedGeometry.getGeometryN(1);
            double inputMaskArea = maskedGeometry.getArea();
            Geometry aMinusB = EnhancedPrecisionOp.difference((Geometry)coverageGeometry, (Geometry)maskedGeometry);
            Geometry bMinusA = EnhancedPrecisionOp.difference((Geometry)maskedGeometry, (Geometry)coverageGeometry);
            if (DEBUG) {
                RenderedImageBrowser.showChain((RenderedImage)image);
                System.in.read();
            }
            Assert.assertEquals((double)inputMaskArea, (double)coverageMaskArea, (double)0.001);
            Assert.assertEquals((double)0.0, (double)aMinusB.getArea(), (double)0.001);
            Assert.assertEquals((double)0.0, (double)bMinusA.getArea(), (double)0.001);
            int[] pixel = new int[3];
            image.getData().getPixel(0, 0, pixel);
            for (int i = 0; i < 3; ++i) {
                Assert.assertEquals((long)pixel[i], (long)((int)bgValues[i]));
            }
        }
        finally {
            if (coverage != null) {
                coverage.dispose(true);
            }
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Geometry readWktGeometry(String fileName) throws FileNotFoundException, IOException, ParseException {
        WKTReader wktReader = new WKTReader();
        File file = TestData.file((Object)this, (String)("footprint_wkts" + File.separatorChar + fileName));
        try (FileReader fileReader = new FileReader(file);){
            Geometry geometry = wktReader.read((Reader)fileReader);
            return geometry;
        }
    }

    private void assertItalyFootprints() throws NoSuchAuthorityCodeException, FactoryException, IOException {
        GridCoverage2D coverage = this.readCoverage();
        byte[] pixel = new byte[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(16.87, 40.19), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.12, 44.25), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.0, 40.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(8.0, 45.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
    }

    private GridCoverage2D readCoverage() throws NoSuchAuthorityCodeException, FactoryException, IOException {
        AbstractGridFormat format = TestUtils.getFormat(this.testMosaicUrl);
        ImageMosaicReader reader = TestUtils.getReader(this.testMosaicUrl, format);
        GeneralParameterValue[] params = new GeneralParameterValue[2];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Cut.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        GridCoverage2D coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        return coverage;
    }

    @Test
    public void testAreaOutside() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        Properties p = new Properties();
        p.put("footprint_inset", "0.1");
        this.saveFootprintProperties(p);
        AbstractGridFormat format = TestUtils.getFormat(this.testMosaicUrl);
        ImageMosaicReader reader = TestUtils.getReader(this.testMosaicUrl, format);
        GeneralParameterValue[] params = new GeneralParameterValue[3];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Dimension dim = new Dimension();
        dim.setSize(4, 4);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        rasterArea.x = 0;
        rasterArea.y = (int)(rasterArea.getHeight() / 2.0);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem(), null));
        params[2] = gg;
        GridCoverage2D coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        RenderedImage ri = coverage.getRenderedImage();
        Object roiCandidate = ri.getProperty("ROI");
        Assert.assertTrue((boolean)(roiCandidate instanceof ROI));
        ROI roi = (ROI)roiCandidate;
        Assert.assertFalse((boolean)roi.intersects(ri.getMinX(), ri.getMinY(), ri.getWidth(), ri.getHeight()));
    }

    @Test
    public void testRequestHole() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        Properties p = new Properties();
        p.put("footprint_inset", "0.1");
        this.saveFootprintProperties(p);
        AbstractGridFormat format = TestUtils.getFormat(this.testMosaicUrl);
        ImageMosaicReader reader = TestUtils.getReader(this.testMosaicUrl, format);
        reader.dispose();
        File sampleImage = new File(this.testMosaic, "sample_image.dat");
        sampleImage.delete();
        reader = TestUtils.getReader(this.testMosaicUrl, format);
        GeneralParameterValue[] params = new GeneralParameterValue[3];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        MathTransform mt = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        GridEnvelope2D ge = new GridEnvelope2D(6, 44, 1, 1);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)ge, mt, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        params[2] = gg;
        GridCoverage2D coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertNotEquals((long)1L, (long)ri.getColorModel().getTransparency());
        reader.dispose();
        reader = TestUtils.getReader(this.testMosaicUrl, format);
        coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        ri = coverage.getRenderedImage();
        Assert.assertNotEquals((long)1L, (long)ri.getColorModel().getTransparency());
        reader.dispose();
        Object roiCandidate = ri.getProperty("ROI");
        Assert.assertTrue((boolean)(roiCandidate instanceof ROI));
        ROI roi = (ROI)roiCandidate;
        Assert.assertFalse((boolean)roi.intersects(ri.getMinX(), ri.getMinY(), ri.getWidth(), ri.getHeight()));
    }

    @Test
    public void testInsetsFull() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        Properties p = new Properties();
        p.put("footprint_inset", "0.1");
        p.put("footprint_inset_type", "full");
        this.saveFootprintProperties(p);
        GridCoverage2D coverage = this.readCoverage();
        byte[] pixel = new byte[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(12.54, 44.03), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(11.52, 44.57), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.12, 44.25), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.0, 40.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(8.0, 45.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        this.disposeCoverage(coverage);
        ImageMosaicReader reader = TestUtils.getReader(this.testMosaicUrl, (AbstractGridFormat)new ImageMosaicFormat());
        GeneralParameterValue[] params = new GeneralParameterValue[3];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        GridEnvelope2D ge2D = new GridEnvelope2D(reader.getOriginalGridRange().getHigh(0) - 3, reader.getOriginalGridRange().getLow(1), 3, 3);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)ge2D, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem());
        ParameterValue gg2DParam = ImageMosaicFormat.READ_GRIDGEOMETRY2D.createValue();
        gg2DParam.setValue((Object)gg2D);
        params[2] = gg2DParam;
        coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        pixel = new byte[4];
        coverage.evaluate((DirectPosition)new DirectPosition2D(coverage.getEnvelope().getMinimum(0) + 0.001, coverage.getEnvelope().getMinimum(1) + 0.001), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        Assert.assertEquals((long)0L, (long)pixel[3]);
        this.disposeCoverage(coverage);
    }

    @Test
    public void testInsetsMargin() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        Properties p = new Properties();
        p.put("footprint_inset", "0.1");
        p.put("footprint_inset_type", "border");
        this.saveFootprintProperties(p);
        GridCoverage2D coverage = this.readCoverage();
        byte[] pixel = new byte[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(12.54, 44.03), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(11.52, 44.57), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.12, 44.25), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.0, 40.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(8.0, 45.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        this.disposeCoverage(coverage);
        ImageMosaicReader reader = TestUtils.getReader(this.testMosaicUrl, (AbstractGridFormat)new ImageMosaicFormat());
        GeneralParameterValue[] params = new GeneralParameterValue[3];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        GridEnvelope2D ge2D = new GridEnvelope2D(reader.getOriginalGridRange().getHigh(0) - 3, reader.getOriginalGridRange().getLow(1), 3, 3);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)ge2D, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem());
        ParameterValue gg2DParam = ImageMosaicFormat.READ_GRIDGEOMETRY2D.createValue();
        gg2DParam.setValue((Object)gg2D);
        params[2] = gg2DParam;
        coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        pixel = new byte[4];
        coverage.evaluate((DirectPosition)new DirectPosition2D(coverage.getEnvelope().getMinimum(0) + 0.001, coverage.getEnvelope().getMinimum(1) + 0.001), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        Assert.assertEquals((long)0L, (long)pixel[3]);
        this.disposeCoverage(coverage);
    }

    private void disposeCoverage(GridCoverage2D coverage) {
        if (coverage == null) {
            return;
        }
        RenderedImage im = coverage.getRenderedImage();
        ImageUtilities.disposePlanarImageChain((PlanarImage)PlanarImage.wrapRenderedImage((RenderedImage)im));
        coverage.dispose(true);
    }

    private void saveFootprintProperties(Properties p) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(new File(this.testMosaic, "footprints.properties"));){
            p.store(fos, null);
        }
    }

    @AfterClass
    public static void close() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @BeforeClass
    public static void init() {
        CRS.reset((String)"all");
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    @Test
    public void testInsetsBorder() throws Exception {
        FileUtils.copyDirectory((File)this.footprintsSource, (File)this.testMosaic);
        Properties p = new Properties();
        p.put("footprint_inset", "0.1");
        this.saveFootprintProperties(p);
        GridCoverage2D coverage = this.readCoverage();
        byte[] pixel = new byte[3];
        coverage.evaluate((DirectPosition)new DirectPosition2D(12.54, 44.03), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.12, 44.25), pixel);
        Assert.assertEquals((long)0L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        coverage.evaluate((DirectPosition)new DirectPosition2D(9.0, 40.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((DirectPosition)new DirectPosition2D(8.0, 45.0), pixel);
        Assert.assertTrue((pixel[0] + pixel[1] + pixel[2] > 0 ? 1 : 0) != 0);
        this.disposeCoverage(coverage);
    }

    @Test
    public void testFootprintA() throws IOException {
        ImageMosaicReader reader = (ImageMosaicReader)new ImageMosaicFormatFactory().createFormat().getReader((Object)TestData.file((Object)this, (String)"footprint_a"));
        GeneralParameterValue[] params = new GeneralParameterValue[1];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        GridCoverage2D coverage = reader.read(params);
        byte[] result = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(1.0, 1.0);
        coverage.evaluate((DirectPosition)position, result);
        Assert.assertEquals((long)4L, (long)coverage.getSampleDimensions().length);
        Assert.assertEquals((long)0L, (long)result[3]);
        position = new DirectPosition2D();
        position.setLocation(-1.0, -1.0);
        coverage.evaluate((DirectPosition)position, result);
        Assert.assertEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        Assert.assertNotEquals((long)0L, (long)result[2]);
        Assert.assertNotEquals((long)0L, (long)result[3]);
        reader.dispose();
    }

    @Test
    public void testFootprintRGB() throws FileNotFoundException, IOException {
        this.checkFootprint(TestData.file((Object)this, (String)"footprint_rgb"));
    }

    @Test
    public void testFootprintRGBA() throws FileNotFoundException, IOException {
        this.checkFootprint(TestData.file((Object)this, (String)"footprint_rgba"));
    }

    public void checkFootprint(File mosaic) throws IOException {
        ImageMosaicReader reader = (ImageMosaicReader)new ImageMosaicFormatFactory().createFormat().getReader((Object)mosaic);
        GeneralParameterValue[] params = new GeneralParameterValue[1];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        GridCoverage2D coverage = reader.read(params);
        byte[] result = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(1.0, 1.0);
        coverage.evaluate((DirectPosition)position, result);
        Assert.assertNotEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        Assert.assertEquals((long)0L, (long)result[2]);
        Assert.assertNotEquals((long)0L, (long)result[3]);
        position = new DirectPosition2D();
        position.setLocation(-1.0, -1.0);
        coverage.evaluate((DirectPosition)position, result);
        Assert.assertEquals((long)0L, (long)result[0]);
        Assert.assertEquals((long)0L, (long)result[1]);
        Assert.assertNotEquals((long)0L, (long)result[2]);
        Assert.assertNotEquals((long)0L, (long)result[3]);
        reader.dispose();
    }

    @Test
    public void testRasterFootprintExternal() throws Exception {
        File testMosaicRaster = new File(TestData.file((Object)this, (String)"."), "footprintRaster");
        if (testMosaicRaster.exists()) {
            FileUtils.deleteDirectory((File)testMosaicRaster);
        }
        GridCoverage2D coverage = this.readRasterFootprint("rastermask", testMosaicRaster, false);
        byte[] results = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(-86.724, 25.085);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-86.252, 27.7984);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-87.937, 26.144);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-89.084, 27.133);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-89.763, 25.167);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
    }

    @Test
    public void testRasterFootprintSubmsampling() throws Exception {
        File testMosaicRaster = new File(TestData.file((Object)this, (String)"."), "footprintRasterSubsampling");
        if (testMosaicRaster.exists()) {
            FileUtils.deleteDirectory((File)testMosaicRaster);
        }
        GridCoverage2D coverage = this.readRasterFootprint("masked2", testMosaicRaster, true);
        ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)coverage);
        Raster roiImage = roi.getAsImage().getData();
        Raster image = coverage.getRenderedImage().getData();
        int[] px = new int[4];
        int[] rpx = new int[1];
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                image.getPixel(j, i, px);
                roiImage.getPixel(j, i, rpx);
                if (px[0] == 0 && px[1] == 0 && px[2] == 0) {
                    Assert.assertEquals((String)("Difference at " + i + "," + j), (long)0L, (long)rpx[0]);
                    continue;
                }
                Assert.assertEquals((String)("Difference at " + i + "," + j), (long)1L, (long)rpx[0]);
            }
        }
    }

    @Test
    public void testRasterFootprintInternal() throws Exception {
        File testMosaicRaster = new File(TestData.file((Object)this, (String)"."), "footprintRaster");
        if (testMosaicRaster.exists()) {
            FileUtils.deleteDirectory((File)testMosaicRaster);
        }
        GridCoverage2D coverage = this.readRasterFootprint("rastermask2", testMosaicRaster, false);
        byte[] results = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(-86.724, 25.085);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-86.252, 27.7984);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-87.937, 26.144);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-89.084, 27.133);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-89.763, 25.167);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
    }

    @Test
    public void testRasterFootprintExternalMask() throws Exception {
        File testMosaicRaster = new File(TestData.file((Object)this, (String)"."), "footprintRaster");
        if (testMosaicRaster.exists()) {
            FileUtils.deleteDirectory((File)testMosaicRaster);
        }
        GridCoverage2D coverage = this.readRasterFootprint("rastermask", testMosaicRaster, true);
        byte[] results = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(-86.724, 25.085);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-86.252, 27.7984);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-87.937, 26.144);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-89.084, 27.133);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-89.763, 25.167);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
    }

    @Test
    public void testRasterFootprintInternalMaskAndOverviews() throws Exception {
        File testMosaicRaster = new File(TestData.file((Object)this, (String)"."), "footprintRaster");
        if (testMosaicRaster.exists()) {
            FileUtils.deleteDirectory((File)testMosaicRaster);
        }
        GridCoverage2D coverage = this.readRasterFootprint("rastermask2", testMosaicRaster, true);
        byte[] results = new byte[4];
        DirectPosition2D position = new DirectPosition2D();
        position.setLocation(-86.724, 25.085);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-86.252, 27.7984);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-87.937, 26.144);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
        position.setLocation(-89.084, 27.133);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertNotEquals((long)results[0], (long)0L);
        Assert.assertNotEquals((long)results[1], (long)0L);
        Assert.assertNotEquals((long)results[2], (long)0L);
        Assert.assertNotEquals((long)results[3], (long)0L);
        position.setLocation(-89.763, 25.167);
        results = coverage.evaluate((DirectPosition)position, results);
        Assert.assertEquals((long)results[0], (long)0L);
        Assert.assertEquals((long)results[1], (long)0L);
        Assert.assertEquals((long)results[2], (long)0L);
        Assert.assertEquals((long)results[3], (long)0L);
    }

    private GridCoverage2D readRasterFootprint(String path, File testMosaicRaster, boolean testOverviews) throws Exception {
        File mosaicSourceRaster = TestData.file((Object)this, (String)path);
        FileUtils.copyDirectory((File)mosaicSourceRaster, (File)testMosaicRaster);
        URL testMosaicRasterUrl = URLs.fileToUrl((File)testMosaicRaster);
        Properties p = new Properties();
        p.put("footprint_source", "raster");
        try (FileOutputStream fos = new FileOutputStream(new File(testMosaicRaster, "footprints.properties"));){
            p.store(fos, null);
        }
        AbstractGridFormat format = TestUtils.getFormat(testMosaicRasterUrl);
        ImageMosaicReader reader = TestUtils.getReader(testMosaicRasterUrl, format);
        GeneralParameterValue[] params = new GeneralParameterValue[3];
        ParameterValue footprintManagement = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintManagement.setValue((Object)FootprintBehavior.Transparent.name());
        params[0] = footprintManagement;
        ParameterValue jaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        jaiImageRead.setValue(false);
        params[1] = jaiImageRead;
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        if (testOverviews) {
            Dimension dim = new Dimension();
            dim.setSize(8, 8);
            rasterArea.setSize(dim);
            GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
            gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)reader.getOriginalEnvelope()));
            params[2] = gg;
        } else {
            GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
            gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem(), null));
            params[2] = gg;
        }
        GridCoverage2D coverage = reader.read(params);
        reader.dispose();
        Assert.assertNotNull((Object)coverage);
        ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)coverage);
        Assert.assertNotNull((Object)roi);
        Rectangle roiBounds = roi.getBounds();
        GridEnvelope2D imgBounds = coverage.getGridGeometry().getGridRange2D();
        Assert.assertEquals((long)imgBounds.x, (long)roiBounds.x);
        Assert.assertEquals((long)imgBounds.y, (long)roiBounds.y);
        Assert.assertEquals((long)imgBounds.width, (long)roiBounds.width);
        Assert.assertEquals((long)imgBounds.height, (long)roiBounds.height);
        return coverage;
    }

    @Test
    public void testFootprintWithBorderNeeded() throws IOException {
        File testFolder = this.redFootprintFolder.newFolder();
        File mosaic = TestData.file((Object)this, (String)"red_footprint_test");
        FileUtils.copyDirectory((File)mosaic, (File)testFolder);
        ImageMosaicReader reader = (ImageMosaicReader)new ImageMosaicFormatFactory().createFormat().getReader((Object)testFolder);
        ParameterValue footprintBehaviorParam = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintBehaviorParam.setValue((Object)FootprintBehavior.Transparent.name());
        ParameterValue readGeom = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        CoordinateReferenceSystem coordinateReferenceSystem = reader.getOriginalEnvelope().getCoordinateReferenceSystem();
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, 100, 100);
        ReferencedEnvelope requestEnvelope = new ReferencedEnvelope(989960.0, 990800.0, 217380.0, 219200.0, coordinateReferenceSystem);
        GridGeometry2D readGeometry = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)requestEnvelope);
        readGeom.setValue((Object)readGeometry);
        GeneralParameterValue[] readParams = new GeneralParameterValue[]{footprintBehaviorParam, readGeom};
        GridCoverage2D coverage = reader.read(readParams);
        int numComponents = coverage.getRenderedImage().getColorModel().getNumComponents();
        Assert.assertEquals((long)numComponents, (long)4L);
        reader.dispose();
    }

    @Test
    public void testCleanUpWkbFootprints() throws Exception {
        this.assertFootprintsCleanup("footprint_wkbs", WKBLoaderSPI.class.getName(), true, "_%d", f -> f.getName().startsWith("r1c1"), Utils.FF.like((Expression)Utils.FF.property("location"), "r1c1*"));
    }

    @Test
    public void testCleanUpWktFootprints() throws Exception {
        this.assertFootprintsCleanup("footprint_wkts", WKTLoaderSPI.class.getName(), true, "-%d", f -> f.getName().startsWith("r1c1"), Utils.FF.like((Expression)Utils.FF.property("location"), "r1c1*"));
    }

    @Test
    public void testCleanUpWktFootprintsAutoDetect() throws Exception {
        this.assertFootprintsCleanup("footprint_wkts", null, false, "-%d", f -> f.getName().startsWith("r1c1"), Utils.FF.like((Expression)Utils.FF.property("location"), "r1c1*"));
    }

    private void assertFootprintsCleanup(String footprint_wkbs, String name, boolean overviewsInRasterSpace, String overviewsSuffixFormat, FileFilter fileFilter, PropertyIsLike granuleFilter) throws IOException {
        ImageMosaicReader reader = this.getMultipleSidecarReader(footprint_wkbs, name, overviewsInRasterSpace, overviewsSuffixFormat);
        File directory = (File)reader.getSource();
        FileFilter notFileFilter = f -> !fileFilter.accept(f);
        File[] existingFiles = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFiles, (Matcher)Matchers.arrayWithSize((int)6));
        int otherFilesCount = directory.listFiles(notFileFilter).length;
        GranuleStore store = (GranuleStore)reader.getGranules(reader.getGridCoverageNames()[0], false);
        Hints hints = new Hints((RenderingHints.Key)Hints.GRANULE_REMOVAL_POLICY, (Object)GranuleRemovalPolicy.ALL);
        int removed = store.removeGranules((Filter)granuleFilter, hints);
        Assert.assertEquals((long)1L, (long)removed);
        File[] existingFilesPastCleanup = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFilesPastCleanup, (Matcher)Matchers.emptyArray());
        Assert.assertEquals((long)otherFilesCount, (long)directory.listFiles(notFileFilter).length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentWKBFootprintsLoading() throws Exception {
        WKBLoaderSPI loaderSPI = new WKBLoaderSPI();
        FootprintLoader loader = loaderSPI.createLoader();
        File newFolder = this.folder.newFolder();
        File footprintFile = TestData.file((Object)this, (String)"footprint_wkbs/r1c1.wkb");
        String footprintPath = footprintFile.getAbsolutePath();
        String fileName = FilenameUtils.getName((String)footprintPath);
        footprintPath = footprintPath.substring(0, footprintPath.length() - 4);
        Geometry footprint = loader.loadFootprint(footprintPath);
        int numberOfSamples = 60;
        String[] testFiles = new String[numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            String newName = fileName.replace("c1", String.format("c%03d", i));
            File ithFile = new File(newFolder, newName);
            FileUtils.copyFile((File)footprintFile, (File)ithFile);
            File ithFootprintFile = new File(newFolder, FilenameUtils.getBaseName((String)newName));
            testFiles[i] = ithFootprintFile.getAbsolutePath();
        }
        ExecutorService service = Executors.newFixedThreadPool(numberOfSamples / 2);
        CountDownLatch latch = new CountDownLatch(numberOfSamples);
        ArrayList geometries = new ArrayList(numberOfSamples);
        AtomicInteger errors = new AtomicInteger();
        try {
            int i = 0;
            while (i < numberOfSamples) {
                int finalI = i++;
                service.submit(() -> {
                    try {
                        geometries.add(loader.loadFootprint(testFiles[finalI]));
                    }
                    catch (Exception e) {
                        errors.getAndIncrement();
                    }
                    latch.countDown();
                });
            }
            latch.await();
        }
        finally {
            this.folder.delete();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
        for (Geometry geometry : geometries) {
            Assert.assertEquals((Object)geometry, (Object)footprint);
        }
    }
}

