/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.commons.io.FileUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultRepository;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.DecoratingDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.QueryCollectingFeatureSource;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class HeterogenousCRSTest {
    public static final double DELTA = 1.0E-6;
    @Rule
    public TemporaryFolder crsMosaicFolder = new TemporaryFolder();

    @BeforeClass
    public static void ignoreReciprocals() throws Exception {
        MapProjection.SKIP_SANITY_CHECKS = true;
    }

    @BeforeClass
    public static void resetReciprocals() throws Exception {
        MapProjection.SKIP_SANITY_CHECKS = false;
    }

    @AfterClass
    public static void cleanupCRS() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @BeforeClass
    public static void initCRS() {
        CRS.reset((String)"all");
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    @Ignore
    @Test
    public void testHeterogeneousCRS() throws IOException, URISyntaxException, TransformException, FactoryException {
        this.testMosaic("heterogeneous_crs", "location D, crs A", "red_blue_results/red_blue_heterogeneous_results.tiff", "EPSG:3587", new GeneralParameterValue[0]);
    }

    @Test
    public void testDiffCRSSorting() throws IOException, URISyntaxException {
        this.testMosaic("diff_crs_sorting_test", "resolution D, crs A", "diff_crs_sorting_test_results/results.tiff", "EPSG:32610", new GeneralParameterValue[0]);
    }

    @Test
    public void testWithInterpolation() throws IOException, URISyntaxException {
        ParameterValue interpolationParam = AbstractGridFormat.INTERPOLATION.createValue();
        interpolationParam.setValue((Object)Interpolation.getInstance((int)1));
        this.testMosaic("diff_crs_sorting_test", "resolution D, crs A", null, "EPSG:32610", new GeneralParameterValue[]{interpolationParam});
    }

    @Test
    public void testUpdatingMosaic() throws IOException, URISyntaxException {
        File second = TestData.file((Object)this, (String)"heterogeneous_crs/zblue.tiff");
        File indexer = TestData.file((Object)this, (String)"heterogeneous_crs/indexer.properties");
        File first = TestData.file((Object)this, (String)"heterogeneous_crs/red.tiff");
        File resultsImage = TestData.file((Object)this, (String)"red_blue_results/red_blue_update_test.tiff");
        File testStoreDirectory = this.crsMosaicFolder.newFolder("updateTest");
        FileUtils.copyFile((File)first, (File)new File(testStoreDirectory, first.getName()));
        FileUtils.copyFile((File)indexer, (File)new File(testStoreDirectory, indexer.getName()));
        ImageMosaicReader reader = new ImageMosaicReader((Object)testStoreDirectory);
        File sfdemDest = new File(testStoreDirectory, second.getName());
        FileUtils.copyFile((File)second, (File)sfdemDest);
        reader.harvest(null, (Object)sfdemDest, null);
        GridCoverage2D gc2d = reader.read(new GeneralParameterValue[0]);
        RenderedImage renderImage = gc2d.getRenderedImage();
        ImageAssert.assertEquals((File)resultsImage, (RenderedImage)renderImage, (int)1000);
        reader.dispose();
    }

    private void testMosaic(String testLocation, String sortOrder, String resultLocation, String expectedCRS, GeneralParameterValue ... params) throws URISyntaxException, IOException {
        ImageMosaicReader imReader = this.getTestMosaic(testLocation);
        Assert.assertEquals((Object)"true", (Object)imReader.getMetadataValue("MultiCRSReader"));
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)imReader.getCoordinateReferenceSystem()), (Object)expectedCRS);
        ArrayList<GeneralParameterValue> finalParamsCollection = new ArrayList<GeneralParameterValue>(Arrays.asList(params));
        ParameterValue sortByParam = ImageMosaicFormat.SORT_BY.createValue();
        sortByParam.setValue((Object)sortOrder);
        finalParamsCollection.add((GeneralParameterValue)sortByParam);
        GridCoverage2D gc2d = imReader.read(finalParamsCollection.toArray(new GeneralParameterValue[0]));
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)gc2d.getCoordinateReferenceSystem()), (Object)expectedCRS);
        if (resultLocation != null) {
            RenderedImage renderImage = gc2d.getRenderedImage();
            File resultsFile = this.testFile(resultLocation);
            ImageAssert.assertEquals((File)resultsFile, (RenderedImage)renderImage, (int)1000);
        }
        imReader.dispose();
    }

    private ImageMosaicReader getTestMosaic(String testLocation) throws URISyntaxException, IOException {
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        Hints creationHints = new Hints();
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, creationHints);
        Assert.assertNotNull((Object)imReader);
        return imReader;
    }

    @Test
    public void testHarvestHeteroUTM() throws Exception {
        File indexer = TestData.file((Object)this, (String)"hetero_utm/indexer.properties");
        File utm32n = TestData.file((Object)this, (String)"hetero_utm/utm32n.tiff");
        File utm33n = TestData.file((Object)this, (String)"hetero_utm/utm33n.tiff");
        File utm32s = TestData.file((Object)this, (String)"hetero_utm/utm32s.tiff");
        File utm33s = TestData.file((Object)this, (String)"hetero_utm/utm33s.tiff");
        File testStoreDirectory = this.crsMosaicFolder.newFolder("harvestHeteroUtm");
        FileUtils.copyFile((File)utm32n, (File)new File(testStoreDirectory, utm32n.getName()));
        FileUtils.copyFile((File)indexer, (File)new File(testStoreDirectory, indexer.getName()));
        ImageMosaicReader reader = new ImageMosaicReader((Object)testStoreDirectory);
        Assert.assertNotNull((Object)reader);
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 12.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.assertExpectedMosaic(reader, "hetero_utm_results/topleft.png", new GeneralParameterValue[0]);
        Assert.assertEquals((long)1L, (long)reader.harvest(null, (Object)utm33n, null).size());
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.assertExpectedMosaic(reader, "hetero_utm_results/top.png", new GeneralParameterValue[0]);
        Assert.assertEquals((long)1L, (long)reader.harvest(null, (Object)utm32s, null).size());
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.assertExpectedMosaic(reader, "hetero_utm_results/top_bottoleft.png", new GeneralParameterValue[0]);
        Assert.assertEquals((long)1L, (long)reader.harvest(null, (Object)utm33s, null).size());
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.assertExpectedMosaic(reader, "hetero_utm_results/full.png", new GeneralParameterValue[0]);
        reader.dispose();
    }

    @Test
    public void testHeteroUTM() throws Exception {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), imReader);
        String expectedResultLocation = "hetero_utm_results/full.png";
        this.assertExpectedMosaic(imReader, "hetero_utm_results/full.png", new GeneralParameterValue[0]);
        imReader.dispose();
    }

    @Test
    public void testHeteroBandSelection() throws Exception {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), imReader);
        ParameterValue bands = AbstractGridFormat.BANDS.createValue();
        bands.setValue((Object)new int[]{0, 0});
        GridCoverage2D coverage = imReader.read(new GeneralParameterValue[]{bands});
        Assert.assertNotNull((Object)coverage);
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertEquals((long)2L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((long)2L, (long)image.getColorModel().getNumComponents());
        Assert.assertEquals((long)2L, (long)image.getTile(0, 0).getNumBands());
        String fileSource = (String)coverage.getProperty("OriginalFileSource");
        MatcherAssert.assertThat((Object)fileSource, (Matcher)CoreMatchers.containsString((String)"utm32n.tiff"));
        MatcherAssert.assertThat((Object)fileSource, (Matcher)CoreMatchers.containsString((String)"utm32s.tiff"));
        MatcherAssert.assertThat((Object)fileSource, (Matcher)CoreMatchers.containsString((String)"utm33n.tiff"));
        MatcherAssert.assertThat((Object)fileSource, (Matcher)CoreMatchers.containsString((String)"utm33s.tiff"));
        coverage.dispose(true);
        imReader.dispose();
    }

    @Test
    public void testConcurrentHeteroUTMH2FullArea() throws Exception {
        this.runConcurrentHeteroUTMH2(r -> null);
    }

    @Test
    public void testConcurrentHeteroUTMH2Across() throws Exception {
        this.runConcurrentHeteroUTMH2(r -> {
            ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            GridEnvelope range = r.getOriginalGridRange();
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((Envelope)r.getOriginalEnvelope());
            bounds.translate(bounds.getWidth() / 2.0, 0.0);
            GridGeometry2D gg = new GridGeometry2D(range, (Envelope)bounds);
            ggp.setValue((Object)gg);
            return new GeneralParameterValue[]{ggp};
        });
    }

    @Test
    public void testConcurrentHeteroUTMH2NoGranules() throws Exception {
        this.runConcurrentHeteroUTMH2(r -> {
            ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
            filter.setValue((Object)Filter.EXCLUDE);
            return new GeneralParameterValue[]{filter};
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConcurrentHeteroUTMH2(Function<ImageMosaicReader, GeneralParameterValue[]> parameters) throws URISyntaxException, IOException, InterruptedException, ExecutionException, TimeoutException {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        File datastoreProperties = new File(testDirectory, "datastore.properties");
        try (FileWriter out = new FileWriter(datastoreProperties);){
            out.write("database=hetero_concurrent\n");
            out.write("SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nuser=gs\npasswd=gs\nConnection\\ timeout=3600\nmax \\connections=1min \\connections=1");
            out.flush();
        }
        ExecutorService executors = Executors.newFixedThreadPool(4);
        ImageMosaicReader reader = new ImageMosaicReader((Object)testDirectory, null);
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < 20; ++i) {
                Future future = executors.submit(() -> reader.read((GeneralParameterValue[])parameters.apply(reader)));
                futures.add(future);
            }
            for (Future future : futures) {
                future.get(120L, TimeUnit.SECONDS);
            }
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testHeteroSentinel2() throws Exception {
        String testLocation = "hetero_s2";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        String expectedResultLocation = "hetero_s2_results/overlap.png";
        ParameterValue inputTransparentColor = AbstractGridFormat.INPUT_TRANSPARENT_COLOR.createValue();
        inputTransparentColor.setValue((Object)Color.BLACK);
        ParameterValue outputTransparentColor = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.createValue();
        outputTransparentColor.setValue((Object)Color.BLACK);
        this.assertExpectedMosaic(imReader, "hetero_s2_results/overlap.png", new GeneralParameterValue[]{inputTransparentColor, outputTransparentColor});
        imReader.dispose();
    }

    @Test
    public void testHeteroSentinel2Filtered() throws Exception {
        String testLocation = "hetero_s2";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        ParameterValue inputTransparentColor = AbstractGridFormat.INPUT_TRANSPARENT_COLOR.createValue();
        inputTransparentColor.setValue((Object)Color.BLACK);
        ParameterValue outputTransparentColor = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.createValue();
        outputTransparentColor.setValue((Object)Color.BLACK);
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GridEnvelope2D range = new GridEnvelope2D(0, 0, 158, 103);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)range, (Envelope)new ReferencedEnvelope(11.6834779, 11.8616874, 47.6380806, 47.7542552, CRS.decode((String)"EPSG:4236", (boolean)true)));
        ggp.setValue((Object)gg);
        ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
        filter.setValue((Object)CQL.toFilter((String)"location = 'g1.tif'"));
        String expectedResultLocation = "hetero_s2_results/filtered.png";
        this.assertExpectedMosaic(imReader, "hetero_s2_results/filtered.png", new GeneralParameterValue[]{inputTransparentColor, outputTransparentColor, filter, ggp});
        imReader.dispose();
    }

    @Test
    public void testHeteroSentinel2Footprints() throws Exception {
        String testLocation = "hetero_s2_footprints";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        String expectedResultLocation = "hetero_s2_results/footprints.png";
        ParameterValue footprintBehavior = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintBehavior.setValue((Object)"Transparent");
        this.assertExpectedMosaic(imReader, "hetero_s2_results/footprints.png", new GeneralParameterValue[]{footprintBehavior});
        imReader.dispose();
    }

    @Test
    public void testHeteroUtmFootprintTransparency() throws Exception {
        String testLocation = "hetero_utm_footprint";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        String expectedResultLocation = "hetero_utm_footprint_results/footprints.png";
        ParameterValue footprintBehavior = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintBehavior.setValue((Object)"Transparent");
        ParameterValue sortBy = ImageMosaicFormat.SORT_BY.createValue();
        sortBy.setValue((Object)"location A");
        this.assertExpectedMosaic(imReader, "hetero_utm_footprint_results/footprints.png", new GeneralParameterValue[]{footprintBehavior, sortBy});
        imReader.dispose();
    }

    @Test
    public void testHeteroCRSDateline() throws IOException, URISyntaxException, TransformException, FactoryException {
        ImageMosaicReader imReader = this.getTestMosaic("hetero_crs_dateline");
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)imReader.getCoordinateReferenceSystem()), (Object)"EPSG:4326");
        GeneralParameterValue gg1 = this.buildGridGeometryParameter(new ReferencedEnvelope(179.0, 180.0, 60.0, 62.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 128, 256);
        GridCoverage2D gcBefore = imReader.read(new GeneralParameterValue[]{gg1});
        RenderedImage riBefore = gcBefore.getRenderedImage();
        ImageAssert.assertEquals((File)this.testFile("hetero_crs_dateline_results/before.png"), (RenderedImage)riBefore, (int)1000);
        GeneralParameterValue ggAfter = this.buildGridGeometryParameter(new ReferencedEnvelope(180.0, 181.0, 60.0, 62.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 128, 256);
        GridCoverage2D gcAfter = imReader.read(new GeneralParameterValue[]{ggAfter});
        RenderedImage riAfter = gcAfter.getRenderedImage();
        ImageAssert.assertEquals((File)this.testFile("hetero_crs_dateline_results/after.png"), (RenderedImage)riAfter, (int)1000);
        GranuleSource gs = imReader.getGranules(null, true);
        SimpleFeatureCollection granules = gs.getGranules(Query.ALL);
        try (SimpleFeatureIterator fi = granules.features();){
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                Geometry geom = (Geometry)sf.getDefaultGeometry();
                Assert.assertTrue((String)geom.toText(), (geom.getEnvelopeInternal().getWidth() < 3.0 ? 1 : 0) != 0);
            }
        }
        imReader.dispose();
    }

    @Test
    public void testHeteroCRSRasterMask() throws IOException, URISyntaxException, TransformException, FactoryException {
        URL storeUrl = TestData.url((Object)this, (String)"rastermask2");
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder("hetero_crs_rastermask");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        String indexer = "GranuleAcceptors=org.geotools.gce.imagemosaic.acceptors.HeterogeneousCRSAcceptorFactory\nGranuleHandler=org.geotools.gce.imagemosaic.granulehandler.ReprojectingGranuleHandlerFactory\nHeterogeneousCRS=true\nMosaicCRS=EPSG\\:3857\nSchema=*the_geom:Polygon,location:String,crs:String";
        FileUtils.writeStringToFile((File)new File(testDirectory, "indexer.properties"), (String)indexer, (String)"UTF-8");
        String footprints = "footprint_source=raster";
        FileUtils.writeStringToFile((File)new File(testDirectory, "footprints.properties"), (String)footprints, (String)"UTF-8");
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, new Hints());
        Assert.assertNotNull((Object)imReader);
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)imReader.getCoordinateReferenceSystem()), (Object)"EPSG:3857");
        ParameterValue footprintParam = AbstractGridFormat.FOOTPRINT_BEHAVIOR.createValue();
        footprintParam.setValue((Object)"Transparent");
        GridCoverage2D coverage = imReader.read(new GeneralParameterValue[]{footprintParam});
        Assert.assertNotNull((Object)coverage);
        ImageAssert.assertEquals((File)this.testFile("hetero_crs_rastermask.png"), (RenderedImage)coverage.getRenderedImage(), (int)1000);
        imReader.dispose();
    }

    GeneralParameterValue buildGridGeometryParameter(ReferencedEnvelope envelope, int width, int height) {
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GridEnvelope2D range = new GridEnvelope2D(0, 0, width, height);
        GridGeometry2D value = new GridGeometry2D((GridEnvelope)range, (Envelope)envelope);
        gg.setValue((Object)value);
        return gg;
    }

    private void assertExpectedBounds(ReferencedEnvelope expected, ImageMosaicReader imReader) {
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)imReader.getCoordinateReferenceSystem(), (Object)expected.getCoordinateReferenceSystem()));
        double EPS = 0.004545454545454545;
        GeneralEnvelope envelope = imReader.getOriginalEnvelope();
        Assert.assertEquals((double)expected.getMinX(), (double)envelope.getMinimum(0), (double)EPS);
        Assert.assertEquals((double)expected.getMaxX(), (double)envelope.getMaximum(0), (double)EPS);
        Assert.assertEquals((double)expected.getMinY(), (double)envelope.getMinimum(1), (double)EPS);
        Assert.assertEquals((double)expected.getMaxY(), (double)envelope.getMaximum(1), (double)EPS);
    }

    private void assertExpectedMosaic(ImageMosaicReader imReader, String expectedResultLocation, GeneralParameterValue ... params) throws IOException {
        GridCoverage2D coverage = imReader.read(params);
        File resultsFile = this.testFile(expectedResultLocation);
        RenderedImage image = coverage.getRenderedImage();
        ImageAssert.assertEquals((File)resultsFile, (RenderedImage)image, (int)1000);
        coverage.dispose(true);
    }

    File testFile(String name) {
        return new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/" + name);
    }

    @Test
    public void testCrsResolutionDomains() throws Exception {
        ImageMosaicReader reader = this.getTestMosaic("diff_crs_sorting_test");
        String coverageName = reader.getGridCoverageNames()[0];
        Map<String, DimensionDescriptor> descriptors = reader.getDimensionDescriptors(coverageName).stream().collect(Collectors.toMap(dd -> dd.getName(), dd -> dd));
        Assert.assertEquals((long)4L, (long)descriptors.size());
        DimensionDescriptor crsDescriptor = descriptors.get("crs");
        Assert.assertNotNull((Object)crsDescriptor);
        Assert.assertEquals((Object)"crs", (Object)crsDescriptor.getStartAttribute());
        DimensionDescriptor resolutionDescriptor = descriptors.get("resolution");
        Assert.assertNotNull((Object)resolutionDescriptor);
        Assert.assertEquals((Object)"resolution", (Object)resolutionDescriptor.getStartAttribute());
        DimensionDescriptor resolutionXDescriptor = descriptors.get("resolution_x");
        Assert.assertNotNull((Object)resolutionXDescriptor);
        Assert.assertEquals((Object)"resX", (Object)resolutionXDescriptor.getStartAttribute());
        DimensionDescriptor resolutionYDescriptor = descriptors.get("resolution_y");
        Assert.assertNotNull((Object)resolutionYDescriptor);
        Assert.assertEquals((Object)"resY", (Object)resolutionYDescriptor.getStartAttribute());
        GranuleSource granules = reader.getGranules(coverageName, true);
        SimpleFeatureCollection features = granules.getGranules(Query.ALL);
        List featureList = DataUtilities.list((FeatureCollection)features);
        for (SimpleFeature sf : featureList) {
            String location = (String)sf.getAttribute("location");
            String crs = (String)sf.getAttribute("crs");
            Assert.assertEquals((Object)"EPSG:32610", (Object)crs);
            Double resolution = (Double)sf.getAttribute("resolution");
            Double resX = (Double)sf.getAttribute("resolution");
            Double resY = (Double)sf.getAttribute("resolution");
            if (location.startsWith("32km")) {
                Assert.assertEquals((double)17550.0, (double)resolution, (double)10.0);
                Assert.assertEquals((double)17550.0, (double)resX, (double)10.0);
                Assert.assertEquals((double)17550.0, (double)resY, (double)10.0);
                continue;
            }
            if (!location.startsWith("16km")) continue;
            Assert.assertEquals((double)8712.0, (double)resolution, (double)10.0);
            Assert.assertEquals((double)8712.0, (double)resX, (double)10.0);
            Assert.assertEquals((double)8712.0, (double)resY, (double)10.0);
        }
        reader.dispose();
    }

    @Test
    public void testExistingSchemaWithCrsAttribute() throws Exception {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        GridCoverage2D coverage = imReader.read(null);
        if (coverage.getRenderedImage() instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)coverage.getRenderedImage()));
        }
        coverage.dispose(true);
        imReader.dispose();
        try (FileWriter out = new FileWriter(new File(testDirectory, "hetero_utm.properties"), true);){
            out.write("UseExistingSchema=true\n");
            out.write("CrsAttribute=crs\n");
            out.flush();
        }
        imReader = new ImageMosaicReader((Object)testDirectory, null);
        imReader.dispose();
    }

    @Test
    public void testHeteroExternalOverviews() throws Exception {
        String testLocation = "hetero_s2_ovr";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        List<String> filesNativeRes = this.getSourceFilesForParams(imReader, new GeneralParameterValue[0]);
        MatcherAssert.assertThat(filesNativeRes, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"g1.tif", "g2.tif", "g4.tif", "g3.tif"}));
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GridEnvelope originalRange = imReader.getOriginalGridRange();
        GridEnvelope2D readRange = new GridEnvelope2D(0, 0, originalRange.getSpan(0) / 4, originalRange.getSpan(1) / 4);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)readRange, (Envelope)imReader.getOriginalEnvelope());
        ggp.setValue((Object)gg);
        List<String> filesExtOvr = this.getSourceFilesForParams(imReader, new GeneralParameterValue[]{ggp});
        MatcherAssert.assertThat(filesExtOvr, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"g1.tif.ovr", "g2.tif.ovr", "g4.tif.ovr", "g3.tif.ovr"}));
        imReader.dispose();
    }

    public List<String> getSourceFilesForParams(ImageMosaicReader imReader, GeneralParameterValue ... params) throws IOException {
        GridCoverage2D coverage = imReader.read(params);
        RenderedImage ri = coverage.getRenderedImage();
        return this.getInputFileNames(ri);
    }

    private List<String> getInputFileNames(RenderedImage inputImage) {
        ArrayList<String> files = new ArrayList<String>();
        if (inputImage instanceof PlanarImage) {
            PlanarImage planarImage = (PlanarImage)inputImage;
            int nSources = planarImage.getNumSources();
            if (nSources > 0) {
                for (int k = 0; k < nSources; ++k) {
                    Object source = null;
                    try {
                        source = planarImage.getSourceObject(k);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (source == null || !(source instanceof PlanarImage)) continue;
                    List<String> piFiles = this.getInputFileNames((RenderedImage)source);
                    files.addAll(piFiles);
                }
            } else {
                ImageReader reader;
                ImageInputStream stream;
                Object imageReader = inputImage.getProperty("JAI.ImageReader");
                if (imageReader != null && imageReader instanceof ImageReader && (stream = (ImageInputStream)(reader = (ImageReader)imageReader).getInput()) instanceof FileImageInputStreamExtImpl) {
                    FileImageInputStreamExtImpl fis = (FileImageInputStreamExtImpl)stream;
                    File file = fis.getFile();
                    files.add(file.getName());
                }
            }
        }
        return files;
    }

    @Test
    public void testHeterogeneousCRSReadInGranulesCRS() throws Exception {
        String testLocation = "heterogeneous_crs_2";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        CoordinateReferenceSystem utmZone32N = CRS.decode((String)"EPSG:32632", (boolean)true);
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{150000.0, 600000.0}, new double[]{850000.0, 1200000.0});
        envelope.setCoordinateReferenceSystem(utmZone32N);
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, 700, 600);
        GridGeometry2D readingGridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)envelope);
        ParameterValue ggParam = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggParam.setValue((Object)readingGridGeometry);
        GridCoverage2D gc = imReader.read(new GeneralParameterValue[]{ggParam});
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)wgs84, (Object)gc.getCoordinateReferenceSystem()));
        RenderedImage ri = gc.getRenderedImage();
        HashMap<String, Set<RenderedOp>> operationsGroups = new HashMap<String, Set<RenderedOp>>();
        this.groupOperations(ri, operationsGroups);
        Set imageReads = (Set)operationsGroups.get("ImageRead");
        int granulesRead = imageReads.size();
        Assert.assertEquals((long)3L, (long)granulesRead);
        Assert.assertEquals((long)granulesRead, (long)((Set)operationsGroups.get("Warp")).size());
        gc.dispose(true);
        String epsgCodes = imReader.getMetadataValue("MultiCRSEPSGCodes");
        Assert.assertTrue((boolean)epsgCodes.contains("EPSG:32632"));
        Assert.assertTrue((boolean)Utils.isSupportedCRS((GridCoverage2DReader)imReader, (CoordinateReferenceSystem)utmZone32N));
        ParameterValue useAlternativeCRS = ImageMosaicFormat.OUTPUT_TO_ALTERNATIVE_CRS.createValue();
        useAlternativeCRS.setValue(true);
        gc = imReader.read(new GeneralParameterValue[]{ggParam, useAlternativeCRS});
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)utmZone32N, (Object)gc.getCoordinateReferenceSystem()));
        MathTransform transform = gc.getGridGeometry().getGridToCRS();
        AffineTransform tx = (AffineTransform)transform;
        Assert.assertEquals((double)1000.0, (double)XAffineTransform.getScaleX0((AffineTransform)tx), (double)1.0E-6);
        Assert.assertEquals((double)1000.0, (double)XAffineTransform.getScaleY0((AffineTransform)tx), (double)1.0E-6);
        ri = gc.getRenderedImage();
        operationsGroups.clear();
        this.groupOperations(ri, operationsGroups);
        imageReads = (Set)operationsGroups.get("ImageRead");
        Set warps = (Set)operationsGroups.get("Warp");
        granulesRead = imageReads.size();
        Assert.assertEquals((long)3L, (long)granulesRead);
        Assert.assertEquals((long)2L, (long)warps.size());
        for (RenderedOp warp : warps) {
            this.removeImagesBeingWarped(warp, imageReads);
        }
        Assert.assertEquals((long)1L, (long)imageReads.size());
        RenderedOp unwarpedImage = (RenderedOp)imageReads.iterator().next();
        ParameterBlock block = unwarpedImage.getParameterBlock();
        Vector<Object> paramValues = block.getParameters();
        Assert.assertTrue((boolean)((FileImageInputStreamExtImpl)paramValues.get(0)).getFile().getAbsolutePath().contains("green.tif"));
        imReader.dispose();
    }

    private void removeImagesBeingWarped(RenderedOp image, Set<RenderedOp> imageReads) {
        Vector sources = image.getSources();
        for (Object source : sources) {
            if (!(source instanceof RenderedOp)) continue;
            RenderedOp op = (RenderedOp)source;
            String opName = op.getOperationName();
            if (opName.equalsIgnoreCase("ImageRead")) {
                imageReads.remove(op);
                return;
            }
            this.removeImagesBeingWarped(op, imageReads);
        }
    }

    private void groupOperations(Object ri, Map<String, Set<RenderedOp>> operationsSet) {
        if (ri instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)ri;
            String opName = op.getOperationName();
            Set<RenderedOp> set = operationsSet.get(opName);
            if (set == null) {
                set = new HashSet<RenderedOp>();
            }
            set.add(op);
            operationsSet.put(opName, set);
            Vector sources = op.getSources();
            for (Object source : sources) {
                this.groupOperations(source, operationsSet);
            }
            return;
        }
    }

    @Test
    public void testNativeEnvelope() throws Exception {
        String testLocation = "heterogeneous_crs_2";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        GranuleSource source = imReader.getGranules(imReader.getGridCoverageNames()[0], true);
        SimpleFeatureCollection fc = source.getGranules(Query.ALL);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                MatcherAssert.assertThat((Object)f.getUserData(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"nativeBounds")));
            }
        }
        Query q = new Query();
        q.getHints().put((Object)GranuleSource.NATIVE_BOUNDS, (Object)true);
        SimpleFeatureCollection fcb = source.getGranules(q);
        try (SimpleFeatureIterator fi = fcb.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                MatcherAssert.assertThat((Object)f.getUserData(), (Matcher)Matchers.hasKey((Object)"nativeBounds"));
                String crs = (String)f.getAttribute("crs");
                ReferencedEnvelope envelope = (ReferencedEnvelope)f.getUserData().get("nativeBounds");
                Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)crs, (boolean)true), (Object)envelope.getCoordinateReferenceSystem()));
            }
        }
    }

    @Test
    public void testHeteroSentinel2DryRun() throws Exception {
        String testLocation = "hetero_s2";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        imReader.dispose();
        String TEST_STORE = "testStore";
        File dsProperties = new File(testDirectory, "datastore.properties");
        Properties properties = new Properties();
        properties.put("StoreName", "testStore");
        try (FileOutputStream fos = new FileOutputStream(dsProperties);){
            properties.store(fos, null);
        }
        URL shapefileURL = URLs.fileToUrl((File)new File(testDirectory, "hetero_s2.shp"));
        ShapefileDataStore ds = new ShapefileDataStore(shapefileURL);
        final ArrayList queries = new ArrayList();
        final AtomicBoolean recordQueries = new AtomicBoolean(false);
        DecoratingDataStore decoratingStore = new DecoratingDataStore((DataStore)ds){

            public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
                SimpleFeatureSource source = super.getFeatureSource(typeName);
                if (recordQueries.get()) {
                    return new QueryCollectingFeatureSource(source, queries);
                }
                return source;
            }
        };
        DefaultRepository repository = new DefaultRepository();
        repository.register("testStore", (DataAccess)decoratingStore);
        ImageMosaicReader repoReader = new ImageMosaicReader((Object)testDirectory, new Hints((RenderingHints.Key)Hints.REPOSITORY, (Object)repository));
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GridEnvelope2D range = new GridEnvelope2D(0, 0, 158, 103);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)range, (Envelope)new ReferencedEnvelope(11.6834779, 11.8616874, 47.6380806, 47.7542552, CRS.decode((String)"EPSG:4236", (boolean)true)));
        ggp.setValue((Object)gg);
        ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
        filter.setValue((Object)CQL.toFilter((String)"location = 'IAmNotThere.tif'"));
        recordQueries.set(true);
        GridCoverage2D coverage = repoReader.read(new GeneralParameterValue[]{ggp, filter});
        recordQueries.set(false);
        if (coverage != null) {
            coverage.dispose(true);
        }
        repoReader.dispose();
        repository.dataStore("testStore").dispose();
        int size = queries.size();
        Query dryRunQuery = (Query)queries.get(size - 1);
        Assert.assertNull((Object)dryRunQuery.getSortBy());
        MatcherAssert.assertThat((Object)dryRunQuery.getFilter(), (Matcher)Matchers.instanceOf(BBOX.class));
        Query dataQuery = (Query)queries.get(size - 2);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Assert.assertArrayEquals((Object[])new SortBy[]{ff.sort("crs", SortOrder.ASCENDING)}, (Object[])dataQuery.getSortBy());
        MatcherAssert.assertThat((Object)dataQuery.getFilter(), (Matcher)Matchers.instanceOf(And.class));
    }

    @Test
    public void testHeteroPropertySelection() throws Exception {
        String testLocation = "hetero_utm";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = this.crsMosaicFolder.newFolder(testLocation);
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        File indexerFile = new File(testDirectory, "indexer.properties");
        Properties props = new Properties();
        try (FileReader in = new FileReader(indexerFile);){
            props.load(in);
        }
        props.put("PropertySelection", "true");
        try (FileWriter out = new FileWriter(indexerFile);){
            props.store(out, null);
        }
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        this.assertExpectedBounds(new ReferencedEnvelope(11.0, 13.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), imReader);
        String expectedResultLocation = "hetero_utm_results/full.png";
        this.assertExpectedMosaic(imReader, "hetero_utm_results/full.png", new GeneralParameterValue[0]);
        RasterManager rm = imReader.getRasterManager("hetero_utm");
        Assert.assertTrue((boolean)rm.getConfiguration().getCatalogConfigurationBean().isPropertySelectionEnabled());
        GranuleCatalog catalog = rm.getGranuleCatalog();
        catalog.getGranuleDescriptors(new Query("hetero_utm"), (granule, feature) -> {
            Assert.assertNotNull((Object)feature.getProperty("crs"));
            Assert.assertNotNull((Object)granule.getOriginator().getProperty("crs"));
        });
        imReader.dispose();
    }
}

