/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.wkt.Parser;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class GranuleTest
extends Assert {
    private static final double DELTA = 1.0E-5;
    private static final double DELTASCALE = 0.1;
    private static CoordinateReferenceSystem WGS84;
    private static final ReferencedEnvelope TEST_BBOX;
    private static final ImageReaderSpi spi;
    static final String NZTM_WKT_NE = "PROJCS[\"NZGD2000 / New Zealand Transverse Mercator 2000\", \n  GEOGCS[\"NZGD2000\", \n    DATUM[\"New Zealand Geodetic Datum 2000\", \n      SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]], \n      TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], \n      AUTHORITY[\"EPSG\",\"6167\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AXIS[\"Geodetic longitude\", EAST], \n    AUTHORITY[\"EPSG\",\"4167\"]], \n  PROJECTION[\"Transverse_Mercator\", AUTHORITY[\"EPSG\",\"9807\"]], \n  PARAMETER[\"central_meridian\", 173.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"scale_factor\", 0.9996], \n  PARAMETER[\"false_easting\", 1600000.0], \n  PARAMETER[\"false_northing\", 10000000.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Northing\", NORTH], \n  AXIS[\"Easting\", EAST], \n  AUTHORITY[\"EPSG\",\"2193\"]]";
    static final String NZTM_WKT_EN = "PROJCS[\"NZGD2000 / New Zealand Transverse Mercator 2000\", \n  GEOGCS[\"NZGD2000\", \n    DATUM[\"New Zealand Geodetic Datum 2000\", \n      SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]], \n      TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], \n      AUTHORITY[\"EPSG\",\"6167\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic longitude\", EAST], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AUTHORITY[\"EPSG\",\"4167\"]], \n  PROJECTION[\"Transverse_Mercator\"], \n  PARAMETER[\"central_meridian\", 173.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"scale_factor\", 0.9996], \n  PARAMETER[\"false_easting\", 1600000.0], \n  PARAMETER[\"false_northing\", 10000000.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH], \n  AUTHORITY[\"EPSG\",\"2193\"]]";

    @Test
    public void testGranuleLevels() throws FileNotFoundException, IOException {
        URL testUrl = TestData.url((Object)((Object)this), (String)"/overview/0/D220161A.tif");
        testUrl.openStream().close();
        GranuleDescriptor granuleDescriptor = new GranuleDescriptor(URLs.urlToFile((URL)testUrl).getAbsolutePath(), (BoundingBox)TEST_BBOX, null, spi, null, null);
        GranuleTest.assertNotNull((Object)granuleDescriptor.toString());
        GranuleDescriptor.GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor = granuleDescriptor.getLevel(2);
        GranuleTest.assertNotNull((Object)granuleOverviewLevelDescriptor);
        int h = granuleOverviewLevelDescriptor.getHeight();
        int w = granuleOverviewLevelDescriptor.getWidth();
        GranuleTest.assertEquals((long)47L, (long)h);
        GranuleTest.assertEquals((long)35L, (long)w);
        double scaleX = granuleOverviewLevelDescriptor.getScaleX();
        double scaleY = granuleOverviewLevelDescriptor.getScaleY();
        GranuleTest.assertEquals((String)"ScaleX not equal", (double)scaleX, (double)4.0, (double)0.1);
        GranuleTest.assertEquals((String)"ScaleY not equal", (double)scaleY, (double)3.9788, (double)0.1);
        Rectangle rect = granuleOverviewLevelDescriptor.getBounds();
        GranuleTest.assertEquals((long)rect.x, (long)0L);
        GranuleTest.assertEquals((long)rect.y, (long)0L);
        GranuleTest.assertEquals((long)rect.width, (long)35L);
        GranuleTest.assertEquals((long)rect.height, (long)47L);
        AffineTransform btlTransform = granuleOverviewLevelDescriptor.getBaseToLevelTransform();
        double[] baseMatrix = new double[6];
        btlTransform.getMatrix(baseMatrix);
        GranuleTest.assertEquals((String)"m00 not equal", (double)baseMatrix[0], (double)4.0, (double)0.1);
        GranuleTest.assertEquals((String)"m10 not equal", (double)baseMatrix[1], (double)0.0, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m01 not equal", (double)baseMatrix[2], (double)0.0, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m11 not equal", (double)baseMatrix[3], (double)3.9788, (double)0.1);
        GranuleTest.assertEquals((String)"m02 not equal", (double)baseMatrix[4], (double)0.0, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m12 not equal", (double)baseMatrix[5], (double)0.0, (double)1.0E-5);
        AffineTransform2D g2wtTransform = granuleOverviewLevelDescriptor.getGridToWorldTransform();
        double[] g2wMatrix = new double[6];
        g2wtTransform.getMatrix(g2wMatrix);
        GranuleTest.assertEquals((String)"m00 not equal", (double)g2wMatrix[0], (double)0.08276290425318347, (double)0.1);
        GranuleTest.assertEquals((String)"m10 not equal", (double)g2wMatrix[1], (double)0.0, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m01 not equal", (double)g2wMatrix[2], (double)0.0, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m11 not equal", (double)g2wMatrix[3], (double)-0.04297444746040424, (double)0.1);
        GranuleTest.assertEquals((String)"m02 not equal", (double)g2wMatrix[4], (double)12.139578206197234, (double)1.0E-5);
        GranuleTest.assertEquals((String)"m12 not equal", (double)g2wMatrix[5], (double)42.5511689138571, (double)1.0E-5);
    }

    @Test
    public void testLoadRaster() throws FileNotFoundException, IOException, NoninvertibleTransformException {
        File testMosaic = TestData.file((Object)((Object)this), (String)"/rgb");
        GranuleTest.assertTrue((boolean)testMosaic.exists());
        URL testUrl = TestData.url((Object)((Object)this), (String)"/rgb/global_mosaic_12.png");
        testUrl.openStream().close();
        GranuleDescriptor granuleDescriptor = new GranuleDescriptor(URLs.urlToFile((URL)testUrl).getAbsolutePath(), (BoundingBox)TEST_BBOX, null, spi, null, null);
        GranuleDescriptor.GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor = granuleDescriptor.getLevel(0);
        GranuleTest.assertNotNull((Object)granuleOverviewLevelDescriptor);
        Hints crsHints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)DefaultGeographicCRS.WGS84);
        ImageMosaicReader reader = new ImageMosaicFormat().getReader((Object)testMosaic, crsHints);
        GranuleTest.assertNotNull((Object)reader);
        RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"10,10");
        RasterLayerRequest request = new RasterLayerRequest(new GeneralParameterValue[]{useJai, tileSize}, manager);
        ImageReadParam readParameters = new ImageReadParam();
        readParameters.setSourceRegion(new Rectangle(0, 0, 50, 50));
        AffineTransform2D gridToWorldTransform = granuleOverviewLevelDescriptor.getGridToWorldTransform();
        ImageLayout layout = new ImageLayout2().setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(10).setTileWidth(10);
        RenderingHints rHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        Hints hints = new Hints(rHints);
        RenderedImage raster = granuleDescriptor.loadRaster(readParameters, 0, TEST_BBOX, gridToWorldTransform.inverse(), request, hints).getRaster();
        GranuleTest.assertEquals((long)raster.getWidth(), (long)50L);
        GranuleTest.assertEquals((long)raster.getHeight(), (long)50L);
        AffineTransform translate = new AffineTransform((AffineTransform)gridToWorldTransform);
        translate.preConcatenate(AffineTransform.getTranslateInstance(2.0, 2.0));
        RenderedImage translatedRaster = granuleDescriptor.loadRaster(readParameters, 0, TEST_BBOX, new AffineTransform2D(translate).inverse(), request, hints).getRaster();
        GranuleTest.assertEquals((long)translatedRaster.getWidth(), (long)50L);
        GranuleTest.assertEquals((long)translatedRaster.getHeight(), (long)50L);
        reader.dispose();
    }

    @Test
    public void testCRS_NorthingEasting() throws Exception {
        ReferencedEnvelope mosaicBounds;
        File testMosaic = TestData.file((Object)((Object)this), (String)"/crs_nztm");
        GranuleTest.assertTrue((boolean)testMosaic.exists());
        Parser parser = new Parser();
        DefaultProjectedCRS crs_EN = (DefaultProjectedCRS)parser.parseObject(NZTM_WKT_EN);
        DefaultProjectedCRS crs_NE = (DefaultProjectedCRS)parser.parseObject(NZTM_WKT_NE);
        ImageMosaicReader reader = new ImageMosaicFormat().getReader((Object)testMosaic);
        GranuleTest.assertNotNull((Object)reader);
        RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
        manager.spatialDomainManager.coverageBBox = mosaicBounds = new ReferencedEnvelope(1587997.8835, 1612003.2265, 6162000.4515, 6198002.1165, (CoordinateReferenceSystem)crs_EN);
        manager.spatialDomainManager.coverageEnvelope = new GeneralEnvelope((Envelope)mosaicBounds);
        ReferencedEnvelope requestBBoxNE = new ReferencedEnvelope(6154440.101350001, 6204842.43235, 1583436.86902, 1617044.34782, (CoordinateReferenceSystem)crs_NE);
        ParameterValue requestedBBox = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        requestedBBox.setValue((Object)new GridGeometry2D(PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), (Envelope)requestBBoxNE, null));
        RasterLayerRequest requestNE = new RasterLayerRequest(new GeneralParameterValue[]{requestedBBox}, manager);
        BoundingBox checkCropBBox = requestNE.spatialRequestHelper.getComputedBBox();
        GranuleTest.assertNotNull((Object)checkCropBBox);
        GranuleTest.assertEquals((double)1587997.8835, (double)checkCropBBox.getMinimum(0), (double)1.0E-4);
        GranuleTest.assertEquals((double)1612003.2265, (double)checkCropBBox.getMaximum(0), (double)1.0E-4);
        GranuleTest.assertEquals((double)6162000.4515, (double)checkCropBBox.getMinimum(1), (double)1.0E-4);
        GranuleTest.assertEquals((double)6198002.1165, (double)checkCropBBox.getMaximum(1), (double)1.0E-4);
        ReferencedEnvelope requestBBoxEN = new ReferencedEnvelope(1583436.86902, 1617044.34782, 6154440.101350001, 6204842.43235, (CoordinateReferenceSystem)crs_EN);
        requestedBBox.setValue((Object)new GridGeometry2D(PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), (Envelope)requestBBoxEN, null));
        RasterLayerRequest requestEN = new RasterLayerRequest(new GeneralParameterValue[]{requestedBBox}, manager);
        checkCropBBox = requestEN.spatialRequestHelper.getComputedBBox();
        GranuleTest.assertNotNull((Object)checkCropBBox);
        GranuleTest.assertEquals((double)1587997.8835, (double)checkCropBBox.getMinimum(0), (double)1.0E-4);
        GranuleTest.assertEquals((double)1612003.2265, (double)checkCropBBox.getMaximum(0), (double)1.0E-4);
        GranuleTest.assertEquals((double)6162000.4515, (double)checkCropBBox.getMinimum(1), (double)1.0E-4);
        GranuleTest.assertEquals((double)6198002.1165, (double)checkCropBBox.getMaximum(1), (double)1.0E-4);
        reader.dispose();
    }

    static {
        try {
            WGS84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (FactoryException fe) {
            WGS84 = DefaultGeographicCRS.WGS84;
        }
        TEST_BBOX = new ReferencedEnvelope(12.139578206197234, 15.036279855058655, 40.5313698832181, 42.5511689138571, WGS84);
        spi = new TIFFImageReaderSpi();
    }
}

