/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.gce.imagemosaic.FootprintsTransformation;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.test.TestData;
import org.geotools.util.NumberRange;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FootprintsTransformationTest {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    static final FootprintsTransformation TX = new FootprintsTransformation();

    @Test
    public void lookupTest() {
        Function footprints = FF.function("footprints", new Expression[0]);
        Assert.assertNotNull((Object)footprints);
        MatcherAssert.assertThat((Object)footprints, (Matcher)CoreMatchers.instanceOf(FootprintsTransformation.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidArgument() throws Exception {
        FootprintsTransformation tx = new FootprintsTransformation();
        tx.evaluate(new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoundingBox() throws Exception {
        URL rgbURL = TestData.url((Object)this, (String)"rgb");
        AbstractGridFormat format = TestUtils.getFormat(rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(rgbURL, format);
        try {
            ReferencedEnvelope re = new ReferencedEnvelope(9.25, 12.0, 42.56, 44.57, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            gg.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 50, 50), (Envelope)re));
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{gg});
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
            Assert.assertEquals((long)2L, (long)schema.getAttributeCount());
            Assert.assertEquals(MultiPolygon.class, this.getBinding(schema, "the_geom"));
            Assert.assertEquals(String.class, this.getBinding(schema, "location"));
            Assert.assertEquals((long)1L, (long)fc.size());
            SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
            Assert.assertEquals((Object)"global_mosaic_16.png", (Object)first.getAttribute("location"));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSortMaxTiles() throws Exception {
        URL rgbURL = TestData.url((Object)this, (String)"rgb");
        AbstractGridFormat format = TestUtils.getFormat(rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(rgbURL, format);
        try {
            this.assertOneGranuleSort(reader, "location A", "global_mosaic_0.png");
            this.assertOneGranuleSort(reader, "location D", "global_mosaic_9.png");
        }
        finally {
            reader.dispose();
        }
    }

    private void assertOneGranuleSort(ImageMosaicReader reader, String sortValue, String expectedLocation) {
        ParameterValue sort = ImageMosaicFormat.SORT_BY.createValue();
        sort.setValue((Object)sortValue);
        ParameterValue maxTiles = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
        maxTiles.setValue(1);
        CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{sort, maxTiles});
        SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Assert.assertEquals((Object)expectedLocation, (Object)first.getAttribute("location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCQLFilter() throws Exception {
        URL timeElevURL = this.setupWaterTemp("watertemp-cql");
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        try {
            ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
            filter.setValue((Object)CQL.toFilter((String)"elevation = 0 and ingestion TEQUALS 2008-11-01T00:00:00Z"));
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{filter});
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)1L, (long)fc.size());
            SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
            Assert.assertEquals((Object)"NCOM_wattemp_000_20081101T0000000_12.tiff", (Object)first.getAttribute("location"));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeElevation() throws Exception {
        URL timeElevURL = this.setupWaterTemp("watertemp-time-elev");
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        try {
            ParameterValue time = ImageMosaicFormat.TIME.createValue();
            time.setValue(Arrays.asList(this.parseISO("2008-11-01T00:00:00Z")));
            ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
            elevation.setValue(Arrays.asList(0));
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{time, elevation});
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)1L, (long)fc.size());
            SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
            Assert.assertEquals((Object)"NCOM_wattemp_000_20081101T0000000_12.tiff", (Object)first.getAttribute("location"));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeRange() throws Exception {
        URL ranges_customdims = TestData.url((Object)this, (String)"time_domainsRanges");
        AbstractGridFormat format = TestUtils.getFormat(ranges_customdims);
        ImageMosaicReader reader = TestUtils.getReader(ranges_customdims, format);
        try {
            ParameterValue time = ImageMosaicFormat.TIME.createValue();
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{time});
            time.setValue(Arrays.asList(this.parseISO("2008-11-20T00:00:00.000Z"), this.parseISO("2008-11-25T12:00:00.000Z")));
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            Assert.assertTrue((boolean)fc.isEmpty());
            time.setValue(Arrays.asList(this.parseISO("2008-11-04T12:00:00.000Z"), this.parseISO("2008-11-04T18:00:00.000Z")));
            fc = TX.evaluate((Object)ctx);
            Assert.assertTrue((boolean)fc.isEmpty());
            time.setValue(Arrays.asList(this.parseISO("2008-10-28T00:00:00.000Z"), this.parseISO("2008-10-31T18:00:00.000Z")));
            fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)4L, (long)fc.size());
            Set<String> locations = this.collectLocations(fc);
            MatcherAssert.assertThat(locations, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"temp_020_099_20081031T000000_20081103T000000_12_24.tiff", "temp_020_099_20081031T000000_20081103T000000_25_80.tiff", "temp_100_150_20081031T000000_20081103T000000_12_24.tiff", "temp_100_150_20081031T000000_20081103T000000_25_80.tiff"}));
            ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
            elevation.setValue(Arrays.asList(34));
            ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{time, elevation});
            fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)2L, (long)fc.size());
            locations = this.collectLocations(fc);
            MatcherAssert.assertThat(locations, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"temp_020_099_20081031T000000_20081103T000000_12_24.tiff", "temp_020_099_20081031T000000_20081103T000000_25_80.tiff"}));
            ParameterDescriptor wavelengthDescriptor = reader.getDynamicParameters().stream().filter(p -> p.getName().getCode().equalsIgnoreCase("wavelength")).findFirst().get();
            ParameterValue wavelength = wavelengthDescriptor.createValue();
            wavelength.setValue(Arrays.asList(new NumberRange(Double.class, (Number)14.0, (Number)20.0)));
            ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{time, elevation, wavelength});
            fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)1L, (long)fc.size());
            locations = this.collectLocations(fc);
            MatcherAssert.assertThat(locations, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"temp_020_099_20081031T000000_20081103T000000_12_24.tiff"}));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoReadParameters() throws Exception {
        URL rgbURL = TestData.url((Object)this, (String)"rgb");
        AbstractGridFormat format = TestUtils.getFormat(rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(rgbURL, format);
        try {
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, null);
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)24L, (long)fc.size());
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullReadParameterValues() throws Exception {
        URL rgbURL = TestData.url((Object)this, (String)"rgb");
        AbstractGridFormat format = TestUtils.getFormat(rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(rgbURL, format);
        try {
            ParameterValue sort = ImageMosaicFormat.SORT_BY.createValue();
            sort.setValue(null);
            ParameterValue maxTiles = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
            maxTiles.setValue(null);
            ParameterValue time = ImageMosaicFormat.TIME.createValue();
            time.setValue(null);
            ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
            elevation.setValue(null);
            ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
            filter.setValue(null);
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            gg.setValue(null);
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams((GridCoverage2DReader)reader, new GeneralParameterValue[]{sort, maxTiles, time, elevation, filter, gg});
            SimpleFeatureCollection fc = TX.evaluate((Object)ctx);
            Assert.assertEquals((long)24L, (long)fc.size());
        }
        finally {
            reader.dispose();
        }
    }

    private Set<String> collectLocations(SimpleFeatureCollection fc) {
        Set<String> locations = DataUtilities.list((FeatureCollection)fc).stream().map(f -> (String)f.getAttribute("location")).collect(Collectors.toSet());
        return locations;
    }

    private Date parseISO(String s) {
        return Date.from(Instant.parse(s));
    }

    private URL setupWaterTemp(String targetDirectory) throws IOException {
        File workDir = new File(TestData.file((Object)this, (String)"."), targetDirectory);
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)(targetDirectory + "/watertemp.zip"));
        URL timeElevURL = TestData.url((Object)this, (String)targetDirectory);
        return timeElevURL;
    }

    private Class<?> getBinding(SimpleFeatureType schema, String the_geom) {
        return schema.getDescriptor(the_geom).getType().getBinding();
    }
}

